/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Max {
    private Max() {
    }

    public static Combine.Globally<Integer, Integer> integersGlobally() {
        return Combine.globally(new MaxIntegerFn());
    }

    public static <K> Combine.PerKey<K, Integer, Integer> integersPerKey() {
        return Combine.perKey(new MaxIntegerFn());
    }

    public static Combine.Globally<Long, Long> longsGlobally() {
        return Combine.globally(new MaxLongFn());
    }

    public static <K> Combine.PerKey<K, Long, Long> longsPerKey() {
        return Combine.perKey(new MaxLongFn());
    }

    public static Combine.Globally<Double, Double> doublesGlobally() {
        return Combine.globally(new MaxDoubleFn());
    }

    public static <K> Combine.PerKey<K, Double, Double> doublesPerKey() {
        return Combine.perKey(new MaxDoubleFn());
    }

    public static Combine.BinaryCombineIntegerFn ofIntegers() {
        return new MaxIntegerFn();
    }

    public static Combine.BinaryCombineLongFn ofLongs() {
        return new MaxLongFn();
    }

    public static Combine.BinaryCombineDoubleFn ofDoubles() {
        return new MaxDoubleFn();
    }

    public static <T, ComparatorT extends Comparator<? super T> & Serializable> Combine.BinaryCombineFn<T> of(T identity, ComparatorT comparator) {
        return new MaxFn(identity, comparator, null);
    }

    public static <T, ComparatorT extends Comparator<? super T> & Serializable> Combine.BinaryCombineFn<T> of(ComparatorT comparator) {
        return new MaxFn(null, comparator, null);
    }

    public static <T extends Comparable<? super T>> Combine.BinaryCombineFn<T> naturalOrder(T identity) {
        return new MaxFn(identity, new Top.Natural(), null);
    }

    public static <T extends Comparable<? super T>> Combine.BinaryCombineFn<T> naturalOrder() {
        return new MaxFn(null, new Top.Natural(), null);
    }

    public static <T extends Comparable<? super T>> Combine.Globally<T, T> globally() {
        return Combine.globally(Max.naturalOrder());
    }

    public static <K, T extends Comparable<? super T>> Combine.PerKey<K, T, T> perKey() {
        return Combine.perKey(Max.naturalOrder());
    }

    public static <T, ComparatorT extends Comparator<? super T> & Serializable> Combine.Globally<T, T> globally(ComparatorT comparator) {
        return Combine.globally(Max.of(comparator));
    }

    public static <K, T, ComparatorT extends Comparator<? super T> & Serializable> Combine.PerKey<K, T, T> perKey(ComparatorT comparator) {
        return Combine.perKey(Max.of(comparator));
    }

    private static class MaxDoubleFn
    extends Combine.BinaryCombineDoubleFn {
        private MaxDoubleFn() {
        }

        @Override
        public double apply(double left, double right) {
            return Math.max(left, right);
        }

        @Override
        public double identity() {
            return Double.NEGATIVE_INFINITY;
        }
    }

    private static class MaxLongFn
    extends Combine.BinaryCombineLongFn {
        private MaxLongFn() {
        }

        @Override
        public long apply(long left, long right) {
            return Math.max(left, right);
        }

        @Override
        public long identity() {
            return Long.MIN_VALUE;
        }
    }

    private static class MaxIntegerFn
    extends Combine.BinaryCombineIntegerFn {
        private MaxIntegerFn() {
        }

        @Override
        public int apply(int left, int right) {
            return Math.max(left, right);
        }

        @Override
        public int identity() {
            return Integer.MIN_VALUE;
        }
    }

    private static class MaxFn<T>
    extends Combine.BinaryCombineFn<T> {
        private final @Nullable T identity;
        private final Comparator<? super T> comparator;

        private <ComparatorT extends Comparator<? super T> & Serializable> MaxFn(@Nullable T identity, ComparatorT comparator) {
            this.identity = identity;
            this.comparator = comparator;
        }

        @Override
        public T identity() {
            return this.identity;
        }

        @Override
        public T apply(T left, T right) {
            return this.comparator.compare(left, right) >= 0 ? left : right;
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("comparer", this.comparator.getClass()).withLabel("Record Comparer"));
        }

        /* synthetic */ MaxFn(Object x0, Comparator x1, 1 x2) {
            this(x0, x1);
        }
    }
}

