/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.SerializableUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SerializableFunctions {
    public static <InT, OutT extends Serializable> SerializableFunction<InT, OutT> clonesOf(OutT base) {
        return input -> SerializableUtils.clone(base);
    }

    public static <T> SerializableFunction<T, T> identity() {
        return new Identity();
    }

    public static <InT, OutT> SerializableFunction<InT, OutT> constant(@Nullable OutT value) {
        return new Constant(value);
    }

    private static class Constant<InT, OutT>
    implements SerializableFunction<InT, OutT> {
        @Nullable OutT value;

        Constant(@Nullable OutT value) {
            this.value = value;
        }

        @Override
        public OutT apply(InT input) {
            return this.value;
        }
    }

    private static class Identity<T>
    implements SerializableFunction<T, T> {
        private Identity() {
        }

        @Override
        public T apply(T input) {
            return input;
        }
    }
}

