/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class Sets {
    public static <T> PTransform<PCollection<T>, PCollection<T>> intersectDistinct(PCollection<T> rightCollection) {
        Preconditions.checkNotNull(rightCollection, "rightCollection argument is null");
        return new SetImpl(rightCollection, Sets.intersectDistinct());
    }

    public static <T> PTransform<PCollectionList<T>, PCollection<T>> intersectDistinct() {
        SerializableBiFunction intersectFn = (numberOfElementsinLeft, numberOfElementsinRight) -> numberOfElementsinLeft > 0L && numberOfElementsinRight > 0L ? 1L : 0L;
        return new SetImplCollections(intersectFn);
    }

    public static <T> PTransform<PCollection<T>, PCollection<T>> intersectAll(PCollection<T> rightCollection) {
        Preconditions.checkNotNull(rightCollection, "rightCollection argument is null");
        return new SetImpl(rightCollection, Sets.intersectAll());
    }

    public static <T> PTransform<PCollectionList<T>, PCollection<T>> intersectAll() {
        return new SetImplCollections(Math::min);
    }

    public static <T> PTransform<PCollection<T>, PCollection<T>> exceptDistinct(PCollection<T> rightCollection) {
        Preconditions.checkNotNull(rightCollection, "rightCollection argument is null");
        return new SetImpl(rightCollection, Sets.exceptDistinct());
    }

    public static <T> PTransform<PCollectionList<T>, PCollection<T>> exceptDistinct() {
        SerializableBiFunction exceptFn = (numberOfElementsinLeft, numberOfElementsinRight) -> numberOfElementsinLeft > 0L && numberOfElementsinRight == 0L ? 1L : 0L;
        return new SetImplCollections(exceptFn);
    }

    public static <T> PTransform<PCollection<T>, PCollection<T>> exceptAll(PCollection<T> rightCollection) {
        Preconditions.checkNotNull(rightCollection, "rightCollection argument is null");
        return new SetImpl(rightCollection, Sets.exceptAll());
    }

    public static <T> PTransform<PCollectionList<T>, PCollection<T>> exceptAll() {
        SerializableBiFunction exceptFn = (numberOfElementsinLeft, numberOfElementsinRight) -> Math.max(numberOfElementsinLeft - numberOfElementsinRight, 0L);
        return new SetImplCollections(exceptFn);
    }

    public static <T> PTransform<PCollection<T>, PCollection<T>> unionDistinct(PCollection<T> rightCollection) {
        Preconditions.checkNotNull(rightCollection, "rightCollection argument is null");
        return new SetImpl(rightCollection, Sets.unionDistinct());
    }

    public static <T> PTransform<PCollectionList<T>, PCollection<T>> unionDistinct() {
        SerializableBiFunction unionFn = (numberOfElementsinLeft, numberOfElementsinRight) -> 1L;
        return new SetImplCollections(unionFn);
    }

    public static <T> PTransform<PCollection<T>, PCollection<T>> unionAll(PCollection<T> rightCollection) {
        Preconditions.checkNotNull(rightCollection, "rightCollection argument is null");
        return new SetImpl(rightCollection, Sets.unionAll());
    }

    public static <T> Flatten.PCollections<T> unionAll() {
        return Flatten.pCollections();
    }

    private static class SetImplCollections<T>
    extends PTransform<PCollectionList<T>, PCollection<T>> {
        private final SerializableBiFunction<Long, Long, Long> fn;

        private SetImplCollections(SerializableBiFunction<Long, Long, Long> fn) {
            this.fn = fn;
        }

        @Override
        public PCollection<T> expand(PCollectionList<T> input) {
            List<PCollection<T>> all = input.getAll();
            MapElements elementToVoid = MapElements.via(new SimpleFunction<T, KV<T, Void>>(){

                @Override
                public KV<T, Void> apply(T element) {
                    return KV.of(element, null);
                }
            });
            Preconditions.checkArgument(all.size() > 1, "must have at least two input to a PCollectionList");
            PCollection<T> first = all.get(0);
            Pipeline pipeline = first.getPipeline();
            String firstName = first.getName();
            final ArrayList allTags = new ArrayList();
            KeyedPCollectionTuple keyedPCollectionTuple = KeyedPCollectionTuple.empty(pipeline);
            for (PCollection<T> col : all) {
                TupleTag tag = new TupleTag();
                PCollection kvOfElementAndVoid = (PCollection)col.apply("PrepareKVs" + col.getName(), elementToVoid);
                allTags.add(tag);
                keyedPCollectionTuple = keyedPCollectionTuple.and(tag, kvOfElementAndVoid);
            }
            PCollection coGbkResults = (PCollection)keyedPCollectionTuple.apply("CBKAll" + firstName, CoGroupByKey.create());
            PCollection results = (PCollection)coGbkResults.apply("FilterSetElement" + firstName, ParDo.of(new DoFn<KV<T, CoGbkResult>, T>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    KV elementGroups = (KV)c.element();
                    CoGbkResult value = (CoGbkResult)elementGroups.getValue();
                    Object element = elementGroups.getKey();
                    long numberOfOutputs = Iterables.size(value.getAll((TupleTag)allTags.get(0)));
                    List tail = allTags.subList(1, allTags.size());
                    for (TupleTag tag : tail) {
                        long nextSize = Iterables.size(value.getAll(tag));
                        numberOfOutputs = (Long)fn.apply(numberOfOutputs, nextSize);
                    }
                    for (long i = 0L; i < numberOfOutputs; ++i) {
                        c.output(element);
                    }
                }
            }));
            return results.setCoder(first.getCoder());
        }
    }

    private static class SetImpl<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final transient PCollection<T> rightCollection;
        private final PTransform<PCollectionList<T>, PCollection<T>> listTransformFn;

        private SetImpl(PCollection<T> rightCollection, PTransform<PCollectionList<T>, PCollection<T>> listTransformFn) {
            this.rightCollection = rightCollection;
            this.listTransformFn = listTransformFn;
        }

        @Override
        public PCollection<T> expand(PCollection<T> leftCollection) {
            return PCollectionList.of(leftCollection).and(this.rightCollection).apply(this.listTransformFn);
        }
    }
}

