/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DurationCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.SnappyCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.AutoValue_Watch_Growth;
import org.apache.beam.sdk.transforms.AutoValue_Watch_NonPollingGrowthState;
import org.apache.beam.sdk.transforms.AutoValue_Watch_PollingGrowthState;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.OffsetRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Ordering;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Funnel;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Funnels;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.HashCode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Watch {
    private static final Logger LOG = LoggerFactory.getLogger(Watch.class);

    public static <InputT, OutputT> Growth<InputT, OutputT, OutputT> growthOf(Growth.PollFn<InputT, OutputT> pollFn, Requirements requirements) {
        return new AutoValue_Watch_Growth.Builder().setTerminationPerInput(Growth.never()).setPollFn(Contextful.of(pollFn, requirements)).setOutputKeyFn(null).build();
    }

    public static <InputT, OutputT> Growth<InputT, OutputT, OutputT> growthOf(Growth.PollFn<InputT, OutputT> pollFn) {
        return Watch.growthOf(pollFn, Requirements.empty());
    }

    public static <InputT, OutputT, KeyT> Growth<InputT, OutputT, KeyT> growthOf(Contextful<Growth.PollFn<InputT, OutputT>> pollFn, SerializableFunction<OutputT, KeyT> outputKeyFn) {
        Preconditions.checkArgument(pollFn != null, "pollFn can not be null");
        Preconditions.checkArgument(outputKeyFn != null, "outputKeyFn can not be null");
        return new AutoValue_Watch_Growth.Builder().setTerminationPerInput(Growth.never()).setPollFn(pollFn).setOutputKeyFn(outputKeyFn).build();
    }

    static class GrowthStateCoder<OutputT, TerminationStateT>
    extends StructuredCoder<GrowthState> {
        private static final int POLLING_GROWTH_STATE = 0;
        private static final int NON_POLLING_GROWTH_STATE = 1;
        private static final MapCoder<HashCode, Instant> COMPLETED_CODER = MapCoder.of(HashCode128Coder.of(), InstantCoder.of());
        private static final Coder<Instant> NULLABLE_INSTANT_CODER = NullableCoder.of(InstantCoder.of());
        private final Coder<OutputT> outputCoder;
        private final Coder<List<TimestampedValue<OutputT>>> timestampedOutputCoder;
        private final Coder<TerminationStateT> terminationStateCoder;

        public static <OutputT, TerminationStateT> GrowthStateCoder<OutputT, TerminationStateT> of(Coder<OutputT> outputCoder, Coder<TerminationStateT> terminationStateCoder) {
            return new GrowthStateCoder<OutputT, TerminationStateT>(outputCoder, terminationStateCoder);
        }

        private GrowthStateCoder(Coder<OutputT> outputCoder, Coder<TerminationStateT> terminationStateCoder) {
            this.outputCoder = outputCoder;
            this.terminationStateCoder = terminationStateCoder;
            this.timestampedOutputCoder = ListCoder.of(TimestampedValue.TimestampedValueCoder.of(outputCoder));
        }

        @Override
        public void encode(GrowthState value, OutputStream os) throws IOException {
            if (value instanceof PollingGrowthState) {
                VarInt.encode(0, os);
                this.encodePollingGrowthState((PollingGrowthState)value, os);
            } else if (value instanceof NonPollingGrowthState) {
                VarInt.encode(1, os);
                this.encodeNonPollingGrowthState((NonPollingGrowthState)value, os);
            } else {
                throw new IOException("Unknown growth state: " + value);
            }
        }

        private void encodePollingGrowthState(PollingGrowthState<TerminationStateT> value, OutputStream os) throws IOException {
            this.terminationStateCoder.encode(value.getTerminationState(), os);
            NULLABLE_INSTANT_CODER.encode(value.getPollWatermark(), os);
            COMPLETED_CODER.encode((Map<HashCode, Instant>)value.getCompleted(), os);
        }

        private void encodeNonPollingGrowthState(NonPollingGrowthState<OutputT> value, OutputStream os) throws IOException {
            NULLABLE_INSTANT_CODER.encode(value.getPending().getWatermark(), os);
            this.timestampedOutputCoder.encode(value.getPending().getOutputs(), os);
        }

        @Override
        public GrowthState decode(InputStream is) throws IOException {
            int type = VarInt.decodeInt(is);
            switch (type) {
                case 1: {
                    return this.decodeNonPollingGrowthState(is);
                }
                case 0: {
                    return this.decodePollingGrowthState(is);
                }
            }
            throw new IOException("Unknown growth state type " + type);
        }

        private GrowthState decodeNonPollingGrowthState(InputStream is) throws IOException {
            Instant watermark = NULLABLE_INSTANT_CODER.decode(is);
            List<TimestampedValue<OutputT>> values = this.timestampedOutputCoder.decode(is);
            return NonPollingGrowthState.of(new Growth.PollResult(values, watermark));
        }

        private GrowthState decodePollingGrowthState(InputStream is) throws IOException {
            TerminationStateT terminationState = this.terminationStateCoder.decode(is);
            Instant watermark = NULLABLE_INSTANT_CODER.decode(is);
            Object completed = COMPLETED_CODER.decode(is);
            return PollingGrowthState.of(ImmutableMap.copyOf(completed), watermark, terminationState);
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.outputCoder, this.terminationStateCoder);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.outputCoder.verifyDeterministic();
        }
    }

    private static class HashCode128Coder
    extends AtomicCoder<HashCode> {
        private static final HashCode128Coder INSTANCE = new HashCode128Coder();

        private HashCode128Coder() {
        }

        public static HashCode128Coder of() {
            return INSTANCE;
        }

        @Override
        public void encode(HashCode value, OutputStream os) throws IOException {
            Preconditions.checkArgument(value.bits() == 128, "Expected a 128-bit hash code, but got %s bits", value.bits());
            byte[] res = new byte[16];
            value.writeBytesTo(res, 0, 16);
            os.write(res);
        }

        @Override
        public HashCode decode(InputStream is) throws IOException {
            byte[] res = new byte[16];
            int numRead = is.read(res, 0, 16);
            Preconditions.checkArgument(numRead == 16, "Expected to read 16 bytes, but read %s", numRead);
            return HashCode.fromBytes(res);
        }
    }

    @VisibleForTesting
    static class GrowthTracker<OutputT, TerminationStateT>
    extends RestrictionTracker<GrowthState, KV<Growth.PollResult<OutputT>, TerminationStateT>> {
        static final GrowthState EMPTY_STATE = NonPollingGrowthState.of(new Growth.PollResult(Collections.emptyList(), null));
        private final Funnel<OutputT> coderFunnel;
        private @Nullable Growth.PollResult<OutputT> claimedPollResult;
        private @Nullable TerminationStateT claimedTerminationState;
        private @Nullable ImmutableMap<HashCode, Instant> claimedHashes;
        private GrowthState state;
        private boolean shouldStop;

        GrowthTracker(GrowthState state, Funnel<OutputT> coderFunnel) {
            this.state = state;
            this.coderFunnel = coderFunnel;
            this.shouldStop = false;
        }

        @Override
        public GrowthState currentRestriction() {
            return this.state;
        }

        @Override
        public SplitResult<GrowthState> trySplit(double fractionOfRemainder) {
            PollingGrowthState<TerminationStateT> residual;
            if (this.claimedPollResult == null) {
                residual = this.state;
                this.state = EMPTY_STATE;
            } else if (this.state instanceof NonPollingGrowthState) {
                residual = EMPTY_STATE;
            } else {
                PollingGrowthState currentState = (PollingGrowthState)this.state;
                ImmutableMap.Builder<HashCode, Instant> newCompleted = ImmutableMap.builder();
                newCompleted.putAll(currentState.getCompleted());
                newCompleted.putAll(this.claimedHashes);
                residual = PollingGrowthState.of(newCompleted.build(), Ordering.natural().nullsFirst().max(currentState.getPollWatermark(), ((Growth.PollResult)this.claimedPollResult).watermark), this.claimedTerminationState);
                this.state = NonPollingGrowthState.of(this.claimedPollResult);
            }
            this.shouldStop = true;
            return SplitResult.of(this.state, residual);
        }

        private HashCode hash128(OutputT value) {
            return Hashing.murmur3_128().hashObject(value, this.coderFunnel);
        }

        @Override
        public void checkDone() throws IllegalStateException {
            Preconditions.checkState(this.shouldStop, "Missing tryClaim()/checkpoint() call. Expected one or the other.");
        }

        @Override
        public RestrictionTracker.IsBounded isBounded() {
            if (this.state == EMPTY_STATE || this.state instanceof NonPollingGrowthState) {
                return RestrictionTracker.IsBounded.BOUNDED;
            }
            return RestrictionTracker.IsBounded.UNBOUNDED;
        }

        @Override
        public boolean tryClaim(KV<Growth.PollResult<OutputT>, TerminationStateT> pollResult) {
            if (this.shouldStop) {
                return false;
            }
            ImmutableMap.Builder<HashCode, Instant> newClaimedHashesBuilder = ImmutableMap.builder();
            for (TimestampedValue<OutputT> value : pollResult.getKey().getOutputs()) {
                HashCode hash = this.hash128(value.getValue());
                newClaimedHashesBuilder.put(hash, value.getTimestamp());
            }
            ImmutableMap newClaimedHashes = newClaimedHashesBuilder.build();
            if (this.state instanceof PollingGrowthState) {
                if (!Collections.disjoint(newClaimedHashes.keySet(), ((PollingGrowthState)this.state).getCompleted().keySet())) {
                    return false;
                }
            } else {
                HashSet<HashCode> expectedHashesToClaim = new HashSet<HashCode>();
                for (TimestampedValue value : ((NonPollingGrowthState)this.state).getPending().getOutputs()) {
                    expectedHashesToClaim.add(this.hash128(value.getValue()));
                }
                if (!expectedHashesToClaim.equals(newClaimedHashes.keySet())) {
                    return false;
                }
            }
            this.shouldStop = true;
            this.claimedPollResult = pollResult.getKey();
            this.claimedTerminationState = pollResult.getValue();
            this.claimedHashes = newClaimedHashes;
            return true;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("state", this.state).add("pollResult", this.claimedPollResult).add("terminationState", this.claimedTerminationState).add("shouldStop", this.shouldStop).toString();
        }
    }

    @AutoValue
    @VisibleForTesting
    static abstract class PollingGrowthState<TerminationStateT>
    extends GrowthState {
        PollingGrowthState() {
        }

        public static <TerminationStateT> PollingGrowthState<TerminationStateT> of(TerminationStateT terminationState) {
            return new AutoValue_Watch_PollingGrowthState<TerminationStateT>(ImmutableMap.of(), null, terminationState);
        }

        public static <TerminationStateT> PollingGrowthState<TerminationStateT> of(ImmutableMap<HashCode, Instant> completed, Instant pollWatermark, TerminationStateT terminationState) {
            return new AutoValue_Watch_PollingGrowthState<TerminationStateT>(completed, pollWatermark, terminationState);
        }

        public abstract ImmutableMap<HashCode, Instant> getCompleted();

        public abstract @Nullable Instant getPollWatermark();

        public abstract TerminationStateT getTerminationState();
    }

    @AutoValue
    @VisibleForTesting
    static abstract class NonPollingGrowthState<OutputT>
    extends GrowthState {
        NonPollingGrowthState() {
        }

        public static <OutputT> NonPollingGrowthState<OutputT> of(Growth.PollResult<OutputT> pending) {
            return new AutoValue_Watch_NonPollingGrowthState<OutputT>(pending);
        }

        public abstract Growth.PollResult<OutputT> getPending();
    }

    static abstract class GrowthState {
        GrowthState() {
        }
    }

    @DoFn.UnboundedPerElement
    @VisibleForTesting
    protected static class WatchGrowthFn<InputT, OutputT, KeyT, TerminationStateT>
    extends DoFn<InputT, KV<InputT, List<TimestampedValue<OutputT>>>> {
        private final Growth<InputT, OutputT, KeyT> spec;
        private final Coder<OutputT> outputCoder;
        private final SerializableFunction<OutputT, KeyT> outputKeyFn;
        private final Coder<KeyT> outputKeyCoder;
        private final Funnel<OutputT> coderFunnel;

        WatchGrowthFn(Growth<InputT, OutputT, KeyT> spec, Coder<OutputT> outputCoder, SerializableFunction<OutputT, KeyT> outputKeyFn, Coder<KeyT> outputKeyCoder) {
            this.spec = spec;
            this.outputCoder = outputCoder;
            this.outputKeyFn = outputKeyFn;
            this.outputKeyCoder = outputKeyCoder;
            this.coderFunnel = (from, into) -> {
                try {
                    Object outputKey = outputKeyFn.apply(from);
                    outputKeyCoder.encode(outputKey, Funnels.asOutputStream(into));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        @DoFn.GetInitialWatermarkEstimatorState
        public Instant getInitialWatermarkEstimatorState(@DoFn.Timestamp Instant currentElementTimestamp) {
            return currentElementTimestamp;
        }

        @DoFn.NewWatermarkEstimator
        public WatermarkEstimators.Manual newWatermarkEstimator(@DoFn.WatermarkEstimatorState Instant watermarkEstimatorState) {
            return new WatermarkEstimators.Manual(watermarkEstimatorState);
        }

        @DoFn.ProcessElement
        public DoFn.ProcessContinuation process(DoFn.ProcessContext c, RestrictionTracker<GrowthState, KV<Growth.PollResult<OutputT>, TerminationStateT>> tracker, ManualWatermarkEstimator<Instant> watermarkEstimator) throws Exception {
            GrowthState currentRestriction = tracker.currentRestriction();
            if (currentRestriction instanceof NonPollingGrowthState) {
                Growth.PollResult priorPoll = ((NonPollingGrowthState)currentRestriction).getPending();
                if (tracker.tryClaim(KV.of(priorPoll, null)) && !priorPoll.getOutputs().isEmpty()) {
                    LOG.info("{} - re-emitting output of prior poll containing {} results.", c.element(), (Object)priorPoll.getOutputs().size());
                    c.output(KV.of(c.element(), priorPoll.getOutputs()));
                }
                return DoFn.ProcessContinuation.stop();
            }
            Instant now = Instant.now();
            Growth.PollResult res = (Growth.PollResult)this.spec.getPollFn().getClosure().apply(c.element(), Contextful.Fn.Context.wrapProcessContext(c));
            PollingGrowthState pollingRestriction = (PollingGrowthState)currentRestriction;
            Growth.PollResult newResults = this.computeNeverSeenBeforeResults(pollingRestriction, res);
            LOG.info("{} - current round of polling took {} ms and returned {} results, of which {} were new.", c.element(), new Duration(now, Instant.now()).getMillis(), res.getOutputs().size(), newResults.getOutputs().size());
            Object terminationState = pollingRestriction.getTerminationState();
            if (!newResults.getOutputs().isEmpty()) {
                terminationState = this.getTerminationCondition().onSeenNewOutput(Instant.now(), terminationState);
            }
            if (!tracker.tryClaim(KV.of(newResults, terminationState = this.getTerminationCondition().onPollComplete(terminationState)))) {
                LOG.info("{} - will not emit poll result tryClaim failed.", c.element());
                return DoFn.ProcessContinuation.stop();
            }
            if (!newResults.getOutputs().isEmpty()) {
                c.output(KV.of(c.element(), newResults.getOutputs()));
            }
            Instant computedWatermark = null;
            if (newResults.getWatermark() != null) {
                computedWatermark = newResults.getWatermark();
            } else if (!newResults.getOutputs().isEmpty()) {
                computedWatermark = newResults.getOutputs().get(0).getTimestamp();
            }
            Instant currentTime = Instant.now();
            if (this.getTerminationCondition().canStopPolling(currentTime, terminationState)) {
                LOG.info("{} - told to stop polling by polling function at {} with termination state {}.", c.element(), currentTime, this.getTerminationCondition().toString(terminationState));
                return DoFn.ProcessContinuation.stop();
            }
            if (BoundedWindow.TIMESTAMP_MAX_VALUE.equals(computedWatermark)) {
                LOG.info("{} - will stop polling, reached max timestamp.", c.element());
                return DoFn.ProcessContinuation.stop();
            }
            if (computedWatermark != null) {
                watermarkEstimator.setWatermark(computedWatermark);
            }
            LOG.info("{} - will resume polling in {} ms.", c.element(), (Object)this.spec.getPollInterval().getMillis());
            return DoFn.ProcessContinuation.resume().withResumeDelay(this.spec.getPollInterval());
        }

        private HashCode hash128(OutputT value) {
            return Hashing.murmur3_128().hashObject(value, this.coderFunnel);
        }

        private Growth.PollResult computeNeverSeenBeforeResults(PollingGrowthState<TerminationStateT> state, Growth.PollResult<OutputT> pollResult) {
            HashMap<HashCode, TimestampedValue<OutputT>> newPending = Maps.newHashMap();
            for (TimestampedValue<OutputT> output : pollResult.getOutputs()) {
                OutputT value2 = output.getValue();
                HashCode hash = this.hash128(value2);
                if (state.getCompleted().containsKey(hash) || newPending.containsKey(hash)) continue;
                newPending.put(hash, output);
            }
            return pollResult.withOutputs(Ordering.natural().onResultOf(value -> value.getTimestamp()).sortedCopy(newPending.values()));
        }

        private Growth.TerminationCondition<InputT, TerminationStateT> getTerminationCondition() {
            return this.spec.getTerminationPerInput();
        }

        @DoFn.GetInitialRestriction
        public GrowthState getInitialRestriction(@DoFn.Element InputT element) {
            return PollingGrowthState.of(this.getTerminationCondition().forNewInput(Instant.now(), element));
        }

        @DoFn.NewTracker
        public GrowthTracker<OutputT, TerminationStateT> newTracker(@DoFn.Restriction GrowthState restriction) {
            return new GrowthTracker(restriction, this.coderFunnel);
        }

        @DoFn.GetRestrictionCoder
        public Coder<GrowthState> getRestrictionCoder() {
            return SnappyCoder.of(GrowthStateCoder.of(this.outputCoder, this.spec.getTerminationPerInput().getStateCoder()));
        }
    }

    @DoFn.BoundedPerElement
    private static class PollResultSplitFn<InputT, OutputT>
    extends DoFn<KV<InputT, List<TimestampedValue<OutputT>>>, KV<InputT, OutputT>> {
        private PollResultSplitFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, RestrictionTracker<OffsetRange, Long> tracker) {
            long position = tracker.currentRestriction().getFrom();
            while (tracker.tryClaim(position)) {
                TimestampedValue value = (TimestampedValue)((List)((KV)c.element()).getValue()).get((int)position);
                c.outputWithTimestamp(KV.of(((KV)c.element()).getKey(), value.getValue()), value.getTimestamp());
                ++position;
            }
        }

        @DoFn.GetInitialWatermarkEstimatorState
        public Instant getInitialWatermarkEstimatorState(@DoFn.Timestamp Instant currentElementTimestamp) {
            return currentElementTimestamp;
        }

        @DoFn.NewWatermarkEstimator
        public WatermarkEstimators.MonotonicallyIncreasing newWatermarkEstimator(@DoFn.WatermarkEstimatorState Instant watermarkEstimatorState) {
            return new WatermarkEstimators.MonotonicallyIncreasing(watermarkEstimatorState);
        }

        @DoFn.GetInitialRestriction
        public OffsetRange getInitialRestriction(@DoFn.Element KV<InputT, List<TimestampedValue<OutputT>>> element) {
            return new OffsetRange(0L, element.getValue().size());
        }

        @DoFn.NewTracker
        public OffsetRangeTracker newTracker(@DoFn.Restriction OffsetRange restriction) {
            return restriction.newTracker();
        }

        @DoFn.GetRestrictionCoder
        public Coder<OffsetRange> getRestrictionCoder() {
            return OffsetRange.Coder.of();
        }
    }

    @AutoValue
    public static abstract class Growth<InputT, OutputT, KeyT>
    extends PTransform<PCollection<InputT>, PCollection<KV<InputT, OutputT>>> {
        public static <InputT> Never<InputT> never() {
            return new Never();
        }

        public static <InputT, StateT> TerminationCondition<InputT, StateT> ignoreInput(TerminationCondition<?, StateT> condition) {
            return new IgnoreInput(condition);
        }

        public static <InputT> AfterTotalOf<InputT> afterTotalOf(ReadableDuration timeSinceInput) {
            return Growth.afterTotalOf(SerializableFunctions.constant(timeSinceInput));
        }

        public static <InputT> AfterTotalOf<InputT> afterTotalOf(SerializableFunction<InputT, ReadableDuration> timeSinceInput) {
            return new AfterTotalOf(timeSinceInput);
        }

        public static <InputT> AfterTimeSinceNewOutput<InputT> afterTimeSinceNewOutput(ReadableDuration timeSinceNewOutput) {
            return Growth.afterTimeSinceNewOutput(SerializableFunctions.constant(timeSinceNewOutput));
        }

        public static <InputT> AfterTimeSinceNewOutput<InputT> afterTimeSinceNewOutput(SerializableFunction<InputT, ReadableDuration> timeSinceNewOutput) {
            return new AfterTimeSinceNewOutput(timeSinceNewOutput);
        }

        public static <InputT> AfterIterations<InputT> afterIterations(int iterations) {
            return new AfterIterations(iterations);
        }

        public static <InputT, FirstStateT, SecondStateT> BinaryCombined<InputT, FirstStateT, SecondStateT> eitherOf(TerminationCondition<InputT, FirstStateT> first, TerminationCondition<InputT, SecondStateT> second) {
            return new BinaryCombined<InputT, FirstStateT, SecondStateT>(BinaryCombined.Operation.OR, first, second);
        }

        public static <InputT, FirstStateT, SecondStateT> BinaryCombined<InputT, FirstStateT, SecondStateT> allOf(TerminationCondition<InputT, FirstStateT> first, TerminationCondition<InputT, SecondStateT> second) {
            return new BinaryCombined<InputT, FirstStateT, SecondStateT>(BinaryCombined.Operation.AND, first, second);
        }

        abstract Contextful<PollFn<InputT, OutputT>> getPollFn();

        abstract @Nullable SerializableFunction<OutputT, KeyT> getOutputKeyFn();

        abstract @Nullable Coder<KeyT> getOutputKeyCoder();

        abstract @Nullable Duration getPollInterval();

        abstract @Nullable TerminationCondition<InputT, ?> getTerminationPerInput();

        abstract @Nullable Coder<OutputT> getOutputCoder();

        abstract Builder<InputT, OutputT, KeyT> toBuilder();

        public Growth<InputT, OutputT, KeyT> withOutputKeyCoder(Coder<KeyT> outputKeyCoder) {
            return this.toBuilder().setOutputKeyCoder(outputKeyCoder).build();
        }

        public Growth<InputT, OutputT, KeyT> withTerminationPerInput(TerminationCondition<InputT, ?> terminationPerInput) {
            return this.toBuilder().setTerminationPerInput(terminationPerInput).build();
        }

        public Growth<InputT, OutputT, KeyT> withPollInterval(Duration pollInterval) {
            return this.toBuilder().setPollInterval(pollInterval).build();
        }

        public Growth<InputT, OutputT, KeyT> withOutputCoder(Coder<OutputT> outputCoder) {
            return this.toBuilder().setOutputCoder(outputCoder).build();
        }

        @Override
        public PCollection<KV<InputT, OutputT>> expand(PCollection<InputT> input) {
            Preconditions.checkNotNull(this.getPollInterval(), "pollInterval");
            Preconditions.checkNotNull(this.getTerminationPerInput(), "terminationPerInput");
            Coder<Object> outputCoder = this.getOutputCoder();
            if (outputCoder == null) {
                TypeDescriptor outputT = TypeDescriptors.extractFromTypeParameters(this.getPollFn().getClosure(), PollFn.class, new TypeDescriptors.TypeVariableExtractor<PollFn<InputT, OutputT>, OutputT>(){});
                try {
                    outputCoder = input.getPipeline().getCoderRegistry().getCoder(outputT);
                }
                catch (CannotProvideCoderException e) {
                    throw new RuntimeException("Unable to infer coder for OutputT (" + outputT + "). Specify it explicitly using withOutputCoder().");
                }
            }
            Coder<Object> outputKeyCoder = this.getOutputKeyCoder();
            SerializableFunction<Object, Object> outputKeyFn = this.getOutputKeyFn();
            if (this.getOutputKeyFn() == null) {
                outputKeyCoder = outputCoder;
                outputKeyFn = SerializableFunctions.identity();
            } else {
                if (outputKeyCoder == null) {
                    TypeDescriptor<KeyT> keyT = TypeDescriptors.outputOf(this.getOutputKeyFn());
                    try {
                        outputKeyCoder = input.getPipeline().getCoderRegistry().getCoder(keyT);
                    }
                    catch (CannotProvideCoderException e) {
                        throw new RuntimeException("Unable to infer coder for KeyT (" + keyT + "). Specify it explicitly using withOutputKeyCoder().");
                    }
                }
                try {
                    outputKeyCoder.verifyDeterministic();
                }
                catch (Coder.NonDeterministicException e) {
                    throw new IllegalArgumentException("Key coder " + outputKeyCoder + " must be deterministic");
                }
            }
            PCollection polledPc = ((PCollection)input.apply(ParDo.of(new WatchGrowthFn(this, outputCoder, outputKeyFn, outputKeyCoder)).withSideInputs(this.getPollFn().getRequirements().getSideInputs()))).setCoder(KvCoder.of(input.getCoder(), ListCoder.of(TimestampedValue.TimestampedValueCoder.of(outputCoder))));
            return ((PCollection)polledPc.apply(ParDo.of(new PollResultSplitFn()))).setCoder(KvCoder.of(input.getCoder(), outputCoder));
        }

        @AutoValue.Builder
        static abstract class Builder<InputT, OutputT, KeyT> {
            Builder() {
            }

            abstract Builder<InputT, OutputT, KeyT> setPollFn(Contextful<PollFn<InputT, OutputT>> var1);

            abstract Builder<InputT, OutputT, KeyT> setOutputKeyFn(@Nullable SerializableFunction<OutputT, KeyT> var1);

            abstract Builder<InputT, OutputT, KeyT> setOutputKeyCoder(Coder<KeyT> var1);

            abstract Builder<InputT, OutputT, KeyT> setTerminationPerInput(TerminationCondition<InputT, ?> var1);

            abstract Builder<InputT, OutputT, KeyT> setPollInterval(Duration var1);

            abstract Builder<InputT, OutputT, KeyT> setOutputCoder(Coder<OutputT> var1);

            abstract Growth<InputT, OutputT, KeyT> build();
        }

        static class BinaryCombined<InputT, FirstStateT, SecondStateT>
        implements TerminationCondition<InputT, KV<FirstStateT, SecondStateT>> {
            private final Operation operation;
            private final TerminationCondition<InputT, FirstStateT> first;
            private final TerminationCondition<InputT, SecondStateT> second;

            public BinaryCombined(Operation operation, TerminationCondition<InputT, FirstStateT> first, TerminationCondition<InputT, SecondStateT> second) {
                this.operation = operation;
                this.first = first;
                this.second = second;
            }

            @Override
            public Coder<KV<FirstStateT, SecondStateT>> getStateCoder() {
                return KvCoder.of(this.first.getStateCoder(), this.second.getStateCoder());
            }

            @Override
            public KV<FirstStateT, SecondStateT> forNewInput(Instant now, InputT input) {
                return KV.of(this.first.forNewInput(now, input), this.second.forNewInput(now, input));
            }

            @Override
            public KV<FirstStateT, SecondStateT> onSeenNewOutput(Instant now, KV<FirstStateT, SecondStateT> state) {
                return KV.of(this.first.onSeenNewOutput(now, state.getKey()), this.second.onSeenNewOutput(now, state.getValue()));
            }

            @Override
            public KV<FirstStateT, SecondStateT> onPollComplete(KV<FirstStateT, SecondStateT> state) {
                return KV.of(this.first.onPollComplete(state.getKey()), this.second.onPollComplete(state.getValue()));
            }

            @Override
            public boolean canStopPolling(Instant now, KV<FirstStateT, SecondStateT> state) {
                switch (this.operation) {
                    case OR: {
                        return this.first.canStopPolling(now, state.getKey()) || this.second.canStopPolling(now, state.getValue());
                    }
                    case AND: {
                        return this.first.canStopPolling(now, state.getKey()) && this.second.canStopPolling(now, state.getValue());
                    }
                }
                throw new UnsupportedOperationException("Unexpected operation " + (Object)((Object)this.operation));
            }

            @Override
            public String toString(KV<FirstStateT, SecondStateT> state) {
                return (Object)((Object)this.operation) + "{first=" + this.first.toString(state.getKey()) + ", second=" + this.second.toString(state.getValue()) + '}';
            }

            private static enum Operation {
                OR,
                AND;

            }
        }

        static class AfterTimeSinceNewOutput<InputT>
        implements TerminationCondition<InputT, KV<Instant, ReadableDuration>> {
            private final SerializableFunction<InputT, ReadableDuration> maxTimeSinceNewOutput;

            private AfterTimeSinceNewOutput(SerializableFunction<InputT, ReadableDuration> maxTimeSinceNewOutput) {
                this.maxTimeSinceNewOutput = maxTimeSinceNewOutput;
            }

            @Override
            public Coder<KV<Instant, ReadableDuration>> getStateCoder() {
                return KvCoder.of(NullableCoder.of(InstantCoder.of()), DurationCoder.of());
            }

            @Override
            public KV<Instant, ReadableDuration> forNewInput(Instant now, InputT input) {
                return KV.of(null, this.maxTimeSinceNewOutput.apply(input));
            }

            @Override
            public KV<Instant, ReadableDuration> onSeenNewOutput(Instant now, KV<Instant, ReadableDuration> state) {
                return KV.of(now, state.getValue());
            }

            @Override
            public boolean canStopPolling(Instant now, KV<Instant, ReadableDuration> state) {
                Instant timeOfLastNewOutput = state.getKey();
                ReadableDuration maxTimeSinceNewOutput = state.getValue();
                return timeOfLastNewOutput != null && new Duration(timeOfLastNewOutput, now).isLongerThan(maxTimeSinceNewOutput);
            }

            @Override
            public String toString(KV<Instant, ReadableDuration> state) {
                return "AfterTimeSinceNewOutput{timeOfLastNewOutput=" + state.getKey() + ", maxTimeSinceNewOutput=" + state.getValue() + '}';
            }
        }

        static class AfterIterations<InputT>
        implements TerminationCondition<InputT, Integer> {
            private final int maxIterations;

            private AfterIterations(int maxIterations) {
                this.maxIterations = maxIterations;
            }

            @Override
            public Coder<Integer> getStateCoder() {
                return VarIntCoder.of();
            }

            @Override
            public Integer forNewInput(Instant now, InputT input) {
                return 0;
            }

            @Override
            public Integer onPollComplete(Integer state) {
                return state + 1;
            }

            @Override
            public boolean canStopPolling(Instant now, Integer state) {
                return state >= this.maxIterations;
            }

            @Override
            public String toString(Integer state) {
                return "AfterIterations{iterations=" + state + ", maxIterations=" + this.maxIterations + '}';
            }
        }

        static class AfterTotalOf<InputT>
        implements TerminationCondition<InputT, KV<Instant, ReadableDuration>> {
            private final SerializableFunction<InputT, ReadableDuration> maxTimeSinceInput;

            private AfterTotalOf(SerializableFunction<InputT, ReadableDuration> maxTimeSinceInput) {
                this.maxTimeSinceInput = maxTimeSinceInput;
            }

            @Override
            public Coder<KV<Instant, ReadableDuration>> getStateCoder() {
                return KvCoder.of(InstantCoder.of(), DurationCoder.of());
            }

            @Override
            public KV<Instant, ReadableDuration> forNewInput(Instant now, InputT input) {
                return KV.of(now, this.maxTimeSinceInput.apply(input));
            }

            @Override
            public boolean canStopPolling(Instant now, KV<Instant, ReadableDuration> state) {
                return new Duration(state.getKey(), now).isLongerThan(state.getValue());
            }

            @Override
            public String toString(KV<Instant, ReadableDuration> state) {
                return "AfterTotalOf{timeStarted=" + state.getKey() + ", maxTimeSinceInput=" + state.getValue() + '}';
            }
        }

        static class IgnoreInput<InputT, StateT>
        implements TerminationCondition<InputT, StateT> {
            private final TerminationCondition<?, StateT> wrapped;

            IgnoreInput(TerminationCondition<?, StateT> wrapped) {
                this.wrapped = wrapped;
            }

            @Override
            public Coder<StateT> getStateCoder() {
                return this.wrapped.getStateCoder();
            }

            @Override
            public StateT forNewInput(Instant now, InputT input) {
                return this.wrapped.forNewInput(now, null);
            }

            @Override
            public StateT onSeenNewOutput(Instant now, StateT state) {
                return this.wrapped.onSeenNewOutput(now, state);
            }

            @Override
            public StateT onPollComplete(StateT state) {
                return this.wrapped.onPollComplete(state);
            }

            @Override
            public boolean canStopPolling(Instant now, StateT state) {
                return this.wrapped.canStopPolling(now, state);
            }

            @Override
            public String toString(StateT state) {
                return this.wrapped.toString(state);
            }
        }

        static class Never<InputT>
        implements TerminationCondition<InputT, Integer> {
            Never() {
            }

            @Override
            public Coder<Integer> getStateCoder() {
                return VarIntCoder.of();
            }

            @Override
            public Integer forNewInput(Instant now, InputT input) {
                return 0;
            }

            @Override
            public boolean canStopPolling(Instant now, Integer state) {
                return false;
            }

            @Override
            public String toString(Integer state) {
                return "Never";
            }
        }

        public static interface TerminationCondition<InputT, StateT>
        extends Serializable {
            public Coder<StateT> getStateCoder();

            public StateT forNewInput(Instant var1, @Nullable InputT var2);

            default public StateT onSeenNewOutput(Instant now, StateT state) {
                return state;
            }

            default public StateT onPollComplete(StateT state) {
                return state;
            }

            public boolean canStopPolling(Instant var1, StateT var2);

            public String toString(StateT var1);
        }

        public static abstract class PollFn<InputT, OutputT>
        implements Contextful.Fn<InputT, PollResult<OutputT>> {
        }

        public static final class PollResult<OutputT> {
            private final List<TimestampedValue<OutputT>> outputs;
            private final @Nullable Instant watermark;

            private PollResult(List<TimestampedValue<OutputT>> outputs, @Nullable Instant watermark) {
                this.outputs = outputs;
                this.watermark = watermark;
            }

            List<TimestampedValue<OutputT>> getOutputs() {
                return this.outputs;
            }

            @Nullable Instant getWatermark() {
                return this.watermark;
            }

            public PollResult<OutputT> withWatermark(Instant watermark) {
                Preconditions.checkNotNull(watermark, "watermark");
                return new PollResult<OutputT>(this.outputs, watermark);
            }

            public PollResult<OutputT> withOutputs(List<TimestampedValue<OutputT>> outputs) {
                Preconditions.checkNotNull(outputs);
                return new PollResult<OutputT>(outputs, this.watermark);
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("watermark", this.watermark).add("outputs", this.outputs).toString();
            }

            public static <OutputT> PollResult<OutputT> complete(List<TimestampedValue<OutputT>> outputs) {
                return new PollResult<OutputT>(outputs, BoundedWindow.TIMESTAMP_MAX_VALUE);
            }

            public static <OutputT> PollResult<OutputT> complete(Instant timestamp, List<OutputT> outputs) {
                return new PollResult<OutputT>(PollResult.addTimestamp(timestamp, outputs), BoundedWindow.TIMESTAMP_MAX_VALUE);
            }

            public static <OutputT> PollResult<OutputT> incomplete(List<TimestampedValue<OutputT>> outputs) {
                return new PollResult<OutputT>(outputs, null);
            }

            public static <OutputT> PollResult<OutputT> incomplete(Instant timestamp, List<OutputT> outputs) {
                return new PollResult<OutputT>(PollResult.addTimestamp(timestamp, outputs), null);
            }

            private static <OutputT> List<TimestampedValue<OutputT>> addTimestamp(Instant timestamp, List<OutputT> outputs) {
                ArrayList<TimestampedValue<OutputT>> res = Lists.newArrayListWithExpectedSize(outputs.size());
                for (OutputT output : outputs) {
                    res.add(TimestampedValue.of(output, timestamp));
                }
                return res;
            }

            public boolean equals(@Nullable Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PollResult that = (PollResult)o;
                return Objects.equals(this.outputs, that.outputs) && Objects.equals(this.watermark, that.watermark);
            }

            public int hashCode() {
                return Objects.hash(this.outputs, this.watermark);
            }
        }
    }
}

