/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.display;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.AutoValue_DisplayData_Identifier;
import org.apache.beam.sdk.transforms.display.AutoValue_DisplayData_Item;
import org.apache.beam.sdk.transforms.display.AutoValue_DisplayData_ItemSpec;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DisplayData
implements Serializable {
    private static final DisplayData EMPTY = new DisplayData(Maps.newHashMap());
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private final ImmutableMap<Identifier, Item> entries;

    private DisplayData(Map<Identifier, Item> entries) {
        this.entries = ImmutableMap.copyOf(entries);
    }

    public static DisplayData none() {
        return EMPTY;
    }

    public static DisplayData from(HasDisplayData component) {
        Preconditions.checkNotNull(component, "component argument cannot be null");
        InternalBuilder builder = new InternalBuilder();
        builder.include(Path.root(), component);
        return builder.build();
    }

    public static @Nullable Type inferType(@Nullable Object value) {
        return Type.tryInferFrom(value);
    }

    @JsonValue
    public Collection<Item> items() {
        return this.entries.values();
    }

    public Map<Identifier, Item> asMap() {
        return this.entries;
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof DisplayData) {
            DisplayData that = (DisplayData)obj;
            return Objects.equals(this.entries, that.entries);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean isFirstLine = true;
        for (Item entry : this.entries.values()) {
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                builder.append("\n");
            }
            builder.append(entry);
        }
        return builder.toString();
    }

    public static ItemSpec<String> item(String key, @Nullable String value) {
        return DisplayData.item(key, Type.STRING, value);
    }

    public static ItemSpec<?> item(String key, @Nullable ValueProvider<?> value) {
        if (value == null) {
            return DisplayData.item(key, Type.STRING, null);
        }
        if (value.isAccessible()) {
            Object got = value.get();
            if (got == null) {
                return DisplayData.item(key, Type.STRING, null);
            }
            Type type = DisplayData.inferType(got);
            if (type != null) {
                return DisplayData.item(key, type, got);
            }
        }
        return DisplayData.item(key, Type.STRING, String.valueOf(value));
    }

    public static ItemSpec<Integer> item(String key, @Nullable Integer value) {
        return DisplayData.item(key, Type.INTEGER, value);
    }

    public static ItemSpec<Long> item(String key, @Nullable Long value) {
        return DisplayData.item(key, Type.INTEGER, value);
    }

    public static ItemSpec<Float> item(String key, @Nullable Float value) {
        return DisplayData.item(key, Type.FLOAT, value);
    }

    public static ItemSpec<Double> item(String key, @Nullable Double value) {
        return DisplayData.item(key, Type.FLOAT, value);
    }

    public static ItemSpec<Boolean> item(String key, @Nullable Boolean value) {
        return DisplayData.item(key, Type.BOOLEAN, value);
    }

    public static ItemSpec<Instant> item(String key, @Nullable Instant value) {
        return DisplayData.item(key, Type.TIMESTAMP, value);
    }

    public static ItemSpec<Duration> item(String key, @Nullable Duration value) {
        return DisplayData.item(key, Type.DURATION, value);
    }

    public static <T> ItemSpec<Class<T>> item(String key, @Nullable Class<T> value) {
        return DisplayData.item(key, Type.JAVA_CLASS, value);
    }

    public static <T> ItemSpec<T> item(String key, Type type, @Nullable T value) {
        Preconditions.checkNotNull(key, "key argument cannot be null");
        Preconditions.checkNotNull(type, "type argument cannot be null");
        return ItemSpec.create(key, type, value);
    }

    private static class InternalBuilder
    implements Builder {
        private final Map<Identifier, Item> entries = Maps.newHashMap();
        private final Set<HasDisplayData> visitedComponents = Sets.newIdentityHashSet();
        private final Map<Path, HasDisplayData> visitedPathMap = Maps.newHashMap();
        private @Nullable Path latestPath;
        private @Nullable Class<?> latestNs;

        private InternalBuilder() {
        }

        @Override
        public Builder include(String path, HasDisplayData subComponent) {
            Preconditions.checkNotNull(subComponent, "subComponent argument cannot be null");
            Preconditions.checkNotNull(path, "path argument cannot be null");
            Path absolutePath = this.latestPath.extend(path);
            HasDisplayData existingComponent = this.visitedPathMap.get(absolutePath);
            if (existingComponent != null) {
                throw new IllegalArgumentException(String.format("Specified path '%s' already used for subcomponent %s. Subcomponents must be included using unique paths.", path, existingComponent));
            }
            return this.include(absolutePath, subComponent);
        }

        @Override
        public Builder delegate(HasDisplayData component) {
            Preconditions.checkNotNull(component);
            return this.include(this.latestPath, component);
        }

        private Builder include(Path path, HasDisplayData subComponent) {
            if (this.visitedComponents.contains(subComponent)) {
                return this;
            }
            this.visitedComponents.add(subComponent);
            this.visitedPathMap.put(path, subComponent);
            Class<?> namespace = subComponent.getClass();
            if (namespace.getSimpleName().startsWith("AutoValue_")) {
                namespace = namespace.getSuperclass();
            }
            if (namespace.isSynthetic() && namespace.getSimpleName().contains("$$Lambda")) {
                try {
                    namespace = Class.forName(namespace.getCanonicalName().replaceFirst("\\$\\$Lambda.*", ""));
                }
                catch (Exception e) {
                    throw new PopulateDisplayDataException("Failed to get the enclosing class of lambda " + subComponent, e);
                }
            }
            Path prevPath = this.latestPath;
            Class<?> prevNs = this.latestNs;
            this.latestPath = path;
            this.latestNs = namespace;
            try {
                subComponent.populateDisplayData(this);
            }
            catch (PopulateDisplayDataException e) {
                throw e;
            }
            catch (Throwable e) {
                String msg = String.format("Error while populating display data for component '%s': %s", namespace.getName(), e.getMessage());
                throw new PopulateDisplayDataException(msg, e);
            }
            this.latestPath = prevPath;
            this.latestNs = prevNs;
            return this;
        }

        @Override
        public Builder add(ItemSpec<?> item) {
            Preconditions.checkNotNull(item, "Input display item cannot be null");
            return this.addItemIf(true, item);
        }

        @Override
        public Builder addIfNotNull(ItemSpec<?> item) {
            Preconditions.checkNotNull(item, "Input display item cannot be null");
            return this.addItemIf(item.getValue() != null, item);
        }

        @Override
        public <T> Builder addIfNotDefault(ItemSpec<T> item, @Nullable T defaultValue) {
            Preconditions.checkNotNull(item, "Input display item cannot be null");
            ItemSpec defaultItem = ((ItemSpec)item).withValue(defaultValue);
            return this.addItemIf(!Objects.equals(item, defaultItem), item);
        }

        private Builder addItemIf(boolean condition, ItemSpec<?> spec) {
            Item item;
            Identifier id;
            if (!condition) {
                return this;
            }
            Preconditions.checkNotNull(spec, "Input display item cannot be null");
            Preconditions.checkNotNull(spec.getValue(), "Input display value cannot be null");
            if (spec.getNamespace() == null) {
                spec = spec.withNamespace(this.latestNs);
            }
            Preconditions.checkArgument(!this.entries.containsKey(id = Identifier.of((item = Item.create(spec, this.latestPath)).getPath(), item.getNamespace(), item.getKey())), "Display data key (%s) is not unique within the specified path and namespace: %s%s.", (Object)item.getKey(), (Object)item.getPath(), item.getNamespace());
            this.entries.put(id, item);
            return this;
        }

        private DisplayData build() {
            return new DisplayData(this.entries);
        }

        private static class PopulateDisplayDataException
        extends RuntimeException {
            PopulateDisplayDataException(String message, Throwable cause) {
                super(message, cause);
            }
        }
    }

    static class FormattedItemValue {
        private static final FormattedItemValue NULL_VALUES = new FormattedItemValue(null);
        private final @Nullable Object shortValue;
        private final @Nullable Object longValue;

        private FormattedItemValue(@Nullable Object longValue) {
            this(longValue, (Object)null);
        }

        private FormattedItemValue(@Nullable Object longValue, @Nullable Object shortValue) {
            this.longValue = longValue;
            this.shortValue = shortValue;
        }

        Object getLongValue() {
            return this.longValue;
        }

        Object getShortValue() {
            return this.shortValue;
        }
    }

    public static enum Type {
        STRING{

            @Override
            FormattedItemValue format(Object value) {
                return new FormattedItemValue(Type.checkType(value, String.class, 1.STRING));
            }
        }
        ,
        INTEGER{

            @Override
            FormattedItemValue format(Object value) {
                if (value instanceof Integer) {
                    long l = ((Integer)value).longValue();
                    return this.format(l);
                }
                return new FormattedItemValue(Type.checkType(value, Long.class, 2.INTEGER));
            }
        }
        ,
        FLOAT{

            @Override
            FormattedItemValue format(Object value) {
                return new FormattedItemValue(Type.checkType(value, Number.class, 3.FLOAT));
            }
        }
        ,
        BOOLEAN{

            @Override
            FormattedItemValue format(Object value) {
                return new FormattedItemValue(Type.checkType(value, Boolean.class, 4.BOOLEAN));
            }
        }
        ,
        TIMESTAMP{

            @Override
            FormattedItemValue format(Object value) {
                Instant instant = (Instant)Type.checkType(value, Instant.class, 5.TIMESTAMP);
                return new FormattedItemValue((Object)TIMESTAMP_FORMATTER.print(instant));
            }
        }
        ,
        DURATION{

            @Override
            FormattedItemValue format(Object value) {
                Duration duration = (Duration)Type.checkType(value, Duration.class, 6.DURATION);
                return new FormattedItemValue((Object)duration.getMillis());
            }
        }
        ,
        JAVA_CLASS{

            @Override
            FormattedItemValue format(Object value) {
                Class clazz = (Class)Type.checkType(value, Class.class, 7.JAVA_CLASS);
                return new FormattedItemValue(clazz.getName(), clazz.getSimpleName());
            }
        };


        private static <T> T checkType(Object value, Class<T> clazz, Type expectedType) {
            if (!clazz.isAssignableFrom(value.getClass())) {
                throw new ClassCastException(String.format("Value is not valid for DisplayData type %s: %s", new Object[]{expectedType, value}));
            }
            Object typedValue = value;
            return (T)typedValue;
        }

        abstract FormattedItemValue format(Object var1);

        FormattedItemValue safeFormat(@Nullable Object value) {
            if (value == null) {
                return FormattedItemValue.NULL_VALUES;
            }
            return this.format(value);
        }

        private static @Nullable Type tryInferFrom(@Nullable Object value) {
            if (value instanceof Integer || value instanceof Long) {
                return INTEGER;
            }
            if (value instanceof Double || value instanceof Float) {
                return FLOAT;
            }
            if (value instanceof Boolean) {
                return BOOLEAN;
            }
            if (value instanceof Instant) {
                return TIMESTAMP;
            }
            if (value instanceof Duration) {
                return DURATION;
            }
            if (value instanceof Class) {
                return JAVA_CLASS;
            }
            if (value instanceof String) {
                return STRING;
            }
            return null;
        }
    }

    public static class Path
    implements Serializable {
        private final ImmutableList<String> components;

        private Path(ImmutableList<String> components) {
            this.components = components;
        }

        public static Path root() {
            return new Path(ImmutableList.of());
        }

        public static Path absolute(String firstPath, String ... paths) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Path.validatePathElement(firstPath);
            builder.add(firstPath);
            for (String path : paths) {
                Path.validatePathElement(path);
                builder.add(path);
            }
            return new Path((ImmutableList<String>)builder.build());
        }

        public List<String> getComponents() {
            return this.components;
        }

        public Path extend(String path) {
            Path.validatePathElement(path);
            return new Path((ImmutableList<String>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.components.iterator())).add(path)).build());
        }

        private static void validatePathElement(String path) {
            Preconditions.checkNotNull(path);
            Preconditions.checkArgument(!"".equals(path), "path cannot be empty");
        }

        public String toString() {
            StringBuilder b = new StringBuilder().append("[");
            Joiner.on("/").appendTo(b, (Iterable<?>)this.components);
            b.append("]");
            return b.toString();
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof Path && Objects.equals(this.components, ((Path)obj).components);
        }

        public int hashCode() {
            return this.components.hashCode();
        }
    }

    @AutoValue
    public static abstract class Identifier
    implements Serializable {
        public abstract Path getPath();

        public abstract Class<?> getNamespace();

        public abstract String getKey();

        public static Identifier of(Path path, Class<?> namespace, String key) {
            return new AutoValue_DisplayData_Identifier(path, namespace, key);
        }

        public String toString() {
            return String.format("%s%s:%s", this.getPath(), this.getNamespace(), this.getKey());
        }
    }

    @AutoValue
    public static abstract class ItemSpec<T>
    implements Serializable {
        public abstract @Nullable Class<?> getNamespace();

        public abstract String getKey();

        public abstract Type getType();

        public abstract @Nullable Object getValue();

        public abstract @Nullable Object getShortValue();

        public abstract @Nullable String getLabel();

        public abstract @Nullable String getLinkUrl();

        private static <T> ItemSpec<T> create(String key, Type type, @Nullable T value) {
            return ItemSpec.builder().setKey(key).setType(type).setRawValue(value).build();
        }

        public ItemSpec<T> withNamespace(Class<?> namespace) {
            Preconditions.checkNotNull(namespace, "namespace argument cannot be null");
            return this.toBuilder().setNamespace(namespace).build();
        }

        public ItemSpec<T> withLabel(@Nullable String label) {
            return this.toBuilder().setLabel(label).build();
        }

        public ItemSpec<T> withLinkUrl(@Nullable String url) {
            return this.toBuilder().setLinkUrl(url).build();
        }

        private ItemSpec<T> withValue(T value) {
            return this.toBuilder().setRawValue(value).build();
        }

        public String toString() {
            return String.format("%s:%s=%s", this.getNamespace(), this.getKey(), this.getValue());
        }

        static <T> Builder<T> builder() {
            return new AutoValue_DisplayData_ItemSpec.Builder();
        }

        abstract Builder<T> toBuilder();

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            public abstract Builder<T> setKey(String var1);

            public abstract Builder<T> setNamespace(@Nullable Class<?> var1);

            public abstract Builder<T> setType(Type var1);

            public abstract Builder<T> setValue(@Nullable Object var1);

            public abstract Builder<T> setShortValue(@Nullable Object var1);

            public abstract Builder<T> setLabel(@Nullable String var1);

            public abstract Builder<T> setLinkUrl(@Nullable String var1);

            public abstract ItemSpec<T> build();

            abstract Type getType();

            Builder<T> setRawValue(@Nullable T value) {
                FormattedItemValue formatted = this.getType().safeFormat(value);
                return this.setValue(formatted.getLongValue()).setShortValue(formatted.getShortValue());
            }
        }
    }

    @AutoValue
    public static abstract class Item
    implements Serializable {
        @JsonIgnore
        public abstract @Nullable Path getPath();

        @JsonGetter(value="namespace")
        public abstract @Nullable Class<?> getNamespace();

        @JsonGetter(value="key")
        public abstract String getKey();

        @JsonGetter(value="type")
        public abstract Type getType();

        @JsonGetter(value="value")
        public abstract @Nullable Object getValue();

        @JsonGetter(value="shortValue")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public abstract @Nullable Object getShortValue();

        @JsonGetter(value="label")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public abstract @Nullable String getLabel();

        @JsonGetter(value="linkUrl")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public abstract @Nullable String getLinkUrl();

        private static Item create(ItemSpec<?> spec, Path path) {
            Preconditions.checkNotNull(spec, "spec cannot be null");
            Preconditions.checkNotNull(path, "path cannot be null");
            Class<?> ns = Preconditions.checkNotNull(spec.getNamespace(), "namespace must be set");
            return new AutoValue_DisplayData_Item(path, ns, spec.getKey(), spec.getType(), spec.getValue(), spec.getShortValue(), spec.getLabel(), spec.getLinkUrl());
        }

        public String toString() {
            return String.format("%s%s:%s=%s", this.getPath(), this.getNamespace().getName(), this.getKey(), this.getValue());
        }
    }

    public static interface Builder {
        public Builder include(String var1, HasDisplayData var2);

        public Builder delegate(HasDisplayData var1);

        public Builder add(ItemSpec<?> var1);

        public Builder addIfNotNull(ItemSpec<?> var1);

        public <T> Builder addIfNotDefault(ItemSpec<T> var1, @Nullable T var2);
    }
}

