/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.join;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.join.CoGbkResultSchema;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KeyedPCollectionTuple<K>
implements PInput {
    private final List<TaggedKeyedPCollection<K, ?>> keyedCollections;
    private @Nullable Coder<K> keyCoder;
    private final CoGbkResultSchema schema;
    private final Pipeline pipeline;

    public static <K> KeyedPCollectionTuple<K> empty(Pipeline pipeline) {
        return new KeyedPCollectionTuple<K>(pipeline);
    }

    public static <K, InputT> KeyedPCollectionTuple<K> of(TupleTag<InputT> tag, PCollection<KV<K, InputT>> pc) {
        return new KeyedPCollectionTuple<K>(pc.getPipeline()).and(tag, pc);
    }

    public static <K, InputT> KeyedPCollectionTuple<K> of(String tag, PCollection<KV<K, InputT>> pc) {
        return KeyedPCollectionTuple.of(new TupleTag(tag), pc);
    }

    public <V> KeyedPCollectionTuple<K> and(TupleTag<V> tag, PCollection<KV<K, V>> pc) {
        if (pc.getPipeline() != this.getPipeline()) {
            throw new IllegalArgumentException("PCollections come from different Pipelines");
        }
        TaggedKeyedPCollection<K, V> wrapper = new TaggedKeyedPCollection<K, V>(tag, pc);
        Coder<K> myKeyCoder = this.keyCoder == null ? KeyedPCollectionTuple.getKeyCoder(pc) : this.keyCoder;
        List<TaggedKeyedPCollection<K, ?>> newKeyedCollections = KeyedPCollectionTuple.copyAddLast(this.keyedCollections, wrapper);
        return new KeyedPCollectionTuple<K>(this.getPipeline(), newKeyedCollections, this.schema.getTupleTagList().and(tag), myKeyCoder);
    }

    public <V> KeyedPCollectionTuple<K> and(String tag, PCollection<KV<K, V>> pc) {
        return this.and(new TupleTag(tag), pc);
    }

    public boolean isEmpty() {
        return this.keyedCollections.isEmpty();
    }

    public List<TaggedKeyedPCollection<K, ?>> getKeyedCollections() {
        return this.keyedCollections;
    }

    public <OutputT extends POutput> OutputT apply(PTransform<KeyedPCollectionTuple<K>, OutputT> transform) {
        return Pipeline.applyTransform(this, transform);
    }

    public <OutputT extends POutput> OutputT apply(String name, PTransform<KeyedPCollectionTuple<K>, OutputT> transform) {
        return Pipeline.applyTransform(name, this, transform);
    }

    @Override
    public Map<TupleTag<?>, PValue> expand() {
        ImmutableMap.Builder retval = ImmutableMap.builder();
        for (TaggedKeyedPCollection<K, ?> taggedPCollection : this.keyedCollections) {
            retval.put(taggedPCollection.tupleTag, taggedPCollection.pCollection);
        }
        return retval.build();
    }

    public Coder<K> getKeyCoder() {
        if (this.keyCoder == null) {
            throw new IllegalStateException("cannot return null keyCoder");
        }
        return this.keyCoder;
    }

    public CoGbkResultSchema getCoGbkResultSchema() {
        return this.schema;
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    private static <K, V> Coder<K> getKeyCoder(PCollection<KV<K, V>> pc) {
        Coder<KV<K, V>> entryCoder = pc.getCoder();
        if (!(entryCoder instanceof KvCoder)) {
            throw new IllegalArgumentException("PCollection does not use a KvCoder");
        }
        KvCoder coder = (KvCoder)entryCoder;
        return coder.getKeyCoder();
    }

    KeyedPCollectionTuple(Pipeline pipeline) {
        this(pipeline, new ArrayList(), TupleTagList.empty(), null);
    }

    KeyedPCollectionTuple(Pipeline pipeline, List<TaggedKeyedPCollection<K, ?>> keyedCollections, TupleTagList tupleTagList, @Nullable Coder<K> keyCoder) {
        this.pipeline = pipeline;
        this.keyedCollections = keyedCollections;
        this.schema = new CoGbkResultSchema(tupleTagList);
        this.keyCoder = keyCoder;
    }

    private static <K> List<TaggedKeyedPCollection<K, ?>> copyAddLast(List<TaggedKeyedPCollection<K, ?>> keyedCollections, TaggedKeyedPCollection<K, ?> taggedCollection) {
        ArrayList retval = new ArrayList(keyedCollections);
        retval.add(taggedCollection);
        return retval;
    }

    public static class TaggedKeyedPCollection<K, V> {
        final TupleTag<V> tupleTag;
        final PCollection<KV<K, V>> pCollection;

        public TaggedKeyedPCollection(TupleTag<V> tupleTag, PCollection<KV<K, V>> pCollection) {
            this.tupleTag = tupleTag;
            this.pCollection = pCollection;
        }

        public PCollection<KV<K, V>> getCollection() {
            return this.pCollection;
        }

        public TupleTag<V> getTupleTag() {
            return this.tupleTag;
        }
    }
}

