/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerMap;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokerFactory;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.reflect.OnTimerInvoker;
import org.apache.beam.sdk.transforms.reflect.OnTimerInvokers;
import org.apache.beam.sdk.transforms.reflect.StableInvokerNamingStrategy;
import org.apache.beam.sdk.transforms.splittabledofn.HasDefaultTracker;
import org.apache.beam.sdk.transforms.splittabledofn.HasDefaultWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.ByteBuddy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.field.FieldDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.field.FieldList;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.method.MethodList;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.modifier.Visibility;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.type.TypeList;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.ExceptionMethod;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.FixedValue;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.Implementation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.MethodDelegation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.Throw;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.constant.TextConstant;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.jar.asm.Label;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.jar.asm.MethodVisitor;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.jar.asm.Opcodes;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.jar.asm.Type;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Primitives;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

class ByteBuddyDoFnInvokerFactory
implements DoFnInvokerFactory {
    public static final String SETUP_CONTEXT_PARAMETER_METHOD = "setupContext";
    public static final String START_BUNDLE_CONTEXT_PARAMETER_METHOD = "startBundleContext";
    public static final String FINISH_BUNDLE_CONTEXT_PARAMETER_METHOD = "finishBundleContext";
    public static final String PROCESS_CONTEXT_PARAMETER_METHOD = "processContext";
    public static final String ELEMENT_PARAMETER_METHOD = "element";
    public static final String SCHEMA_ELEMENT_PARAMETER_METHOD = "schemaElement";
    public static final String TIMESTAMP_PARAMETER_METHOD = "timestamp";
    public static final String BUNDLE_FINALIZER_PARAMETER_METHOD = "bundleFinalizer";
    public static final String OUTPUT_ROW_RECEIVER_METHOD = "outputRowReceiver";
    public static final String TIME_DOMAIN_PARAMETER_METHOD = "timeDomain";
    public static final String OUTPUT_PARAMETER_METHOD = "outputReceiver";
    public static final String TAGGED_OUTPUT_PARAMETER_METHOD = "taggedOutputReceiver";
    public static final String ON_TIMER_CONTEXT_PARAMETER_METHOD = "onTimerContext";
    public static final String WINDOW_PARAMETER_METHOD = "window";
    public static final String PANE_INFO_PARAMETER_METHOD = "paneInfo";
    public static final String PIPELINE_OPTIONS_PARAMETER_METHOD = "pipelineOptions";
    public static final String RESTRICTION_PARAMETER_METHOD = "restriction";
    public static final String RESTRICTION_TRACKER_PARAMETER_METHOD = "restrictionTracker";
    public static final String WATERMARK_ESTIMATOR_PARAMETER_METHOD = "watermarkEstimator";
    public static final String WATERMARK_ESTIMATOR_STATE_PARAMETER_METHOD = "watermarkEstimatorState";
    public static final String STATE_PARAMETER_METHOD = "state";
    public static final String TIMER_PARAMETER_METHOD = "timer";
    public static final String SIDE_INPUT_PARAMETER_METHOD = "sideInput";
    public static final String TIMER_FAMILY_PARAMETER_METHOD = "timerFamily";
    public static final String TIMER_ID_PARAMETER_METHOD = "timerId";
    public static final String KEY_PARAMETER_METHOD = "key";
    private static final ByteBuddyDoFnInvokerFactory INSTANCE = new ByteBuddyDoFnInvokerFactory();
    private static final String FN_DELEGATE_FIELD_NAME = "delegate";
    private final Map<Class<?>, Constructor<?>> byteBuddyInvokerConstructorCache = new LinkedHashMap();

    public static ByteBuddyDoFnInvokerFactory only() {
        return INSTANCE;
    }

    @Override
    public <InputT, OutputT> DoFnInvoker<InputT, OutputT> invokerFor(DoFn<InputT, OutputT> fn) {
        return this.newByteBuddyInvoker(fn);
    }

    private ByteBuddyDoFnInvokerFactory() {
    }

    public <InputT, OutputT> DoFnInvoker<InputT, OutputT> newByteBuddyInvoker(DoFn<InputT, OutputT> fn) {
        return this.newByteBuddyInvoker(DoFnSignatures.getSignature(fn.getClass()), fn);
    }

    public <InputT, OutputT> DoFnInvoker<InputT, OutputT> newByteBuddyInvoker(DoFnSignature signature, DoFn<InputT, OutputT> fn) {
        Preconditions.checkArgument(signature.fnClass().equals(fn.getClass()), "Signature is for class %s, but fn is of class %s", signature.fnClass(), fn.getClass());
        try {
            DoFnInvokerBase invoker = (DoFnInvokerBase)this.getByteBuddyInvokerConstructor(signature).newInstance(fn);
            for (DoFnSignature.OnTimerMethod onTimerMethod : signature.onTimerMethods().values()) {
                invoker.addOnTimerInvoker(onTimerMethod.id(), OnTimerInvokers.forTimer(fn, onTimerMethod.id()));
            }
            for (DoFnSignature.OnTimerFamilyMethod onTimerFamilyMethod : signature.onTimerFamilyMethods().values()) {
                invoker.addOnTimerFamilyInvoker(onTimerFamilyMethod.id(), OnTimerInvokers.forTimerFamily(fn, onTimerFamilyMethod.id()));
            }
            return invoker;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Unable to bind invoker for " + fn.getClass(), e);
        }
    }

    private synchronized Constructor<?> getByteBuddyInvokerConstructor(DoFnSignature signature) {
        Class<? extends DoFn<?, ?>> fnClass = signature.fnClass();
        Constructor<Object> constructor = this.byteBuddyInvokerConstructorCache.get(fnClass);
        if (constructor == null) {
            Class<DoFnInvoker<?, ?>> invokerClass = ByteBuddyDoFnInvokerFactory.generateInvokerClass(signature);
            try {
                constructor = invokerClass.getConstructor(fnClass);
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
            this.byteBuddyInvokerConstructorCache.put(fnClass, constructor);
        }
        return constructor;
    }

    private static Class<? extends DoFnInvoker<?, ?>> generateInvokerClass(DoFnSignature signature) {
        Class<DoFn<?, ?>> fnClass = signature.fnClass();
        TypeDescription.ForLoadedType clazzDescription = new TypeDescription.ForLoadedType(fnClass);
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = new ByteBuddy().with(StableInvokerNamingStrategy.forDoFnClass(fnClass).withSuffix(DoFnInvoker.class.getSimpleName())).subclass(DoFnInvokerBase.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).defineConstructor(Visibility.PUBLIC).withParameter(fnClass).intercept(new InvokerConstructor(DoFnInvokerBase.class)).method(ElementMatchers.named("invokeProcessElement")).intercept(new ProcessElementDelegation(clazzDescription, signature.processElement())).method(ElementMatchers.named("invokeStartBundle")).intercept(ByteBuddyDoFnInvokerFactory.delegateMethodWithExtraParametersOrNoop(clazzDescription, signature.startBundle())).method(ElementMatchers.named("invokeFinishBundle")).intercept(ByteBuddyDoFnInvokerFactory.delegateMethodWithExtraParametersOrNoop(clazzDescription, signature.finishBundle())).method(ElementMatchers.named("invokeSetup")).intercept(ByteBuddyDoFnInvokerFactory.delegateMethodWithExtraParametersOrNoop(clazzDescription, signature.setup())).method(ElementMatchers.named("invokeTeardown")).intercept(ByteBuddyDoFnInvokerFactory.delegateOrNoop(clazzDescription, signature.teardown())).method(ElementMatchers.named("invokeOnWindowExpiration")).intercept(ByteBuddyDoFnInvokerFactory.delegateMethodWithExtraParametersOrNoop(clazzDescription, signature.onWindowExpiration())).method(ElementMatchers.named("invokeGetInitialRestriction")).intercept(ByteBuddyDoFnInvokerFactory.delegateMethodWithExtraParametersOrThrow(clazzDescription, signature.getInitialRestriction())).method(ElementMatchers.named("invokeSplitRestriction")).intercept(ByteBuddyDoFnInvokerFactory.splitRestrictionDelegation(clazzDescription, signature.splitRestriction())).method(ElementMatchers.named("invokeTruncateRestriction")).intercept(ByteBuddyDoFnInvokerFactory.truncateRestrictionDelegation(clazzDescription, signature.truncateRestriction())).method(ElementMatchers.named("invokeGetRestrictionCoder")).intercept(ByteBuddyDoFnInvokerFactory.getRestrictionCoderDelegation(clazzDescription, signature)).method(ElementMatchers.named("invokeNewTracker")).intercept(ByteBuddyDoFnInvokerFactory.newTrackerDelegation(clazzDescription, signature.newTracker())).method(ElementMatchers.named("invokeGetSize")).intercept(ByteBuddyDoFnInvokerFactory.getSizeDelegation(clazzDescription, signature.getSize())).method(ElementMatchers.named("invokeGetWatermarkEstimatorStateCoder")).intercept(ByteBuddyDoFnInvokerFactory.getWatermarkEstimatorStateCoderDelegation(clazzDescription, signature)).method(ElementMatchers.named("invokeGetInitialWatermarkEstimatorState")).intercept(ByteBuddyDoFnInvokerFactory.getInitialWatermarkEstimatorStateDelegation(clazzDescription, signature.getInitialWatermarkEstimatorState())).method(ElementMatchers.named("invokeNewWatermarkEstimator")).intercept(ByteBuddyDoFnInvokerFactory.newWatermarkEstimatorDelegation(clazzDescription, signature.newWatermarkEstimator()));
        DynamicType.Unloaded unloaded = builder.make();
        Class res = unloaded.load(ReflectHelpers.findClassLoader(fnClass.getClassLoader()), ClassLoadingStrategy.Default.INJECTION).getLoaded();
        return res;
    }

    private static Implementation getRestrictionCoderDelegation(TypeDescription doFnType, DoFnSignature signature) {
        if (signature.processElement().isSplittable()) {
            if (signature.getRestrictionCoder() == null) {
                return MethodDelegation.to(new DefaultRestrictionCoder(signature.getInitialRestriction().restrictionT()));
            }
            return new DowncastingParametersMethodDelegation(doFnType, signature.getRestrictionCoder().targetMethod());
        }
        return ExceptionMethod.throwing(UnsupportedOperationException.class);
    }

    private static Implementation getWatermarkEstimatorStateCoderDelegation(TypeDescription doFnType, DoFnSignature signature) {
        if (signature.processElement().isSplittable()) {
            if (signature.getWatermarkEstimatorStateCoder() == null) {
                return MethodDelegation.to(new DefaultWatermarkEstimatorStateCoder(signature.getInitialWatermarkEstimatorState() == null ? TypeDescriptors.voids() : signature.getInitialWatermarkEstimatorState().watermarkEstimatorStateT()));
            }
            return new DowncastingParametersMethodDelegation(doFnType, signature.getWatermarkEstimatorStateCoder().targetMethod());
        }
        return ExceptionMethod.throwing(UnsupportedOperationException.class);
    }

    private static Implementation splitRestrictionDelegation(TypeDescription doFnType, DoFnSignature.SplitRestrictionMethod signature) {
        if (signature == null) {
            return MethodDelegation.to(DefaultSplitRestriction.class);
        }
        return new DoFnMethodWithExtraParametersDelegation(doFnType, signature);
    }

    private static Implementation truncateRestrictionDelegation(TypeDescription doFnType, DoFnSignature.TruncateRestrictionMethod signature) {
        if (signature == null) {
            return MethodDelegation.to(DefaultTruncateRestriction.class);
        }
        return new DoFnMethodWithExtraParametersDelegation(doFnType, signature);
    }

    private static Implementation getInitialWatermarkEstimatorStateDelegation(TypeDescription doFnType, @Nullable DoFnSignature.GetInitialWatermarkEstimatorStateMethod signature) {
        if (signature == null) {
            return MethodDelegation.to(DefaultGetInitialWatermarkEstimatorState.class);
        }
        return new DoFnMethodWithExtraParametersDelegation(doFnType, signature);
    }

    private static Implementation newWatermarkEstimatorDelegation(TypeDescription doFnType, @Nullable DoFnSignature.NewWatermarkEstimatorMethod signature) {
        if (signature == null) {
            return MethodDelegation.to(DefaultNewWatermarkEstimator.class);
        }
        return new DoFnMethodWithExtraParametersDelegation(doFnType, signature);
    }

    private static Implementation newTrackerDelegation(TypeDescription doFnType, @Nullable DoFnSignature.NewTrackerMethod signature) {
        if (signature == null) {
            return MethodDelegation.to(DefaultNewTracker.class);
        }
        return new DoFnMethodWithExtraParametersDelegation(doFnType, signature);
    }

    private static Implementation getSizeDelegation(TypeDescription doFnType, @Nullable DoFnSignature.GetSizeMethod signature) {
        if (signature == null) {
            return MethodDelegation.to(DefaultGetSize.class);
        }
        return new GetSizeDelegation(doFnType, signature);
    }

    private static Implementation delegateOrNoop(TypeDescription doFnType, DoFnSignature.DoFnMethod method) {
        return method == null ? FixedValue.originType() : new DoFnMethodDelegation(doFnType, method.targetMethod());
    }

    private static Implementation delegateOrThrow(TypeDescription doFnType, DoFnSignature.DoFnMethod method) {
        return method == null ? ExceptionMethod.throwing(UnsupportedOperationException.class) : new DoFnMethodDelegation(doFnType, method.targetMethod());
    }

    private static Implementation delegateMethodWithExtraParametersOrNoop(TypeDescription doFnType, DoFnSignature.MethodWithExtraParameters method) {
        return method == null ? FixedValue.originType() : new DoFnMethodWithExtraParametersDelegation(doFnType, method);
    }

    private static Implementation delegateMethodWithExtraParametersOrThrow(TypeDescription doFnType, DoFnSignature.MethodWithExtraParameters method) {
        return method == null ? ExceptionMethod.throwing(UnsupportedOperationException.class) : new DoFnMethodWithExtraParametersDelegation(doFnType, method);
    }

    private static Implementation delegateWithDowncastOrThrow(TypeDescription doFnType, DoFnSignature.DoFnMethod method) {
        return method == null ? ExceptionMethod.throwing(UnsupportedOperationException.class) : new DowncastingParametersMethodDelegation(doFnType, method.targetMethod());
    }

    private static MethodDescription getExtraContextFactoryMethodDescription(String methodName, Class<?> ... parameterTypes) {
        try {
            return new MethodDescription.ForLoadedMethod(DoFnInvoker.ArgumentProvider.class.getMethod(methodName, parameterTypes));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to locate required method %s.%s", DoFnInvoker.ArgumentProvider.class.getSimpleName(), methodName), e);
        }
    }

    private static StackManipulation simpleExtraContextParameter(String methodName) {
        return new StackManipulation.Compound(MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(methodName, new Class[0])));
    }

    static StackManipulation getExtraContextParameter(DoFnSignature.Parameter parameter, final StackManipulation pushDelegate) {
        return parameter.match(new DoFnSignature.Parameter.Cases<StackManipulation>(){

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.StartBundleContextParameter p) {
                return new StackManipulation.Compound(pushDelegate, MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.START_BUNDLE_CONTEXT_PARAMETER_METHOD, new Class[]{DoFn.class})));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.FinishBundleContextParameter p) {
                return new StackManipulation.Compound(pushDelegate, MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.FINISH_BUNDLE_CONTEXT_PARAMETER_METHOD, new Class[]{DoFn.class})));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.ProcessContextParameter p) {
                return new StackManipulation.Compound(pushDelegate, MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.PROCESS_CONTEXT_PARAMETER_METHOD, new Class[]{DoFn.class})));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.ElementParameter p) {
                return new StackManipulation.Compound(pushDelegate, MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.ELEMENT_PARAMETER_METHOD, new Class[]{DoFn.class})), TypeCasting.to(new TypeDescription.ForLoadedType(p.elementT().getRawType())));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.SchemaElementParameter p) {
                TypeDescription.ForLoadedType elementType = new TypeDescription.ForLoadedType(p.elementT().getRawType());
                TypeDescription.ForLoadedType castType = elementType.isPrimitive() ? new TypeDescription.ForLoadedType(Primitives.wrap(p.elementT().getRawType())) : elementType;
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(IntegerConstant.forValue(p.index()), MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.SCHEMA_ELEMENT_PARAMETER_METHOD, new Class[]{Integer.TYPE})), TypeCasting.to(castType));
                if (elementType.isPrimitive()) {
                    stackManipulation = new StackManipulation.Compound(stackManipulation, Assigner.DEFAULT.assign(elementType.asBoxed().asGenericType(), elementType.asUnboxed().asGenericType(), Assigner.Typing.STATIC));
                }
                return stackManipulation;
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.TimestampParameter p) {
                return new StackManipulation.Compound(pushDelegate, MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.TIMESTAMP_PARAMETER_METHOD, new Class[]{DoFn.class})));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.BundleFinalizerParameter p) {
                return ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.BUNDLE_FINALIZER_PARAMETER_METHOD);
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.TimeDomainParameter p) {
                return new StackManipulation.Compound(pushDelegate, MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.TIME_DOMAIN_PARAMETER_METHOD, new Class[]{DoFn.class})));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.OutputReceiverParameter p) {
                String method = p.isRowReceiver() ? ByteBuddyDoFnInvokerFactory.OUTPUT_ROW_RECEIVER_METHOD : ByteBuddyDoFnInvokerFactory.OUTPUT_PARAMETER_METHOD;
                return new StackManipulation.Compound(pushDelegate, MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(method, new Class[]{DoFn.class})));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.TaggedOutputReceiverParameter p) {
                return new StackManipulation.Compound(pushDelegate, MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.TAGGED_OUTPUT_PARAMETER_METHOD, new Class[]{DoFn.class})));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.OnTimerContextParameter p) {
                return new StackManipulation.Compound(pushDelegate, MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.ON_TIMER_CONTEXT_PARAMETER_METHOD, new Class[]{DoFn.class})));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.WindowParameter p) {
                return new StackManipulation.Compound(ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.WINDOW_PARAMETER_METHOD), TypeCasting.to(new TypeDescription.ForLoadedType(p.windowT().getRawType())));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.PaneInfoParameter p) {
                return new StackManipulation.Compound(pushDelegate, MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.PANE_INFO_PARAMETER_METHOD, new Class[]{DoFn.class})));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.RestrictionParameter p) {
                return new StackManipulation.Compound(ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.RESTRICTION_PARAMETER_METHOD), TypeCasting.to(new TypeDescription.ForLoadedType(p.restrictionT().getRawType())));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.RestrictionTrackerParameter p) {
                return new StackManipulation.Compound(ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.RESTRICTION_TRACKER_PARAMETER_METHOD), TypeCasting.to(new TypeDescription.ForLoadedType(p.trackerT().getRawType())));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.WatermarkEstimatorParameter p) {
                return new StackManipulation.Compound(ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.WATERMARK_ESTIMATOR_PARAMETER_METHOD), TypeCasting.to(new TypeDescription.ForLoadedType(p.estimatorT().getRawType())));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.WatermarkEstimatorStateParameter p) {
                return new StackManipulation.Compound(ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.WATERMARK_ESTIMATOR_STATE_PARAMETER_METHOD), TypeCasting.to(new TypeDescription.ForLoadedType(p.estimatorStateT().getRawType())));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.StateParameter p) {
                return new StackManipulation.Compound(new TextConstant(p.referent().id()), IntegerConstant.forValue(p.alwaysFetched()), MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.STATE_PARAMETER_METHOD, new Class[]{String.class, Boolean.TYPE})), TypeCasting.to(new TypeDescription.ForLoadedType(p.referent().stateType().getRawType())));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.TimerParameter p) {
                return new StackManipulation.Compound(new TextConstant(p.referent().id()), MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.TIMER_PARAMETER_METHOD, new Class[]{String.class})), TypeCasting.to(new TypeDescription.ForLoadedType(Timer.class)));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.TimerFamilyParameter p) {
                return new StackManipulation.Compound(new TextConstant(p.referent().id()), MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.TIMER_FAMILY_PARAMETER_METHOD, new Class[]{String.class})), TypeCasting.to(new TypeDescription.ForLoadedType(TimerMap.class)));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.PipelineOptionsParameter p) {
                return ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.PIPELINE_OPTIONS_PARAMETER_METHOD);
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.SideInputParameter p) {
                return new StackManipulation.Compound(new TextConstant(p.sideInputId()), MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.SIDE_INPUT_PARAMETER_METHOD, new Class[]{String.class})), TypeCasting.to(new TypeDescription.ForLoadedType(p.elementT().getRawType())));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.TimerIdParameter p) {
                return new StackManipulation.Compound(pushDelegate, MethodInvocation.invoke(ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.TIMER_ID_PARAMETER_METHOD, new Class[]{DoFn.class})));
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.KeyParameter p) {
                return new StackManipulation.Compound(ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.KEY_PARAMETER_METHOD), TypeCasting.to(new TypeDescription.ForLoadedType(p.keyT().getRawType())));
            }
        });
    }

    private static final class InvokerConstructor
    implements Implementation {
        Class<? extends DoFnInvoker> clazz;

        InvokerConstructor(Class<? extends DoFnInvoker> clazz) {
            this.clazz = clazz;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                StackManipulation.Size size = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(0), MethodVariableAccess.REFERENCE.loadFrom(1), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(this.clazz).getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(DoFn.class)))).getOnly()), MethodReturn.VOID).apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
            };
        }
    }

    private static class UserCodeMethodInvocation
    implements StackManipulation {
        private final @Nullable Integer returnVarIndex;
        private final MethodDescription targetMethod;
        private final MethodDescription instrumentedMethod;
        private final TypeDescription returnType;
        private final Label wrapStart = new Label();
        private final Label wrapEnd = new Label();
        private final Label tryBlockStart = new Label();
        private final Label tryBlockEnd = new Label();
        private final Label catchBlockStart = new Label();
        private final Label catchBlockEnd = new Label();
        private final MethodDescription createUserCodeException;

        UserCodeMethodInvocation(@Nullable Integer returnVarIndex, MethodDescription targetMethod, MethodDescription instrumentedMethod) {
            this.returnVarIndex = returnVarIndex;
            this.targetMethod = targetMethod;
            this.instrumentedMethod = instrumentedMethod;
            this.returnType = targetMethod.getReturnType().asErasure();
            boolean targetMethodReturnsVoid = TypeDescription.VOID.equals(this.returnType);
            Preconditions.checkArgument(returnVarIndex == null == targetMethodReturnsVoid, "returnVarIndex should be defined if and only if the target method has a return value");
            try {
                this.createUserCodeException = new MethodDescription.ForLoadedMethod(UserCodeException.class.getDeclaredMethod("wrap", Throwable.class));
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException("Unable to find UserCodeException.wrap", e);
            }
        }

        @Override
        public boolean isValid() {
            return true;
        }

        private Object describeType(Type type) {
            switch (type.getSort()) {
                case 10: {
                    return type.getInternalName();
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    return Opcodes.INTEGER;
                }
                case 7: {
                    return Opcodes.LONG;
                }
                case 8: {
                    return Opcodes.DOUBLE;
                }
                case 6: {
                    return Opcodes.FLOAT;
                }
            }
            throw new IllegalArgumentException("Unhandled type as method argument: " + type);
        }

        private void visitFrame(MethodVisitor mv, boolean localsIncludeReturn, @Nullable String stackTop) {
            Object[] objectArray;
            boolean hasReturnLocal = this.returnVarIndex != null && localsIncludeReturn;
            Type[] localTypes = Type.getArgumentTypes(this.instrumentedMethod.getDescriptor());
            Object[] locals = new Object[1 + localTypes.length + (hasReturnLocal ? 1 : 0)];
            locals[0] = this.instrumentedMethod.getReceiverType().asErasure().getInternalName();
            for (int i = 0; i < localTypes.length; ++i) {
                locals[i + 1] = this.describeType(localTypes[i]);
            }
            if (hasReturnLocal) {
                locals[locals.length - 1] = this.describeType(Type.getReturnType(this.targetMethod.getDescriptor()));
            }
            if (stackTop == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = stackTop;
            }
            Object[] stack = objectArray;
            mv.visitFrame(-1, locals.length, locals, stack.length, stack);
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor mv, Implementation.Context context) {
            Type returnType;
            StackManipulation.Size size = new StackManipulation.Size(0, 0);
            mv.visitLabel(this.wrapStart);
            String throwableName = new TypeDescription.ForLoadedType(Throwable.class).getInternalName();
            mv.visitTryCatchBlock(this.tryBlockStart, this.tryBlockEnd, this.catchBlockStart, throwableName);
            mv.visitLabel(this.tryBlockStart);
            size = size.aggregate(MethodInvocation.invoke(this.targetMethod).apply(mv, context));
            if (this.returnVarIndex != null) {
                returnType = Type.getReturnType(this.targetMethod.getDescriptor());
                mv.visitVarInsn(returnType.getOpcode(54), this.returnVarIndex);
                size = size.aggregate(new StackManipulation.Size(-1, 0));
            }
            mv.visitJumpInsn(167, this.catchBlockEnd);
            mv.visitLabel(this.tryBlockEnd);
            mv.visitLabel(this.catchBlockStart);
            this.visitFrame(mv, false, throwableName);
            size = size.aggregate(new StackManipulation.Compound(MethodInvocation.invoke(this.createUserCodeException), Throw.INSTANCE).apply(mv, context));
            mv.visitLabel(this.catchBlockEnd);
            this.visitFrame(mv, true, null);
            if (this.returnVarIndex != null) {
                returnType = Type.getReturnType(this.targetMethod.getDescriptor());
                mv.visitVarInsn(returnType.getOpcode(21), this.returnVarIndex);
                size = size.aggregate(new StackManipulation.Size(1, 0));
            }
            mv.visitLabel(this.wrapEnd);
            if (this.returnVarIndex != null) {
                mv.visitLocalVariable("res", this.returnType.getDescriptor(), this.returnType.getGenericSignature(), this.wrapStart, this.wrapEnd, this.returnVarIndex);
            }
            return size;
        }
    }

    private static final class GetSizeDelegation
    extends DoFnMethodWithExtraParametersDelegation {
        private static final MethodDescription VALIDATE_SIZE_METHOD;

        private GetSizeDelegation(TypeDescription doFnType, DoFnSignature.GetSizeMethod signature) {
            super(doFnType, signature);
        }

        @Override
        protected StackManipulation afterDelegation(MethodDescription instrumentedMethod) {
            return new StackManipulation.Compound(MethodInvocation.invoke(VALIDATE_SIZE_METHOD), MethodReturn.DOUBLE);
        }

        static {
            try {
                VALIDATE_SIZE_METHOD = new MethodDescription.ForLoadedMethod(DefaultGetSize.class.getMethod("validateSize", Double.TYPE));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Failed to locate DefaultGetSize.validateSize()");
            }
        }
    }

    private static final class ProcessElementDelegation
    extends DoFnMethodWithExtraParametersDelegation {
        private static final MethodDescription PROCESS_CONTINUATION_STOP_METHOD;
        private final DoFnSignature.ProcessElementMethod signature;

        private ProcessElementDelegation(TypeDescription doFnType, DoFnSignature.ProcessElementMethod signature) {
            super(doFnType, signature);
            this.signature = signature;
        }

        @Override
        protected StackManipulation afterDelegation(MethodDescription instrumentedMethod) {
            if (TypeDescription.VOID.equals(this.targetMethod.getReturnType().asErasure())) {
                return new StackManipulation.Compound(MethodInvocation.invoke(PROCESS_CONTINUATION_STOP_METHOD), MethodReturn.REFERENCE);
            }
            return MethodReturn.of(this.targetMethod.getReturnType().asErasure());
        }

        static {
            try {
                PROCESS_CONTINUATION_STOP_METHOD = new MethodDescription.ForLoadedMethod(DoFn.ProcessContinuation.class.getMethod("stop", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Failed to locate ProcessContinuation.stop()");
            }
        }
    }

    private static class DowncastingParametersMethodDelegation
    extends DoFnMethodDelegation {
        DowncastingParametersMethodDelegation(TypeDescription doFnType, Method method) {
            super(doFnType, method);
        }

        @Override
        protected StackManipulation beforeDelegation(MethodDescription instrumentedMethod) {
            ArrayList<StackManipulation> pushParameters = new ArrayList<StackManipulation>();
            TypeList.Generic paramTypes = this.targetMethod.getParameters().asTypeList();
            for (int i = 0; i < paramTypes.size(); ++i) {
                TypeDescription.Generic paramT = (TypeDescription.Generic)paramTypes.get(i);
                pushParameters.add(MethodVariableAccess.of(paramT).loadFrom(i + 1));
                if (paramT.isPrimitive()) continue;
                pushParameters.add(TypeCasting.to(paramT));
            }
            return new StackManipulation.Compound(pushParameters);
        }
    }

    static class DoFnMethodWithExtraParametersDelegation
    extends DoFnMethodDelegation {
        private final DoFnSignature.MethodWithExtraParameters signature;

        public DoFnMethodWithExtraParametersDelegation(TypeDescription clazzDescription, DoFnSignature.MethodWithExtraParameters signature) {
            super(clazzDescription, signature.targetMethod());
            this.signature = signature;
        }

        @Override
        protected StackManipulation beforeDelegation(MethodDescription instrumentedMethod) {
            ArrayList<StackManipulation.Compound> parameters = new ArrayList<StackManipulation.Compound>();
            StackManipulation.Compound pushDelegate = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(0), FieldAccess.forField(this.delegateField).read());
            StackManipulation pushExtraContextFactory = MethodVariableAccess.REFERENCE.loadFrom(1);
            for (DoFnSignature.Parameter param : this.signature.extraParameters()) {
                parameters.add(new StackManipulation.Compound(pushExtraContextFactory, ByteBuddyDoFnInvokerFactory.getExtraContextParameter(param, pushDelegate)));
            }
            return new StackManipulation.Compound(parameters);
        }
    }

    static class DoFnMethodDelegation
    implements Implementation {
        protected final MethodDescription targetMethod;
        private final boolean targetHasReturn;
        protected @Nullable FieldDescription delegateField;
        private final TypeDescription doFnType;

        public DoFnMethodDelegation(TypeDescription doFnType, Method targetMethod) {
            this.doFnType = doFnType;
            this.targetMethod = new MethodDescription.ForLoadedMethod(targetMethod);
            this.targetHasReturn = !TypeDescription.VOID.equals(this.targetMethod.getReturnType().asErasure());
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            this.delegateField = (FieldDescription)((FieldList)instrumentedType.getSuperClass().getDeclaredFields().filter(ElementMatchers.named(ByteBuddyDoFnInvokerFactory.FN_DELEGATE_FIELD_NAME))).getOnly();
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new ByteCodeAppender(){

                @Override
                public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                    int numLocals = 1 + instrumentedMethod.getParameters().size() + (targetHasReturn ? Type.getReturnType(instrumentedMethod.getDescriptor()).getSize() : 0);
                    Integer returnVarIndex = null;
                    if (targetHasReturn) {
                        returnVarIndex = 1;
                        for (Type param : Type.getArgumentTypes(instrumentedMethod.getDescriptor())) {
                            returnVarIndex = returnVarIndex + param.getSize();
                        }
                    }
                    StackManipulation.Compound manipulation = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(0), FieldAccess.forField(delegateField).read(), TypeCasting.to(doFnType), this.beforeDelegation(instrumentedMethod), new UserCodeMethodInvocation(returnVarIndex, targetMethod, instrumentedMethod), this.afterDelegation(instrumentedMethod));
                    StackManipulation.Size size = manipulation.apply(methodVisitor, implementationContext);
                    return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
                }
            };
        }

        protected StackManipulation beforeDelegation(MethodDescription instrumentedMethod) {
            return MethodVariableAccess.allArgumentsOf(this.targetMethod);
        }

        protected StackManipulation afterDelegation(MethodDescription instrumentedMethod) {
            return new StackManipulation.Compound(Assigner.DEFAULT.assign(this.targetMethod.getReturnType(), instrumentedMethod.getReturnType(), Assigner.Typing.STATIC), MethodReturn.of(instrumentedMethod.getReturnType()));
        }
    }

    public static class DefaultGetSize {
        public static <InputT, OutputT> double invokeGetSize(DoFnInvoker.ArgumentProvider<InputT, OutputT> argumentProvider) {
            if (argumentProvider.restrictionTracker() instanceof RestrictionTracker.HasProgress) {
                return ((RestrictionTracker.HasProgress)((Object)argumentProvider.restrictionTracker())).getProgress().getWorkRemaining();
            }
            return 1.0;
        }

        public static double validateSize(double size) {
            if (size < 0.0) {
                throw new IllegalArgumentException(String.format("Expected size >= 0 but received %s.", size));
            }
            return size;
        }
    }

    public static class DefaultNewTracker {
        public static <InputT, OutputT, RestrictionT, PositionT> RestrictionTracker<RestrictionT, PositionT> invokeNewTracker(DoFnInvoker.ArgumentProvider<InputT, OutputT> argumentProvider) {
            return ((HasDefaultTracker)argumentProvider.restriction()).newTracker();
        }
    }

    public static class DefaultNewWatermarkEstimator {
        public static <InputT, OutputT, WatermarkEstimatorStateT> WatermarkEstimator<WatermarkEstimatorStateT> invokeNewWatermarkEstimator(DoFnInvoker.ArgumentProvider<InputT, OutputT> argumentProvider) {
            if (argumentProvider.watermarkEstimatorState() instanceof HasDefaultWatermarkEstimator) {
                return ((HasDefaultWatermarkEstimator)argumentProvider.watermarkEstimatorState()).newWatermarkEstimator();
            }
            return new WatermarkEstimator<WatermarkEstimatorStateT>(){

                @Override
                public Instant currentWatermark() {
                    return GlobalWindow.TIMESTAMP_MIN_VALUE;
                }

                @Override
                public WatermarkEstimatorStateT getState() {
                    return null;
                }
            };
        }
    }

    public static class DefaultGetInitialWatermarkEstimatorState {
        public static <InputT, OutputT, WatermarkEstimatorStateT> WatermarkEstimator<WatermarkEstimatorStateT> invokeNewWatermarkEstimator(DoFnInvoker.ArgumentProvider<InputT, OutputT> argumentProvider) {
            return null;
        }
    }

    public static class DefaultWatermarkEstimatorStateCoder {
        private final TypeDescriptor<?> watermarkEstimatorStateType;

        DefaultWatermarkEstimatorStateCoder(TypeDescriptor<?> watermarkEstimatorStateType) {
            this.watermarkEstimatorStateType = watermarkEstimatorStateType;
        }

        public <WatermarkEstimatorStateT> Coder<WatermarkEstimatorStateT> invokeGetWatermarkEstimatorStateCoder(CoderRegistry registry) throws CannotProvideCoderException {
            return registry.getCoder(this.watermarkEstimatorStateType);
        }
    }

    public static class DefaultRestrictionCoder {
        private final TypeDescriptor<?> restrictionType;

        DefaultRestrictionCoder(TypeDescriptor<?> restrictionType) {
            this.restrictionType = restrictionType;
        }

        public <RestrictionT> Coder<RestrictionT> invokeGetRestrictionCoder(CoderRegistry registry) throws CannotProvideCoderException {
            return registry.getCoder(this.restrictionType);
        }
    }

    public static class DefaultTruncateRestriction {
        public static RestrictionTracker.TruncateResult<?> invokeTruncateRestriction(DoFnInvoker.ArgumentProvider argumentProvider) {
            if (argumentProvider.restrictionTracker().isBounded() == RestrictionTracker.IsBounded.BOUNDED) {
                return RestrictionTracker.TruncateResult.of(argumentProvider.restriction());
            }
            return null;
        }
    }

    public static class DefaultSplitRestriction {
        public static void invokeSplitRestriction(DoFnInvoker.ArgumentProvider argumentProvider) {
            argumentProvider.outputReceiver(null).output(argumentProvider.restriction());
        }
    }

    public static abstract class DoFnInvokerBase<InputT, OutputT, DoFnT extends DoFn<InputT, OutputT>>
    implements DoFnInvoker<InputT, OutputT> {
        protected DoFnT delegate;
        private Map<String, OnTimerInvoker> onTimerInvokers = Maps.newHashMap();
        private Map<String, OnTimerInvoker> onTimerFamilyInvokers = Maps.newHashMap();

        public DoFnInvokerBase(DoFnT delegate) {
            this.delegate = delegate;
        }

        void addOnTimerInvoker(String timerId, OnTimerInvoker onTimerInvoker) {
            this.onTimerInvokers.put(timerId, onTimerInvoker);
        }

        void addOnTimerFamilyInvoker(String timerFamilyId, OnTimerInvoker onTimerInvoker) {
            this.onTimerFamilyInvokers.put(timerFamilyId, onTimerInvoker);
        }

        @Override
        public void invokeOnTimer(String timerId, String timerFamilyId, DoFnInvoker.ArgumentProvider<InputT, OutputT> arguments) {
            OnTimerInvoker onTimerInvoker;
            OnTimerInvoker onTimerInvoker2 = onTimerInvoker = timerFamilyId.isEmpty() ? this.onTimerInvokers.get(timerId) : this.onTimerFamilyInvokers.get(timerFamilyId);
            if (onTimerInvoker == null) {
                throw new IllegalArgumentException(String.format("Attempted to invoke timer %s on %s, but that timer is not registered. This is the responsibility of the runner, which must only deliver registered timers.", timerId, this.delegate.getClass().getName()));
            }
            onTimerInvoker.invokeOnTimer(arguments);
        }

        @Override
        public DoFn<InputT, OutputT> getFn() {
            return this.delegate;
        }
    }
}

