/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import com.google.auto.value.AutoValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.MapState;
import org.apache.beam.sdk.state.OrderedListState;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.state.SetState;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerMap;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.state.WatermarkHoldState;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignatures_ParameterDescription;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.splittabledofn.HasDefaultTracker;
import org.apache.beam.sdk.transforms.splittabledofn.HasDefaultWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

@Internal
public class DoFnSignatures {
    private static final Map<Class<?>, DoFnSignature> signatureCache = new LinkedHashMap();
    private static final ImmutableList<Class<? extends DoFnSignature.Parameter>> ALLOWED_NON_SPLITTABLE_PROCESS_ELEMENT_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.ProcessContextParameter.class, DoFnSignature.Parameter.ElementParameter.class, DoFnSignature.Parameter.SchemaElementParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.OutputReceiverParameter.class, DoFnSignature.Parameter.TaggedOutputReceiverParameter.class, DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.PaneInfoParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class, DoFnSignature.Parameter.TimerParameter.class, DoFnSignature.Parameter.StateParameter.class, DoFnSignature.Parameter.SideInputParameter.class, new Class[]{DoFnSignature.Parameter.TimerFamilyParameter.class, DoFnSignature.Parameter.BundleFinalizerParameter.class});
    private static final ImmutableList<Class<? extends DoFnSignature.Parameter>> ALLOWED_SPLITTABLE_PROCESS_ELEMENT_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.PaneInfoParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class, DoFnSignature.Parameter.ElementParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.OutputReceiverParameter.class, DoFnSignature.Parameter.TaggedOutputReceiverParameter.class, DoFnSignature.Parameter.ProcessContextParameter.class, DoFnSignature.Parameter.RestrictionTrackerParameter.class, DoFnSignature.Parameter.WatermarkEstimatorParameter.class, DoFnSignature.Parameter.SideInputParameter.class, DoFnSignature.Parameter.BundleFinalizerParameter.class, new Class[0]);
    private static final ImmutableList<Class<? extends DoFnSignature.Parameter>> ALLOWED_SETUP_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.PipelineOptionsParameter.class);
    private static final ImmutableList<Class<? extends DoFnSignature.Parameter>> ALLOWED_START_BUNDLE_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.PipelineOptionsParameter.class, DoFnSignature.Parameter.StartBundleContextParameter.class, DoFnSignature.Parameter.BundleFinalizerParameter.class);
    private static final ImmutableList<Class<? extends DoFnSignature.Parameter>> ALLOWED_FINISH_BUNDLE_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.PipelineOptionsParameter.class, DoFnSignature.Parameter.FinishBundleContextParameter.class, DoFnSignature.Parameter.BundleFinalizerParameter.class);
    private static final ImmutableList<Class<? extends DoFnSignature.Parameter>> ALLOWED_ON_TIMER_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.OnTimerContextParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.TimeDomainParameter.class, DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class, DoFnSignature.Parameter.OutputReceiverParameter.class, DoFnSignature.Parameter.TaggedOutputReceiverParameter.class, DoFnSignature.Parameter.TimerParameter.class, DoFnSignature.Parameter.StateParameter.class, DoFnSignature.Parameter.TimerFamilyParameter.class, DoFnSignature.Parameter.TimerIdParameter.class, DoFnSignature.Parameter.KeyParameter.class, new Class[0]);
    private static final ImmutableList<Class<? extends DoFnSignature.Parameter>> ALLOWED_ON_TIMER_FAMILY_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.OnTimerContextParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.TimeDomainParameter.class, DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class, DoFnSignature.Parameter.OutputReceiverParameter.class, DoFnSignature.Parameter.TaggedOutputReceiverParameter.class, DoFnSignature.Parameter.TimerParameter.class, DoFnSignature.Parameter.StateParameter.class, DoFnSignature.Parameter.TimerFamilyParameter.class, DoFnSignature.Parameter.TimerIdParameter.class, DoFnSignature.Parameter.KeyParameter.class, new Class[0]);
    private static final Collection<Class<? extends DoFnSignature.Parameter>> ALLOWED_ON_WINDOW_EXPIRATION_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class, DoFnSignature.Parameter.OutputReceiverParameter.class, DoFnSignature.Parameter.TaggedOutputReceiverParameter.class, DoFnSignature.Parameter.StateParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.KeyParameter.class);
    private static final Collection<Class<? extends DoFnSignature.Parameter>> ALLOWED_GET_INITIAL_RESTRICTION_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.ElementParameter.class, DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.PaneInfoParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class);
    private static final Collection<Class<? extends DoFnSignature.Parameter>> ALLOWED_SPLIT_RESTRICTION_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.ElementParameter.class, DoFnSignature.Parameter.RestrictionParameter.class, DoFnSignature.Parameter.RestrictionTrackerParameter.class, DoFnSignature.Parameter.OutputReceiverParameter.class, DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.PaneInfoParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class);
    private static final Collection<Class<? extends DoFnSignature.Parameter>> ALLOWED_TRUNCATE_RESTRICTION_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.ElementParameter.class, DoFnSignature.Parameter.RestrictionParameter.class, DoFnSignature.Parameter.RestrictionTrackerParameter.class, DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.PaneInfoParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class);
    private static final Collection<Class<? extends DoFnSignature.Parameter>> ALLOWED_NEW_TRACKER_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.ElementParameter.class, DoFnSignature.Parameter.RestrictionParameter.class, DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.PaneInfoParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class);
    private static final Collection<Class<? extends DoFnSignature.Parameter>> ALLOWED_GET_SIZE_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.ElementParameter.class, DoFnSignature.Parameter.RestrictionParameter.class, DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.PaneInfoParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class);
    private static final Collection<Class<? extends DoFnSignature.Parameter>> ALLOWED_GET_INITIAL_WATERMARK_ESTIMATOR_STATE_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.ElementParameter.class, DoFnSignature.Parameter.RestrictionParameter.class, DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.PaneInfoParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class);
    private static final Collection<Class<? extends DoFnSignature.Parameter>> ALLOWED_NEW_WATERMARK_ESTIMATOR_PARAMETERS = ImmutableList.of(DoFnSignature.Parameter.WatermarkEstimatorStateParameter.class, DoFnSignature.Parameter.ElementParameter.class, DoFnSignature.Parameter.RestrictionParameter.class, DoFnSignature.Parameter.WindowParameter.class, DoFnSignature.Parameter.TimestampParameter.class, DoFnSignature.Parameter.PaneInfoParameter.class, DoFnSignature.Parameter.PipelineOptionsParameter.class);

    private DoFnSignatures() {
    }

    public static <FnT extends DoFn<?, ?>> DoFnSignature signatureForDoFn(FnT fn) {
        return DoFnSignatures.getSignature(fn.getClass());
    }

    public static synchronized <FnT extends DoFn<?, ?>> DoFnSignature getSignature(Class<FnT> fn) {
        return signatureCache.computeIfAbsent(fn, k -> DoFnSignatures.parseSignature(fn));
    }

    private static DoFnSignature parseSignature(Class<? extends DoFn<?, ?>> fnClass) {
        DoFnSignature.Builder signatureBuilder = DoFnSignature.builder();
        ErrorReporter errors = new ErrorReporter(null, fnClass.getName());
        errors.checkArgument(DoFn.class.isAssignableFrom(fnClass), "Must be subtype of DoFn", new Object[0]);
        signatureBuilder.setFnClass(fnClass);
        TypeDescriptor<DoFn<?, ?>> fnT = TypeDescriptor.of(fnClass);
        TypeDescriptor<?> inputT = null;
        TypeDescriptor<?> outputT = null;
        for (TypeDescriptor supertype : fnT.getTypes()) {
            if (!supertype.getRawType().equals(DoFn.class)) continue;
            Type[] args = ((ParameterizedType)supertype.getType()).getActualTypeArguments();
            inputT = TypeDescriptor.of(args[0]);
            outputT = TypeDescriptor.of(args[1]);
        }
        errors.checkNotNull(inputT, "Unable to determine input type", new Object[0]);
        FnAnalysisContext fnContext = FnAnalysisContext.create();
        fnContext.addStateDeclarations(DoFnSignatures.analyzeStateDeclarations(errors, fnClass).values());
        fnContext.addTimerDeclarations(DoFnSignatures.analyzeTimerDeclarations(errors, fnClass).values());
        fnContext.addTimerFamilyDeclarations(DoFnSignatures.analyzeTimerFamilyDeclarations(errors, fnClass).values());
        fnContext.addFieldAccessDeclarations(DoFnSignatures.analyzeFieldAccessDeclaration(errors, fnClass).values());
        Method processElementMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.ProcessElement.class, fnClass, true);
        Method startBundleMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.StartBundle.class, fnClass, false);
        Method finishBundleMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.FinishBundle.class, fnClass, false);
        Method setupMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.Setup.class, fnClass, false);
        Method teardownMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.Teardown.class, fnClass, false);
        Method onWindowExpirationMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.OnWindowExpiration.class, fnClass, false);
        Method getInitialRestrictionMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.GetInitialRestriction.class, fnClass, false);
        Method splitRestrictionMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.SplitRestriction.class, fnClass, false);
        Method truncateRestrictionMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.TruncateRestriction.class, fnClass, false);
        Method getRestrictionCoderMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.GetRestrictionCoder.class, fnClass, false);
        Method newTrackerMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.NewTracker.class, fnClass, false);
        Method getSizeMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.GetSize.class, fnClass, false);
        Method getWatermarkEstimatorStateCoderMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.GetWatermarkEstimatorStateCoder.class, fnClass, false);
        Method getInitialWatermarkEstimatorStateMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.GetInitialWatermarkEstimatorState.class, fnClass, false);
        Method newWatermarkEstimatorMethod = DoFnSignatures.findAnnotatedMethod(errors, DoFn.NewWatermarkEstimator.class, fnClass, false);
        Collection<Method> onTimerMethods = ReflectHelpers.declaredMethodsWithAnnotation(DoFn.OnTimer.class, fnClass, DoFn.class);
        HashMap<String, DoFnSignature.OnTimerMethod> onTimerMethodMap = Maps.newHashMapWithExpectedSize(onTimerMethods.size());
        for (Method onTimerMethod : onTimerMethods) {
            Iterator<Object> id = "ts-" + onTimerMethod.getAnnotation(DoFn.OnTimer.class).value();
            errors.checkArgument(fnContext.getTimerDeclarations().containsKey(id), "Callback %s is for undeclared timer %s", onTimerMethod, id);
            DoFnSignature.TimerDeclaration timerDeclaration = fnContext.getTimerDeclarations().get(id);
            errors.checkArgument(timerDeclaration.field().getDeclaringClass().equals(DoFnSignatures.getDeclaringClass(onTimerMethod)), "Callback %s is for timer %s declared in a different class %s. Timer callbacks must be declared in the same lexical scope as their timer", onTimerMethod, id, timerDeclaration.field().getDeclaringClass().getCanonicalName());
            onTimerMethodMap.put((String)((Object)id), DoFnSignatures.analyzeOnTimerMethod(errors, fnT, onTimerMethod, id, inputT, outputT, fnContext));
        }
        signatureBuilder.setOnTimerMethods(onTimerMethodMap);
        Collection<Method> onTimerFamilyMethods = ReflectHelpers.declaredMethodsWithAnnotation(DoFn.OnTimerFamily.class, fnClass, DoFn.class);
        HashMap<String, DoFnSignature.OnTimerFamilyMethod> onTimerFamilyMethodMap = Maps.newHashMapWithExpectedSize(onTimerFamilyMethods.size());
        for (Method method : onTimerFamilyMethods) {
            String id = "tfs-" + method.getAnnotation(DoFn.OnTimerFamily.class).value();
            errors.checkArgument(fnContext.getTimerFamilyDeclarations().containsKey(id), "Callback %s is for undeclared timerFamily %s", method, id);
            DoFnSignature.TimerFamilyDeclaration timerDecl = fnContext.getTimerFamilyDeclarations().get(id);
            errors.checkArgument(timerDecl.field().getDeclaringClass().equals(DoFnSignatures.getDeclaringClass(method)), "Callback %s is for timerFamily %s declared in a different class %s. TimerFamily callbacks must be declared in the same lexical scope as their timer", method, id, timerDecl.field().getDeclaringClass().getCanonicalName());
            onTimerFamilyMethodMap.put(id, DoFnSignatures.analyzeOnTimerFamilyMethod(errors, fnT, method, id, inputT, outputT, fnContext));
        }
        signatureBuilder.setOnTimerFamilyMethods(onTimerFamilyMethodMap);
        for (DoFnSignature.TimerDeclaration timerDeclaration : fnContext.getTimerDeclarations().values()) {
            errors.checkArgument(onTimerMethodMap.containsKey(timerDeclaration.id()), "No callback registered via %s for timer %s", DoFnSignatures.format(DoFn.OnTimer.class), timerDeclaration.id());
        }
        for (DoFnSignature.TimerFamilyDeclaration timerFamilyDeclaration : fnContext.getTimerFamilyDeclarations().values()) {
            errors.checkArgument(onTimerFamilyMethodMap.containsKey(timerFamilyDeclaration.id()), "No callback registered via %s for timerFamily %s", DoFnSignatures.format(DoFn.OnTimerFamily.class), timerFamilyDeclaration.id());
        }
        ErrorReporter processElementErrors = errors.forMethod(DoFn.ProcessElement.class, processElementMethod);
        DoFnSignature.ProcessElementMethod processElementMethod2 = DoFnSignatures.analyzeProcessElementMethod(processElementErrors, fnT, processElementMethod, inputT, outputT, fnContext);
        signatureBuilder.setProcessElement(processElementMethod2);
        if (startBundleMethod != null) {
            ErrorReporter startBundleErrors = errors.forMethod(DoFn.StartBundle.class, startBundleMethod);
            signatureBuilder.setStartBundle(DoFnSignatures.analyzeStartBundleMethod(startBundleErrors, fnT, startBundleMethod, inputT, outputT, fnContext));
        }
        if (finishBundleMethod != null) {
            ErrorReporter finishBundleErrors = errors.forMethod(DoFn.FinishBundle.class, finishBundleMethod);
            signatureBuilder.setFinishBundle(DoFnSignatures.analyzeFinishBundleMethod(finishBundleErrors, fnT, finishBundleMethod, inputT, outputT, fnContext));
        }
        if (setupMethod != null) {
            ErrorReporter setupErrors = errors.forMethod(DoFn.Setup.class, setupMethod);
            signatureBuilder.setSetup(DoFnSignatures.analyzeSetupMethod(setupErrors, fnT, setupMethod, inputT, outputT, fnContext));
        }
        if (teardownMethod != null) {
            signatureBuilder.setTeardown(DoFnSignatures.analyzeShutdownMethod(errors.forMethod(DoFn.Teardown.class, teardownMethod), teardownMethod));
        }
        if (onWindowExpirationMethod != null) {
            signatureBuilder.setOnWindowExpiration(DoFnSignatures.analyzeOnWindowExpirationMethod(errors, fnT, onWindowExpirationMethod, inputT, outputT, fnContext));
        }
        if (processElementMethod2.isSplittable()) {
            ErrorReporter getInitialRestrictionErrors = errors.forMethod(DoFn.GetInitialRestriction.class, getInitialRestrictionMethod);
            getInitialRestrictionErrors.checkNotNull(getInitialRestrictionMethod, "Splittable, but does not define the required @%s method.", DoFnSignatures.format(DoFn.GetInitialRestriction.class));
            DoFnSignature.GetInitialRestrictionMethod initialRestrictionMethod = DoFnSignatures.analyzeGetInitialRestrictionMethod(errors.forMethod(DoFn.GetInitialRestriction.class, getInitialRestrictionMethod), fnT, getInitialRestrictionMethod, inputT, outputT, fnContext);
            signatureBuilder.setGetInitialRestriction(initialRestrictionMethod);
            TypeDescriptor<HasDefaultTracker> restrictionT = initialRestrictionMethod.restrictionT();
            TypeDescriptor<Void> watermarkEstimatorStateT = TypeDescriptors.voids();
            if (getInitialWatermarkEstimatorStateMethod != null) {
                DoFnSignature.GetInitialWatermarkEstimatorStateMethod initialWatermarkEstimatorStateMethod = DoFnSignatures.analyzeGetInitialWatermarkEstimatorStateMethod(errors.forMethod(DoFn.GetInitialWatermarkEstimatorState.class, getInitialWatermarkEstimatorStateMethod), fnT, getInitialWatermarkEstimatorStateMethod, inputT, outputT, fnContext);
                watermarkEstimatorStateT = initialWatermarkEstimatorStateMethod.watermarkEstimatorStateT();
                signatureBuilder.setGetInitialWatermarkEstimatorState(initialWatermarkEstimatorStateMethod);
            }
            if (newTrackerMethod != null) {
                signatureBuilder.setNewTracker(DoFnSignatures.analyzeNewTrackerMethod(errors.forMethod(DoFn.NewTracker.class, newTrackerMethod), fnT, newTrackerMethod, inputT, outputT, restrictionT, fnContext));
            } else {
                errors.forMethod(DoFn.NewTracker.class, null).checkArgument(restrictionT.isSubtypeOf(TypeDescriptor.of(HasDefaultTracker.class)), "Splittable, either @%s method must be defined or %s must implement %s.", DoFnSignatures.format(DoFn.NewTracker.class), DoFnSignatures.format(restrictionT), DoFnSignatures.format(HasDefaultTracker.class));
            }
            if (splitRestrictionMethod != null) {
                signatureBuilder.setSplitRestriction(DoFnSignatures.analyzeSplitRestrictionMethod(errors.forMethod(DoFn.SplitRestriction.class, splitRestrictionMethod), fnT, splitRestrictionMethod, inputT, outputT, restrictionT, fnContext));
            }
            if (truncateRestrictionMethod != null) {
                signatureBuilder.setTruncateRestriction(DoFnSignatures.analyzeTruncateRestrictionMethod(errors.forMethod(DoFn.TruncateRestriction.class, truncateRestrictionMethod), fnT, truncateRestrictionMethod, inputT, restrictionT, fnContext));
            }
            if (getSizeMethod != null) {
                signatureBuilder.setGetSize(DoFnSignatures.analyzeGetSizeMethod(errors.forMethod(DoFn.GetSize.class, getSizeMethod), fnT, getSizeMethod, inputT, outputT, restrictionT, fnContext));
            }
            if (getRestrictionCoderMethod != null) {
                signatureBuilder.setGetRestrictionCoder(DoFnSignatures.analyzeGetRestrictionCoderMethod(errors.forMethod(DoFn.GetRestrictionCoder.class, getRestrictionCoderMethod), fnT, getRestrictionCoderMethod));
            }
            if (getWatermarkEstimatorStateCoderMethod != null) {
                signatureBuilder.setGetWatermarkEstimatorStateCoder(DoFnSignatures.analyzeGetWatermarkEstimatorStateCoderMethod(errors.forMethod(DoFn.GetWatermarkEstimatorStateCoder.class, getWatermarkEstimatorStateCoderMethod), fnT, getWatermarkEstimatorStateCoderMethod));
            }
            if (newWatermarkEstimatorMethod != null) {
                signatureBuilder.setNewWatermarkEstimator(DoFnSignatures.analyzeNewWatermarkEstimatorMethod(errors.forMethod(DoFn.NewWatermarkEstimator.class, newWatermarkEstimatorMethod), fnT, newWatermarkEstimatorMethod, inputT, outputT, restrictionT, watermarkEstimatorStateT, fnContext));
            } else if (getInitialWatermarkEstimatorStateMethod != null) {
                errors.forMethod(DoFn.NewWatermarkEstimator.class, null).checkArgument(watermarkEstimatorStateT.isSubtypeOf(TypeDescriptor.of(HasDefaultWatermarkEstimator.class)), "Splittable, either @%s method must be defined or %s must implement %s.", DoFnSignatures.format(DoFn.NewWatermarkEstimator.class), DoFnSignatures.format(watermarkEstimatorStateT), DoFnSignatures.format(HasDefaultWatermarkEstimator.class));
            }
        } else {
            ArrayList<String> forbiddenMethods = new ArrayList<String>();
            if (getInitialRestrictionMethod != null) {
                forbiddenMethods.add("@" + DoFnSignatures.format(DoFn.GetInitialRestriction.class));
            }
            if (splitRestrictionMethod != null) {
                forbiddenMethods.add("@" + DoFnSignatures.format(DoFn.SplitRestriction.class));
            }
            if (truncateRestrictionMethod != null) {
                forbiddenMethods.add("@" + DoFnSignatures.format(DoFn.TruncateRestriction.class));
            }
            if (newTrackerMethod != null) {
                forbiddenMethods.add("@" + DoFnSignatures.format(DoFn.NewTracker.class));
            }
            if (getRestrictionCoderMethod != null) {
                forbiddenMethods.add("@" + DoFnSignatures.format(DoFn.GetRestrictionCoder.class));
            }
            if (getSizeMethod != null) {
                forbiddenMethods.add("@" + DoFnSignatures.format(DoFn.GetSize.class));
            }
            if (getInitialWatermarkEstimatorStateMethod != null) {
                forbiddenMethods.add("@" + DoFnSignatures.format(DoFn.GetInitialWatermarkEstimatorState.class));
            }
            if (getWatermarkEstimatorStateCoderMethod != null) {
                forbiddenMethods.add("@" + DoFnSignatures.format(DoFn.GetWatermarkEstimatorStateCoder.class));
            }
            if (newWatermarkEstimatorMethod != null) {
                forbiddenMethods.add("@" + DoFnSignatures.format(DoFn.NewWatermarkEstimator.class));
            }
            errors.checkArgument(forbiddenMethods.isEmpty(), "Non-splittable, but defines methods: %s", forbiddenMethods);
        }
        signatureBuilder.setIsBoundedPerElement(DoFnSignatures.inferBoundedness(fnT, processElementMethod2, errors));
        signatureBuilder.setStateDeclarations(fnContext.getStateDeclarations());
        signatureBuilder.setTimerDeclarations(fnContext.getTimerDeclarations());
        signatureBuilder.setTimerFamilyDeclarations(fnContext.getTimerFamilyDeclarations());
        signatureBuilder.setFieldAccessDeclarations(fnContext.getFieldAccessDeclarations());
        DoFnSignature signature = signatureBuilder.build();
        if (processElementMethod2.isSplittable()) {
            DoFnSignatures.verifySplittableMethods(signature, errors);
        }
        return signature;
    }

    private static Class<?> getDeclaringClass(Method onTimerMethod) {
        Class<?> declaringClass = onTimerMethod.getDeclaringClass();
        if (declaringClass.getName().contains("$MockitoMock$")) {
            declaringClass = declaringClass.getSuperclass();
        }
        return declaringClass;
    }

    private static PCollection.IsBounded inferBoundedness(TypeDescriptor<? extends DoFn> fnT, DoFnSignature.ProcessElementMethod processElement, ErrorReporter errors) {
        PCollection.IsBounded isBounded = null;
        for (TypeDescriptor supertype : fnT.getTypes()) {
            if (!supertype.getRawType().isAnnotationPresent(DoFn.BoundedPerElement.class) && !supertype.getRawType().isAnnotationPresent(DoFn.UnboundedPerElement.class)) continue;
            errors.checkArgument(isBounded == null, "Both @%s and @%s specified", DoFnSignatures.format(DoFn.BoundedPerElement.class), DoFnSignatures.format(DoFn.UnboundedPerElement.class));
            isBounded = supertype.getRawType().isAnnotationPresent(DoFn.BoundedPerElement.class) ? PCollection.IsBounded.BOUNDED : PCollection.IsBounded.UNBOUNDED;
        }
        if (processElement.isSplittable()) {
            if (isBounded == null) {
                isBounded = processElement.hasReturnValue() ? PCollection.IsBounded.UNBOUNDED : PCollection.IsBounded.BOUNDED;
            }
        } else {
            errors.checkArgument(isBounded == null, "Non-splittable, but annotated as @" + (isBounded == PCollection.IsBounded.BOUNDED ? DoFnSignatures.format(DoFn.BoundedPerElement.class) : DoFnSignatures.format(DoFn.UnboundedPerElement.class)), new Object[0]);
            Preconditions.checkState(!processElement.hasReturnValue(), "Should have been inferred splittable");
            isBounded = PCollection.IsBounded.BOUNDED;
        }
        return isBounded;
    }

    private static void verifySplittableMethods(DoFnSignature signature, ErrorReporter errors) {
        TypeDescriptor<Void> watermarkEstimatorStateT;
        DoFnSignature.ProcessElementMethod processElement = signature.processElement();
        DoFnSignature.GetInitialRestrictionMethod getInitialRestriction = signature.getInitialRestriction();
        DoFnSignature.NewTrackerMethod newTracker = signature.newTracker();
        DoFnSignature.GetRestrictionCoderMethod getRestrictionCoder = signature.getRestrictionCoder();
        DoFnSignature.GetInitialWatermarkEstimatorStateMethod getInitialWatermarkEstimatorState = signature.getInitialWatermarkEstimatorState();
        DoFnSignature.GetWatermarkEstimatorStateCoderMethod getWatermarkEstimatorStateCoder = signature.getWatermarkEstimatorStateCoder();
        ErrorReporter processElementErrors = errors.forMethod(DoFn.ProcessElement.class, processElement.targetMethod());
        TypeDescriptor<HasDefaultTracker> restrictionT = getInitialRestriction.restrictionT();
        TypeDescriptor<Void> typeDescriptor = watermarkEstimatorStateT = getInitialWatermarkEstimatorState == null ? TypeDescriptors.voids() : getInitialWatermarkEstimatorState.watermarkEstimatorStateT();
        if (newTracker == null) {
            ErrorReporter newTrackerErrors = errors.forMethod(DoFn.NewTracker.class, null);
            newTrackerErrors.checkArgument(restrictionT.isSubtypeOf(TypeDescriptor.of(HasDefaultTracker.class)), "Splittable, but does not define @%s method or %s does not implement %s.", DoFnSignatures.format(DoFn.NewTracker.class), DoFnSignatures.format(restrictionT), DoFnSignatures.format(HasDefaultTracker.class));
        }
        processElementErrors.checkArgument(processElement.trackerT().getRawType().equals(RestrictionTracker.class), "Has tracker type %s, but the DoFn's tracker type must be of type RestrictionTracker.", DoFnSignatures.format(processElement.trackerT()));
        if (processElement.watermarkEstimatorT() != null) {
            processElementErrors.checkArgument(processElement.watermarkEstimatorT().getRawType().equals(WatermarkEstimator.class) || processElement.watermarkEstimatorT().getRawType().equals(ManualWatermarkEstimator.class), "Has watermark estimator type %s, but the DoFn's watermark estimator type must be one of [WatermarkEstimator, ManualWatermarkEstimator] types.", DoFnSignatures.format(processElement.watermarkEstimatorT()));
        }
        if (getRestrictionCoder != null) {
            ErrorReporter getInitialRestrictionErrors = errors.forMethod(DoFn.GetInitialRestriction.class, getInitialRestriction.targetMethod());
            getInitialRestrictionErrors.checkArgument(getRestrictionCoder.coderT().isSubtypeOf(DoFnSignatures.coderTypeOf(restrictionT)), "Uses restriction type %s, but @%s method %s returns %s which is not a subtype of %s", DoFnSignatures.format(restrictionT), DoFnSignatures.format(DoFn.GetRestrictionCoder.class), DoFnSignatures.format(getRestrictionCoder.targetMethod()), DoFnSignatures.format(getRestrictionCoder.coderT()), DoFnSignatures.format(DoFnSignatures.coderTypeOf(restrictionT)));
        }
        if (getWatermarkEstimatorStateCoder != null) {
            ErrorReporter getInitialWatermarkEstimatorStateReporter = errors.forMethod(DoFn.GetInitialWatermarkEstimatorState.class, getInitialWatermarkEstimatorState == null ? null : getInitialWatermarkEstimatorState.targetMethod());
            getInitialWatermarkEstimatorStateReporter.checkArgument(getWatermarkEstimatorStateCoder.coderT().isSubtypeOf(DoFnSignatures.coderTypeOf(watermarkEstimatorStateT)), "Uses watermark estimator state type %s, but @%s method %s returns %s which is not a subtype of %s", DoFnSignatures.format(watermarkEstimatorStateT), DoFnSignatures.format(DoFn.GetInitialWatermarkEstimatorState.class), DoFnSignatures.format(getWatermarkEstimatorStateCoder.targetMethod()), DoFnSignatures.format(getWatermarkEstimatorStateCoder.coderT()), DoFnSignatures.format(DoFnSignatures.coderTypeOf(watermarkEstimatorStateT)));
        }
    }

    private static <InputT, OutputT> TypeDescriptor<DoFn.ProcessContext> doFnProcessContextTypeOf(TypeDescriptor<InputT> inputT, TypeDescriptor<OutputT> outputT) {
        return new TypeDescriptor<DoFn.ProcessContext>(){}.where(new TypeParameter<InputT>(){}, inputT).where(new TypeParameter<OutputT>(){}, outputT);
    }

    private static <InputT, OutputT> TypeDescriptor<DoFn.StartBundleContext> doFnStartBundleContextTypeOf(TypeDescriptor<InputT> inputT, TypeDescriptor<OutputT> outputT) {
        return new TypeDescriptor<DoFn.StartBundleContext>(){}.where(new TypeParameter<InputT>(){}, inputT).where(new TypeParameter<OutputT>(){}, outputT);
    }

    private static <InputT, OutputT> TypeDescriptor<DoFn.FinishBundleContext> doFnFinishBundleContextTypeOf(TypeDescriptor<InputT> inputT, TypeDescriptor<OutputT> outputT) {
        return new TypeDescriptor<DoFn.FinishBundleContext>(){}.where(new TypeParameter<InputT>(){}, inputT).where(new TypeParameter<OutputT>(){}, outputT);
    }

    private static <InputT, OutputT> TypeDescriptor<DoFn.OnTimerContext> doFnOnTimerContextTypeOf(TypeDescriptor<InputT> inputT, TypeDescriptor<OutputT> outputT) {
        return new TypeDescriptor<DoFn.OnTimerContext>(){}.where(new TypeParameter<InputT>(){}, inputT).where(new TypeParameter<OutputT>(){}, outputT);
    }

    private static <InputT, OutputT> TypeDescriptor<DoFn.OnWindowExpirationContext> doFnOnWindowExpirationContextTypeOf(TypeDescriptor<InputT> inputT, TypeDescriptor<OutputT> outputT) {
        return new TypeDescriptor<DoFn.OnWindowExpirationContext>(){}.where(new TypeParameter<InputT>(){}, inputT).where(new TypeParameter<OutputT>(){}, outputT);
    }

    @VisibleForTesting
    static DoFnSignature.OnTimerMethod analyzeOnTimerMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnClass, Method m3, String timerId, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, FnAnalysisContext fnContext) {
        errors.checkArgument(Void.TYPE.equals(m3.getReturnType()), "Must return void", new Object[0]);
        Type[] params = m3.getGenericParameterTypes();
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        boolean requiresStableInput = m3.isAnnotationPresent(DoFn.RequiresStableInput.class);
        @Nullable TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnClass, m3);
        ArrayList<DoFnSignature.Parameter> extraParameters = new ArrayList<DoFnSignature.Parameter>();
        ErrorReporter onTimerErrors = errors.forMethod(DoFn.OnTimer.class, m3);
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter parameter = DoFnSignatures.analyzeExtraParameter(onTimerErrors, fnContext, methodContext, fnClass, ParameterDescription.of(m3, i, fnClass.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, outputT);
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_ON_TIMER_PARAMETERS);
            extraParameters.add(parameter);
        }
        return DoFnSignature.OnTimerMethod.create(m3, timerId, requiresStableInput, windowT, extraParameters);
    }

    @VisibleForTesting
    static DoFnSignature.OnTimerFamilyMethod analyzeOnTimerFamilyMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnClass, Method m3, String timerFamilyId, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, FnAnalysisContext fnContext) {
        errors.checkArgument(Void.TYPE.equals(m3.getReturnType()), "Must return void", new Object[0]);
        Type[] params = m3.getGenericParameterTypes();
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        boolean requiresStableInput = m3.isAnnotationPresent(DoFn.RequiresStableInput.class);
        @Nullable TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnClass, m3);
        ArrayList<DoFnSignature.Parameter> extraParameters = new ArrayList<DoFnSignature.Parameter>();
        ErrorReporter onTimerErrors = errors.forMethod(DoFn.OnTimerFamily.class, m3);
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter parameter = DoFnSignatures.analyzeExtraParameter(onTimerErrors, fnContext, methodContext, fnClass, ParameterDescription.of(m3, i, fnClass.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, outputT);
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_ON_TIMER_FAMILY_PARAMETERS);
            extraParameters.add(parameter);
        }
        return DoFnSignature.OnTimerFamilyMethod.create(m3, timerFamilyId, requiresStableInput, windowT, extraParameters);
    }

    @VisibleForTesting
    static DoFnSignature.OnWindowExpirationMethod analyzeOnWindowExpirationMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnClass, Method m3, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, FnAnalysisContext fnContext) {
        errors.checkArgument(Void.TYPE.equals(m3.getReturnType()), "Must return void", new Object[0]);
        Type[] params = m3.getGenericParameterTypes();
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        boolean requiresStableInput = m3.isAnnotationPresent(DoFn.RequiresStableInput.class);
        @Nullable TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnClass, m3);
        ArrayList<DoFnSignature.Parameter> extraParameters = new ArrayList<DoFnSignature.Parameter>();
        ErrorReporter onWindowExpirationErrors = errors.forMethod(DoFn.OnWindowExpiration.class, m3);
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter parameter = DoFnSignatures.analyzeExtraParameter(onWindowExpirationErrors, fnContext, methodContext, fnClass, ParameterDescription.of(m3, i, fnClass.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, outputT);
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_ON_WINDOW_EXPIRATION_PARAMETERS);
            extraParameters.add(parameter);
        }
        return DoFnSignature.OnWindowExpirationMethod.create(m3, requiresStableInput, windowT, extraParameters);
    }

    @VisibleForTesting
    static DoFnSignature.ProcessElementMethod analyzeProcessElementMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnClass, Method m3, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, FnAnalysisContext fnContext) {
        errors.checkArgument(Void.TYPE.equals(m3.getReturnType()) || DoFn.ProcessContinuation.class.equals(m3.getReturnType()), "Must return void or %s", DoFnSignatures.format(DoFn.ProcessContinuation.class));
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        boolean requiresStableInput = m3.isAnnotationPresent(DoFn.RequiresStableInput.class);
        boolean requiresTimeSortedInput = m3.isAnnotationPresent(DoFn.RequiresTimeSortedInput.class);
        TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnClass, m3);
        Type[] params = m3.getGenericParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter extraParam = DoFnSignatures.analyzeExtraParameter(errors.forMethod(DoFn.ProcessElement.class, m3), fnContext, methodContext, fnClass, ParameterDescription.of(m3, i, fnClass.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, outputT);
            methodContext.addParameter(extraParam);
        }
        int schemaElementIndex = 0;
        for (int i = 0; i < methodContext.getExtraParameters().size(); ++i) {
            DoFnSignature.Parameter parameter = methodContext.getExtraParameters().get(i);
            if (!(parameter instanceof DoFnSignature.Parameter.SchemaElementParameter)) continue;
            DoFnSignature.Parameter.SchemaElementParameter schemaParameter = (DoFnSignature.Parameter.SchemaElementParameter)parameter;
            schemaParameter = schemaParameter.toBuilder().setIndex(schemaElementIndex).build();
            methodContext.setParameter(i, schemaParameter);
            ++schemaElementIndex;
        }
        TypeDescriptor trackerT = methodContext.findParameter(DoFnSignature.Parameter.RestrictionTrackerParameter.class).map(p -> p.trackerT()).orElse(null);
        TypeDescriptor watermarkEstimatorT = methodContext.findParameter(DoFnSignature.Parameter.WatermarkEstimatorParameter.class).map(p -> p.estimatorT()).orElse(null);
        if (trackerT != null) {
            for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
                DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_SPLITTABLE_PROCESS_ELEMENT_PARAMETERS);
            }
        } else {
            for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
                DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_NON_SPLITTABLE_PROCESS_ELEMENT_PARAMETERS);
            }
        }
        return DoFnSignature.ProcessElementMethod.create(m3, methodContext.getExtraParameters(), requiresStableInput, requiresTimeSortedInput, trackerT, watermarkEstimatorT, windowT, DoFn.ProcessContinuation.class.equals(m3.getReturnType()));
    }

    private static void checkParameterOneOf(ErrorReporter errors, DoFnSignature.Parameter parameter, Collection<Class<? extends DoFnSignature.Parameter>> allowedParameterClasses) {
        for (Class<? extends DoFnSignature.Parameter> paramClass : allowedParameterClasses) {
            if (!paramClass.isAssignableFrom(parameter.getClass())) continue;
            return;
        }
        errors.throwIllegalArgument("Illegal parameter type: %s", parameter);
    }

    private static DoFnSignature.Parameter analyzeExtraParameter(ErrorReporter methodErrors, FnAnalysisContext fnContext, MethodAnalysisContext methodContext, TypeDescriptor<? extends DoFn<?, ?>> fnClass, ParameterDescription param, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT) {
        TypeDescriptor<DoFn.ProcessContext> expectedProcessContextT = DoFnSignatures.doFnProcessContextTypeOf(inputT, outputT);
        TypeDescriptor<DoFn.StartBundleContext> expectedStartBundleContextT = DoFnSignatures.doFnStartBundleContextTypeOf(inputT, outputT);
        TypeDescriptor<DoFn.FinishBundleContext> expectedFinishBundleContextT = DoFnSignatures.doFnFinishBundleContextTypeOf(inputT, outputT);
        TypeDescriptor<DoFn.OnTimerContext> expectedOnTimerContextT = DoFnSignatures.doFnOnTimerContextTypeOf(inputT, outputT);
        TypeDescriptor<DoFn.OnWindowExpirationContext> expectedOnWindowExpirationContextT = DoFnSignatures.doFnOnWindowExpirationContextTypeOf(inputT, outputT);
        TypeDescriptor<?> paramT = param.getType();
        Class<?> rawType = paramT.getRawType();
        ErrorReporter paramErrors = methodErrors.forParameter(param);
        String fieldAccessString = DoFnSignatures.getFieldAccessId(param.getAnnotations());
        if (fieldAccessString != null) {
            return DoFnSignature.Parameter.schemaElementParameter(paramT, fieldAccessString, param.getIndex());
        }
        if (DoFnSignatures.hasAnnotation(DoFn.Element.class, param.getAnnotations())) {
            return paramT.equals(inputT) ? DoFnSignature.Parameter.elementParameter(paramT) : DoFnSignature.Parameter.schemaElementParameter(paramT, null, param.getIndex());
        }
        if (DoFnSignatures.hasAnnotation(DoFn.Restriction.class, param.getAnnotations())) {
            return DoFnSignature.Parameter.restrictionParameter(paramT);
        }
        if (DoFnSignatures.hasAnnotation(DoFn.WatermarkEstimatorState.class, param.getAnnotations())) {
            return DoFnSignature.Parameter.watermarkEstimatorState(paramT);
        }
        if (DoFnSignatures.hasAnnotation(DoFn.Timestamp.class, param.getAnnotations())) {
            methodErrors.checkArgument(rawType.equals(Instant.class), "@Timestamp argument must have type org.joda.time.Instant.", new Object[0]);
            return DoFnSignature.Parameter.timestampParameter();
        }
        if (DoFnSignatures.hasAnnotation(DoFn.Key.class, param.getAnnotations())) {
            methodErrors.checkArgument(KV.class.equals(inputT.getRawType()), "@Key argument is expected to be use with input element of type KV.", new Object[0]);
            Type keyType = ((ParameterizedType)inputT.getType()).getActualTypeArguments()[0];
            methodErrors.checkArgument(TypeDescriptor.of(keyType).equals(paramT), "@Key argument is expected to be type of %s, but found %s.", keyType, rawType);
            return DoFnSignature.Parameter.keyT(paramT);
        }
        if (rawType.equals(TimeDomain.class)) {
            return DoFnSignature.Parameter.timeDomainParameter();
        }
        if (DoFnSignatures.hasAnnotation(DoFn.SideInput.class, param.getAnnotations())) {
            String sideInputId = DoFnSignatures.getSideInputId(param.getAnnotations());
            paramErrors.checkArgument(sideInputId != null, "%s missing %s annotation", DoFnSignatures.format(DoFn.SideInput.class));
            return DoFnSignature.Parameter.sideInputParameter(paramT, sideInputId);
        }
        if (rawType.equals(PaneInfo.class)) {
            return DoFnSignature.Parameter.paneInfoParameter();
        }
        if (rawType.equals(DoFn.BundleFinalizer.class)) {
            return DoFnSignature.Parameter.bundleFinalizer();
        }
        if (rawType.equals(DoFn.ProcessContext.class)) {
            paramErrors.checkArgument(paramT.equals(expectedProcessContextT), "ProcessContext argument must have type %s", DoFnSignatures.format(expectedProcessContextT));
            return DoFnSignature.Parameter.processContext();
        }
        if (rawType.equals(DoFn.StartBundleContext.class)) {
            paramErrors.checkArgument(paramT.equals(expectedStartBundleContextT), "StartBundleContext argument must have type %s", DoFnSignatures.format(expectedProcessContextT));
            return DoFnSignature.Parameter.startBundleContext();
        }
        if (rawType.equals(DoFn.FinishBundleContext.class)) {
            paramErrors.checkArgument(paramT.equals(expectedFinishBundleContextT), "FinishBundleContext argument must have type %s", DoFnSignatures.format(expectedProcessContextT));
            return DoFnSignature.Parameter.finishBundleContext();
        }
        if (rawType.equals(DoFn.OnTimerContext.class)) {
            paramErrors.checkArgument(paramT.equals(expectedOnTimerContextT), "OnTimerContext argument must have type %s", DoFnSignatures.format(expectedOnTimerContextT));
            return DoFnSignature.Parameter.onTimerContext();
        }
        if (rawType.equals(DoFn.OnWindowExpirationContext.class)) {
            paramErrors.checkArgument(paramT.equals(expectedOnWindowExpirationContextT), "OnWindowExpirationContext argument must have type %s", DoFnSignatures.format(expectedOnWindowExpirationContextT));
            return DoFnSignature.Parameter.onWindowExpirationContext();
        }
        if (BoundedWindow.class.isAssignableFrom(rawType)) {
            methodErrors.checkArgument(!methodContext.hasParameter(DoFnSignature.Parameter.WindowParameter.class), "Multiple %s parameters", DoFnSignatures.format(BoundedWindow.class));
            return DoFnSignature.Parameter.boundedWindow(paramT);
        }
        if (rawType.equals(DoFn.OutputReceiver.class)) {
            boolean schemaRowReceiver;
            boolean bl = schemaRowReceiver = paramT.equals(DoFnSignatures.outputReceiverTypeOf(TypeDescriptor.of(Row.class))) && !outputT.equals(TypeDescriptor.of(Row.class));
            if (!schemaRowReceiver) {
                TypeDescriptor<DoFn.OutputReceiver<?>> expectedReceiverT = DoFnSignatures.outputReceiverTypeOf(outputT);
                paramErrors.checkArgument(paramT.equals(expectedReceiverT), "OutputReceiver should be parameterized by %s", outputT);
            }
            return DoFnSignature.Parameter.outputReceiverParameter(schemaRowReceiver);
        }
        if (rawType.equals(DoFn.MultiOutputReceiver.class)) {
            return DoFnSignature.Parameter.taggedOutputReceiverParameter();
        }
        if (PipelineOptions.class.equals(rawType)) {
            methodErrors.checkArgument(!methodContext.hasParameter(DoFnSignature.Parameter.PipelineOptionsParameter.class), "Multiple %s parameters", DoFnSignatures.format(PipelineOptions.class));
            return DoFnSignature.Parameter.pipelineOptions();
        }
        if (RestrictionTracker.class.isAssignableFrom(rawType)) {
            methodErrors.checkArgument(!methodContext.hasParameter(DoFnSignature.Parameter.RestrictionTrackerParameter.class), "Multiple %s parameters", DoFnSignatures.format(RestrictionTracker.class));
            return DoFnSignature.Parameter.restrictionTracker(paramT);
        }
        if (WatermarkEstimator.class.isAssignableFrom(rawType)) {
            methodErrors.checkArgument(!methodContext.hasParameter(DoFnSignature.Parameter.WatermarkEstimatorParameter.class), "Multiple %s parameters", DoFnSignatures.format(WatermarkEstimator.class));
            return DoFnSignature.Parameter.watermarkEstimator(paramT);
        }
        if (rawType.equals(Timer.class)) {
            String id = DoFnSignatures.getTimerId(param.getAnnotations());
            paramErrors.checkArgument(id != null, "%s missing %s annotation", DoFnSignatures.format(Timer.class), DoFnSignatures.format(DoFn.TimerId.class));
            paramErrors.checkArgument(!methodContext.getTimerParameters().containsKey(id), "duplicate %s: \"%s\"", DoFnSignatures.format(DoFn.TimerId.class), id);
            DoFnSignature.TimerDeclaration timerDecl = fnContext.getTimerDeclarations().get(id);
            paramErrors.checkArgument(timerDecl != null, "reference to undeclared %s: \"%s\"", DoFnSignatures.format(DoFn.TimerId.class), id);
            paramErrors.checkArgument(timerDecl.field().getDeclaringClass().equals(DoFnSignatures.getDeclaringClass(param.getMethod())), "%s %s declared in a different class %s. Timers may be referenced only in the lexical scope where they are declared.", DoFnSignatures.format(DoFn.TimerId.class), id, timerDecl.field().getDeclaringClass().getName());
            return DoFnSignature.Parameter.timerParameter(timerDecl);
        }
        if (DoFnSignatures.hasAnnotation(DoFn.TimerId.class, param.getAnnotations())) {
            boolean isValidTimerIdForTimerFamily = fnContext.getTimerFamilyDeclarations().size() > 0 && rawType.equals(String.class);
            paramErrors.checkArgument(isValidTimerIdForTimerFamily, "%s not allowed here", DoFnSignatures.format(DoFn.TimerId.class));
            return DoFnSignature.Parameter.timerIdParameter();
        }
        if (rawType.equals(TimerMap.class)) {
            String id = DoFnSignatures.getTimerFamilyId(param.getAnnotations());
            paramErrors.checkArgument(id != null, "%s missing %s annotation", DoFnSignatures.format(TimerMap.class), DoFnSignatures.format(DoFn.TimerFamily.class));
            paramErrors.checkArgument(!methodContext.getTimerFamilyParameters().containsKey(id), "duplicate %s: \"%s\"", DoFnSignatures.format(DoFn.TimerFamily.class), id);
            DoFnSignature.TimerFamilyDeclaration timerDecl = fnContext.getTimerFamilyDeclarations().get(id);
            paramErrors.checkArgument(timerDecl != null, "reference to undeclared %s: \"%s\"", DoFnSignatures.format(DoFn.TimerFamily.class), id);
            paramErrors.checkArgument(timerDecl.field().getDeclaringClass().equals(DoFnSignatures.getDeclaringClass(param.getMethod())), "%s %s declared in a different class %s. Timers may be referenced only in the lexical scope where they are declared.", DoFnSignatures.format(DoFn.TimerFamily.class), id, timerDecl.field().getDeclaringClass().getName());
            return DoFnSignature.Parameter.timerFamilyParameter(timerDecl);
        }
        if (State.class.isAssignableFrom(rawType)) {
            String id = DoFnSignatures.getStateId(param.getAnnotations());
            paramErrors.checkArgument(id != null, "missing %s annotation", DoFnSignatures.format(DoFn.StateId.class));
            paramErrors.checkArgument(!methodContext.getStateParameters().containsKey(id), "duplicate %s: \"%s\"", DoFnSignatures.format(DoFn.StateId.class), id);
            TypeDescriptor<?> stateType = param.getType();
            DoFnSignature.StateDeclaration stateDecl = fnContext.getStateDeclarations().get(id);
            paramErrors.checkArgument(stateDecl != null, "reference to undeclared %s: \"%s\"", DoFnSignatures.format(DoFn.StateId.class), id);
            paramErrors.checkArgument(stateDecl.stateType().isSubtypeOf(stateType), "data type of reference to %s %s must be a supertype of %s", DoFnSignatures.format(DoFn.StateId.class), id, DoFnSignatures.format(stateDecl.stateType()));
            paramErrors.checkArgument(stateDecl.field().getDeclaringClass().equals(DoFnSignatures.getDeclaringClass(param.getMethod())), "%s %s declared in a different class %s. State may be referenced only in the class where it is declared.", DoFnSignatures.format(DoFn.StateId.class), id, stateDecl.field().getDeclaringClass().getName());
            boolean alwaysFetched = DoFnSignatures.getStateAlwaysFetched(param.getAnnotations());
            if (alwaysFetched) {
                paramErrors.checkArgument(ReadableState.class.isAssignableFrom(rawType), "@AlwaysFetched can only be used on ReadableStates. It cannot be used on %s", DoFnSignatures.format(stateDecl.stateType()));
            }
            return DoFnSignature.Parameter.stateParameter(stateDecl, alwaysFetched);
        }
        paramErrors.throwIllegalArgument("%s is not a valid context parameter.", DoFnSignatures.format(paramT));
        return null;
    }

    private static @Nullable String getTimerId(List<Annotation> annotations) {
        DoFn.TimerId timerId = DoFnSignatures.findFirstOfType(annotations, DoFn.TimerId.class);
        return timerId != null ? "ts-" + timerId.value() : null;
    }

    private static @Nullable String getTimerFamilyId(List<Annotation> annotations) {
        DoFn.TimerFamily timerFamilyId = DoFnSignatures.findFirstOfType(annotations, DoFn.TimerFamily.class);
        return timerFamilyId != null ? "tfs-" + timerFamilyId.value() : null;
    }

    private static @Nullable String getStateId(List<Annotation> annotations) {
        DoFn.StateId stateId = DoFnSignatures.findFirstOfType(annotations, DoFn.StateId.class);
        return stateId != null ? stateId.value() : null;
    }

    private static boolean getStateAlwaysFetched(List<Annotation> annotations) {
        DoFn.AlwaysFetched alwaysFetched = DoFnSignatures.findFirstOfType(annotations, DoFn.AlwaysFetched.class);
        return alwaysFetched != null;
    }

    private static @Nullable String getFieldAccessId(List<Annotation> annotations) {
        DoFn.FieldAccess access = DoFnSignatures.findFirstOfType(annotations, DoFn.FieldAccess.class);
        return access != null ? access.value() : null;
    }

    private static @Nullable String getSideInputId(List<Annotation> annotations) {
        DoFn.SideInput sideInputId = DoFnSignatures.findFirstOfType(annotations, DoFn.SideInput.class);
        return sideInputId != null ? sideInputId.value() : null;
    }

    static <T> @Nullable T findFirstOfType(List<Annotation> annotations, Class<T> clazz) {
        Optional<Annotation> annotation = annotations.stream().filter(a -> a.annotationType().equals(clazz)).findFirst();
        return (T)(annotation.isPresent() ? annotation.get() : null);
    }

    private static boolean hasAnnotation(Class<?> annotation, List<Annotation> annotations) {
        return annotations.stream().anyMatch(a -> a.annotationType().equals(annotation));
    }

    private static @Nullable TypeDescriptor<? extends BoundedWindow> getWindowType(TypeDescriptor<?> fnClass, Method method) {
        Type[] params;
        for (Type param : params = method.getGenericParameterTypes()) {
            TypeDescriptor<?> paramT = fnClass.resolveType(param);
            if (!BoundedWindow.class.isAssignableFrom(paramT.getRawType())) continue;
            return paramT;
        }
        return null;
    }

    @VisibleForTesting
    static DoFnSignature.BundleMethod analyzeStartBundleMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnT, Method m3, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, FnAnalysisContext fnContext) {
        errors.checkArgument(Void.TYPE.equals(m3.getReturnType()), "Must return void", new Object[0]);
        Type[] params = m3.getGenericParameterTypes();
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter extraParam = DoFnSignatures.analyzeExtraParameter(errors, fnContext, methodContext, fnT, ParameterDescription.of(m3, i, fnT.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, outputT);
            methodContext.addParameter(extraParam);
        }
        for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_START_BUNDLE_PARAMETERS);
        }
        return DoFnSignature.BundleMethod.create(m3, methodContext.extraParameters);
    }

    @VisibleForTesting
    static DoFnSignature.BundleMethod analyzeFinishBundleMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnT, Method m3, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, FnAnalysisContext fnContext) {
        errors.checkArgument(Void.TYPE.equals(m3.getReturnType()), "Must return void", new Object[0]);
        Type[] params = m3.getGenericParameterTypes();
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter extraParam = DoFnSignatures.analyzeExtraParameter(errors, fnContext, methodContext, fnT, ParameterDescription.of(m3, i, fnT.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, outputT);
            methodContext.addParameter(extraParam);
        }
        for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_FINISH_BUNDLE_PARAMETERS);
        }
        return DoFnSignature.BundleMethod.create(m3, methodContext.extraParameters);
    }

    @VisibleForTesting
    static DoFnSignature.LifecycleMethod analyzeSetupMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnT, Method m3, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, FnAnalysisContext fnContext) {
        errors.checkArgument(Void.TYPE.equals(m3.getReturnType()), "Must return void", new Object[0]);
        Type[] params = m3.getGenericParameterTypes();
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter extraParam = DoFnSignatures.analyzeExtraParameter(errors, fnContext, methodContext, fnT, ParameterDescription.of(m3, i, fnT.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, outputT);
            methodContext.addParameter(extraParam);
        }
        for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_SETUP_PARAMETERS);
        }
        return DoFnSignature.LifecycleMethod.create(m3, methodContext.extraParameters);
    }

    private static DoFnSignature.LifecycleMethod analyzeShutdownMethod(ErrorReporter errors, Method m3) {
        errors.checkArgument(Void.TYPE.equals(m3.getReturnType()), "Must return void", new Object[0]);
        errors.checkArgument(m3.getGenericParameterTypes().length == 0, "Must take zero arguments", new Object[0]);
        return DoFnSignature.LifecycleMethod.create(m3, Collections.emptyList());
    }

    @VisibleForTesting
    static DoFnSignature.GetInitialRestrictionMethod analyzeGetInitialRestrictionMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnT, Method m3, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, FnAnalysisContext fnContext) {
        Type[] params = m3.getGenericParameterTypes();
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnT, m3);
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter extraParam = DoFnSignatures.analyzeExtraParameter(errors, fnContext, methodContext, fnT, ParameterDescription.of(m3, i, fnT.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, outputT);
            if (extraParam instanceof DoFnSignature.Parameter.SchemaElementParameter) {
                errors.throwIllegalArgument("Schema @%s are not supported for @%s method. Found %s, did you mean to use %s?", DoFnSignatures.format(DoFn.Element.class), DoFnSignatures.format(DoFn.GetInitialRestriction.class), DoFnSignatures.format(((DoFnSignature.Parameter.SchemaElementParameter)extraParam).elementT()), DoFnSignatures.format(inputT));
            }
            methodContext.addParameter(extraParam);
        }
        for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_GET_INITIAL_RESTRICTION_PARAMETERS);
        }
        return DoFnSignature.GetInitialRestrictionMethod.create(m3, fnT.resolveType(m3.getGenericReturnType()), windowT, methodContext.extraParameters);
    }

    @VisibleForTesting
    static DoFnSignature.GetInitialWatermarkEstimatorStateMethod analyzeGetInitialWatermarkEstimatorStateMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnT, Method m3, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, FnAnalysisContext fnContext) {
        Type[] params = m3.getGenericParameterTypes();
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnT, m3);
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter extraParam = DoFnSignatures.analyzeExtraParameter(errors, fnContext, methodContext, fnT, ParameterDescription.of(m3, i, fnT.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, outputT);
            if (extraParam instanceof DoFnSignature.Parameter.SchemaElementParameter) {
                errors.throwIllegalArgument("Schema @%s are not supported for @%s method. Found %s, did you mean to use %s?", DoFnSignatures.format(DoFn.Element.class), DoFnSignatures.format(DoFn.GetInitialWatermarkEstimatorState.class), DoFnSignatures.format(((DoFnSignature.Parameter.SchemaElementParameter)extraParam).elementT()), DoFnSignatures.format(inputT));
            }
            methodContext.addParameter(extraParam);
        }
        for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_GET_INITIAL_WATERMARK_ESTIMATOR_STATE_PARAMETERS);
        }
        return DoFnSignature.GetInitialWatermarkEstimatorStateMethod.create(m3, fnT.resolveType(m3.getGenericReturnType()), windowT, methodContext.extraParameters);
    }

    private static <OutputT> TypeDescriptor<DoFn.OutputReceiver<OutputT>> outputReceiverTypeOf(TypeDescriptor<OutputT> outputT) {
        return new TypeDescriptor<DoFn.OutputReceiver<OutputT>>(){}.where(new TypeParameter<OutputT>(){}, outputT);
    }

    @VisibleForTesting
    static DoFnSignature.SplitRestrictionMethod analyzeSplitRestrictionMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnT, Method m3, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, TypeDescriptor<?> restrictionT, FnAnalysisContext fnContext) {
        errors.checkArgument(Void.TYPE.equals(m3.getReturnType()), "Must return void", new Object[0]);
        Type[] params = m3.getGenericParameterTypes();
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnT, m3);
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter extraParam = DoFnSignatures.analyzeExtraParameter(errors, fnContext, methodContext, fnT, ParameterDescription.of(m3, i, fnT.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, restrictionT);
            if (extraParam instanceof DoFnSignature.Parameter.SchemaElementParameter) {
                errors.throwIllegalArgument("Schema @%s are not supported for @%s method. Found %s, did you mean to use %s?", DoFnSignatures.format(DoFn.Element.class), DoFnSignatures.format(DoFn.SplitRestriction.class), DoFnSignatures.format(((DoFnSignature.Parameter.SchemaElementParameter)extraParam).elementT()), DoFnSignatures.format(inputT));
            } else if (extraParam instanceof DoFnSignature.Parameter.RestrictionParameter) {
                errors.checkArgument(restrictionT.equals(((DoFnSignature.Parameter.RestrictionParameter)extraParam).restrictionT()), "Uses restriction type %s, but @%s method uses restriction type %s", DoFnSignatures.format(((DoFnSignature.Parameter.RestrictionParameter)extraParam).restrictionT()), DoFnSignatures.format(DoFn.GetInitialRestriction.class), DoFnSignatures.format(restrictionT));
            }
            methodContext.addParameter(extraParam);
        }
        for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_SPLIT_RESTRICTION_PARAMETERS);
        }
        return DoFnSignature.SplitRestrictionMethod.create(m3, windowT, methodContext.getExtraParameters());
    }

    @VisibleForTesting
    static DoFnSignature.TruncateRestrictionMethod analyzeTruncateRestrictionMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnT, Method m3, TypeDescriptor<?> inputT, TypeDescriptor<?> restrictionT, FnAnalysisContext fnContext) {
        errors.checkArgument(RestrictionTracker.TruncateResult.class.equals(m3.getReturnType()), "Must return TruncateResult<Restriction>", new Object[0]);
        Type[] params = m3.getGenericParameterTypes();
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnT, m3);
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter extraParam = DoFnSignatures.analyzeExtraParameter(errors, fnContext, methodContext, fnT, ParameterDescription.of(m3, i, fnT.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, restrictionT);
            if (extraParam instanceof DoFnSignature.Parameter.SchemaElementParameter) {
                errors.throwIllegalArgument("Schema @%s are not supported for @%s method. Found %s, did you mean to use %s?", DoFnSignatures.format(DoFn.Element.class), DoFnSignatures.format(DoFn.TruncateRestriction.class), DoFnSignatures.format(((DoFnSignature.Parameter.SchemaElementParameter)extraParam).elementT()), DoFnSignatures.format(inputT));
            } else if (extraParam instanceof DoFnSignature.Parameter.RestrictionParameter) {
                errors.checkArgument(restrictionT.equals(((DoFnSignature.Parameter.RestrictionParameter)extraParam).restrictionT()), "Uses restriction type %s, but @%s method uses restriction type %s", DoFnSignatures.format(((DoFnSignature.Parameter.RestrictionParameter)extraParam).restrictionT()), DoFnSignatures.format(DoFn.GetInitialRestriction.class), DoFnSignatures.format(restrictionT));
            }
            methodContext.addParameter(extraParam);
        }
        for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_TRUNCATE_RESTRICTION_PARAMETERS);
        }
        return DoFnSignature.TruncateRestrictionMethod.create(m3, windowT, methodContext.getExtraParameters());
    }

    private static ImmutableMap<String, DoFnSignature.TimerFamilyDeclaration> analyzeTimerFamilyDeclarations(ErrorReporter errors, Class<?> fnClazz) {
        HashMap<String, DoFnSignature.TimerFamilyDeclaration> declarations = new HashMap<String, DoFnSignature.TimerFamilyDeclaration>();
        for (Field field : ReflectHelpers.declaredFieldsWithAnnotation(DoFn.TimerFamily.class, fnClazz, DoFn.class)) {
            field.setAccessible(true);
            String id = "tfs-" + field.getAnnotation(DoFn.TimerFamily.class).value();
            DoFnSignatures.validateTimerFamilyField(errors, declarations, id, field);
            declarations.put(id, DoFnSignature.TimerFamilyDeclaration.create(id, field));
        }
        return ImmutableMap.copyOf(declarations);
    }

    private static ImmutableMap<String, DoFnSignature.TimerDeclaration> analyzeTimerDeclarations(ErrorReporter errors, Class<?> fnClazz) {
        HashMap<String, DoFnSignature.TimerDeclaration> declarations = new HashMap<String, DoFnSignature.TimerDeclaration>();
        for (Field field : ReflectHelpers.declaredFieldsWithAnnotation(DoFn.TimerId.class, fnClazz, DoFn.class)) {
            field.setAccessible(true);
            String id = "ts-" + field.getAnnotation(DoFn.TimerId.class).value();
            DoFnSignatures.validateTimerField(errors, declarations, id, field);
            declarations.put(id, DoFnSignature.TimerDeclaration.create(id, field));
        }
        return ImmutableMap.copyOf(declarations);
    }

    private static void validateTimerField(ErrorReporter errors, Map<String, DoFnSignature.TimerDeclaration> declarations, String id, Field field) {
        Class<?> timerSpecRawType;
        if (declarations.containsKey(id)) {
            errors.throwIllegalArgument("Duplicate %s \"%s\", used on both of [%s] and [%s]", DoFnSignatures.format(DoFn.TimerId.class), id, field.toString(), declarations.get(id).field().toString());
        }
        if (!(timerSpecRawType = field.getType()).equals(TimerSpec.class)) {
            errors.throwIllegalArgument("%s annotation on non-%s field [%s]", DoFnSignatures.format(DoFn.TimerId.class), DoFnSignatures.format(TimerSpec.class), field.toString());
        }
        if (!Modifier.isFinal(field.getModifiers())) {
            errors.throwIllegalArgument("Non-final field %s annotated with %s. Timer declarations must be final.", field.toString(), DoFnSignatures.format(DoFn.TimerId.class));
        }
    }

    private static void validateTimerFamilyField(ErrorReporter errors, Map<String, DoFnSignature.TimerFamilyDeclaration> declarations, String id, Field field) {
        Class<?> timerSpecRawType;
        if (id.isEmpty()) {
            errors.throwIllegalArgument("TimerFamily id must not be empty", new Object[0]);
        }
        if (declarations.containsKey(id)) {
            errors.throwIllegalArgument("Duplicate %s \"%s\", used on both of [%s] and [%s]", DoFnSignatures.format(DoFn.TimerFamily.class), id, field.toString(), declarations.get(id).field().toString());
        }
        if (!(timerSpecRawType = field.getType()).equals(TimerSpec.class)) {
            errors.throwIllegalArgument("%s annotation on non-%s field [%s]", DoFnSignatures.format(DoFn.TimerFamily.class), DoFnSignatures.format(TimerSpec.class), field.toString());
        }
        if (!Modifier.isFinal(field.getModifiers())) {
            errors.throwIllegalArgument("Non-final field %s annotated with %s. TimerMap declarations must be final.", field.toString(), DoFnSignatures.format(DoFn.TimerFamily.class));
        }
    }

    private static <T> TypeDescriptor<Coder<T>> coderTypeOf(TypeDescriptor<T> elementT) {
        return new TypeDescriptor<Coder<T>>(){}.where(new TypeParameter<T>(){}, elementT);
    }

    @VisibleForTesting
    static DoFnSignature.GetRestrictionCoderMethod analyzeGetRestrictionCoderMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn> fnT, Method m3) {
        errors.checkArgument(m3.getParameterTypes().length == 0, "Must have zero arguments", new Object[0]);
        TypeDescriptor<Coder> resT = fnT.resolveType(m3.getGenericReturnType());
        errors.checkArgument(resT.isSubtypeOf(TypeDescriptor.of(Coder.class)), "Must return a Coder, but returns %s", DoFnSignatures.format(resT));
        return DoFnSignature.GetRestrictionCoderMethod.create(m3, resT);
    }

    @VisibleForTesting
    static DoFnSignature.GetWatermarkEstimatorStateCoderMethod analyzeGetWatermarkEstimatorStateCoderMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn> fnT, Method m3) {
        errors.checkArgument(m3.getParameterTypes().length == 0, "Must have zero arguments", new Object[0]);
        TypeDescriptor<Coder> resT = fnT.resolveType(m3.getGenericReturnType());
        errors.checkArgument(resT.isSubtypeOf(TypeDescriptor.of(Coder.class)), "Must return a Coder, but returns %s", DoFnSignatures.format(resT));
        return DoFnSignature.GetWatermarkEstimatorStateCoderMethod.create(m3, resT);
    }

    private static <RestrictionT> TypeDescriptor<RestrictionTracker<RestrictionT, ?>> restrictionTrackerTypeOf(TypeDescriptor<RestrictionT> restrictionT) {
        return new TypeDescriptor<RestrictionTracker<RestrictionT, ?>>(){}.where(new TypeParameter<RestrictionT>(){}, restrictionT);
    }

    private static <WatermarkEstimatorStateT> TypeDescriptor<WatermarkEstimator<WatermarkEstimatorStateT>> watermarkEstimatorTypeOf(TypeDescriptor<WatermarkEstimatorStateT> watermarkEstimatorStateT) {
        return new TypeDescriptor<WatermarkEstimator<WatermarkEstimatorStateT>>(){}.where(new TypeParameter<WatermarkEstimatorStateT>(){}, watermarkEstimatorStateT);
    }

    @VisibleForTesting
    static DoFnSignature.NewTrackerMethod analyzeNewTrackerMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnT, Method m3, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, TypeDescriptor<?> restrictionT, FnAnalysisContext fnContext) {
        Type[] params = m3.getGenericParameterTypes();
        TypeDescriptor<RestrictionTracker<?, ?>> trackerT = fnT.resolveType(m3.getGenericReturnType());
        TypeDescriptor<RestrictionTracker<?, ?>> expectedTrackerT = DoFnSignatures.restrictionTrackerTypeOf(restrictionT);
        errors.checkArgument(trackerT.isSubtypeOf(expectedTrackerT), "Returns %s, but must return a subtype of %s", DoFnSignatures.format(trackerT), DoFnSignatures.format(expectedTrackerT));
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnT, m3);
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter extraParam = DoFnSignatures.analyzeExtraParameter(errors, fnContext, methodContext, fnT, ParameterDescription.of(m3, i, fnT.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, outputT);
            if (extraParam instanceof DoFnSignature.Parameter.SchemaElementParameter) {
                errors.throwIllegalArgument("Schema @%s are not supported for @%s method. Found %s, did you mean to use %s?", DoFnSignatures.format(DoFn.Element.class), DoFnSignatures.format(DoFn.NewTracker.class), DoFnSignatures.format(((DoFnSignature.Parameter.SchemaElementParameter)extraParam).elementT()), DoFnSignatures.format(inputT));
            } else if (extraParam instanceof DoFnSignature.Parameter.RestrictionParameter) {
                errors.checkArgument(restrictionT.equals(((DoFnSignature.Parameter.RestrictionParameter)extraParam).restrictionT()), "Uses restriction type %s, but @%s method uses restriction type %s", DoFnSignatures.format(((DoFnSignature.Parameter.RestrictionParameter)extraParam).restrictionT()), DoFnSignatures.format(DoFn.GetInitialRestriction.class), DoFnSignatures.format(restrictionT));
            }
            methodContext.addParameter(extraParam);
        }
        for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_NEW_TRACKER_PARAMETERS);
        }
        return DoFnSignature.NewTrackerMethod.create(m3, fnT.resolveType(m3.getGenericReturnType()), windowT, methodContext.getExtraParameters());
    }

    @VisibleForTesting
    static DoFnSignature.NewWatermarkEstimatorMethod analyzeNewWatermarkEstimatorMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnT, Method m3, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, TypeDescriptor<?> restrictionT, TypeDescriptor<?> watermarkEstimatorStateT, FnAnalysisContext fnContext) {
        Type[] params = m3.getGenericParameterTypes();
        TypeDescriptor<WatermarkEstimator<?>> watermarkEstimatorT = fnT.resolveType(m3.getGenericReturnType());
        TypeDescriptor<WatermarkEstimator<?>> expectedWatermarkEstimatorT = DoFnSignatures.watermarkEstimatorTypeOf(watermarkEstimatorStateT);
        errors.checkArgument(watermarkEstimatorT.isSubtypeOf(expectedWatermarkEstimatorT), "Returns %s, but must return a subtype of %s", DoFnSignatures.format(watermarkEstimatorT), DoFnSignatures.format(expectedWatermarkEstimatorT));
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnT, m3);
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter extraParam = DoFnSignatures.analyzeExtraParameter(errors, fnContext, methodContext, fnT, ParameterDescription.of(m3, i, fnT.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, outputT);
            if (extraParam instanceof DoFnSignature.Parameter.SchemaElementParameter) {
                errors.throwIllegalArgument("Schema @%s are not supported for @%s method. Found %s, did you mean to use %s?", DoFnSignatures.format(DoFn.Element.class), DoFnSignatures.format(DoFn.NewWatermarkEstimator.class), DoFnSignatures.format(((DoFnSignature.Parameter.SchemaElementParameter)extraParam).elementT()), DoFnSignatures.format(inputT));
            } else if (extraParam instanceof DoFnSignature.Parameter.RestrictionParameter) {
                errors.checkArgument(restrictionT.equals(((DoFnSignature.Parameter.RestrictionParameter)extraParam).restrictionT()), "Uses restriction type %s, but @%s method uses restriction type %s", DoFnSignatures.format(((DoFnSignature.Parameter.RestrictionParameter)extraParam).restrictionT()), DoFnSignatures.format(DoFn.GetInitialWatermarkEstimatorState.class), DoFnSignatures.format(restrictionT));
            } else if (extraParam instanceof DoFnSignature.Parameter.WatermarkEstimatorStateParameter) {
                errors.checkArgument(watermarkEstimatorStateT.equals(((DoFnSignature.Parameter.WatermarkEstimatorStateParameter)extraParam).estimatorStateT()), "Uses watermark estimator state type %s, but @%s method uses watermark estimator state type %s", DoFnSignatures.format(((DoFnSignature.Parameter.WatermarkEstimatorStateParameter)extraParam).estimatorStateT()), DoFnSignatures.format(DoFn.GetInitialWatermarkEstimatorState.class), DoFnSignatures.format(watermarkEstimatorStateT));
            }
            methodContext.addParameter(extraParam);
        }
        for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_NEW_WATERMARK_ESTIMATOR_PARAMETERS);
        }
        return DoFnSignature.NewWatermarkEstimatorMethod.create(m3, fnT.resolveType(m3.getGenericReturnType()), windowT, methodContext.getExtraParameters());
    }

    @VisibleForTesting
    static DoFnSignature.GetSizeMethod analyzeGetSizeMethod(ErrorReporter errors, TypeDescriptor<? extends DoFn<?, ?>> fnT, Method m3, TypeDescriptor<?> inputT, TypeDescriptor<?> outputT, TypeDescriptor<?> restrictionT, FnAnalysisContext fnContext) {
        Type[] params = m3.getGenericParameterTypes();
        errors.checkArgument(m3.getGenericReturnType().equals(Double.TYPE), "Returns %s, but must return a double", DoFnSignatures.format(TypeDescriptor.of(m3.getGenericReturnType())));
        MethodAnalysisContext methodContext = MethodAnalysisContext.create();
        TypeDescriptor<? extends BoundedWindow> windowT = DoFnSignatures.getWindowType(fnT, m3);
        for (int i = 0; i < params.length; ++i) {
            DoFnSignature.Parameter extraParam = DoFnSignatures.analyzeExtraParameter(errors, fnContext, methodContext, fnT, ParameterDescription.of(m3, i, fnT.resolveType(params[i]), Arrays.asList(m3.getParameterAnnotations()[i])), inputT, outputT);
            if (extraParam instanceof DoFnSignature.Parameter.SchemaElementParameter) {
                errors.throwIllegalArgument("Schema @%s are not supported for @%s method. Found %s, did you mean to use %s?", DoFnSignatures.format(DoFn.Element.class), DoFnSignatures.format(DoFn.GetSize.class), DoFnSignatures.format(((DoFnSignature.Parameter.SchemaElementParameter)extraParam).elementT()), DoFnSignatures.format(inputT));
            } else if (extraParam instanceof DoFnSignature.Parameter.RestrictionParameter) {
                errors.checkArgument(restrictionT.equals(((DoFnSignature.Parameter.RestrictionParameter)extraParam).restrictionT()), "Uses restriction type %s, but @%s method uses restriction type %s", DoFnSignatures.format(((DoFnSignature.Parameter.RestrictionParameter)extraParam).restrictionT()), DoFnSignatures.format(DoFn.GetInitialRestriction.class), DoFnSignatures.format(restrictionT));
            }
            methodContext.addParameter(extraParam);
        }
        for (DoFnSignature.Parameter parameter : methodContext.getExtraParameters()) {
            DoFnSignatures.checkParameterOneOf(errors, parameter, ALLOWED_GET_SIZE_PARAMETERS);
        }
        return DoFnSignature.GetSizeMethod.create(m3, windowT, methodContext.getExtraParameters());
    }

    private static Map<String, DoFnSignature.FieldAccessDeclaration> analyzeFieldAccessDeclaration(ErrorReporter errors, Class<?> fnClazz) {
        HashMap<String, DoFnSignature.FieldAccessDeclaration> fieldAccessDeclarations = new HashMap<String, DoFnSignature.FieldAccessDeclaration>();
        for (Field field : ReflectHelpers.declaredFieldsWithAnnotation(DoFn.FieldAccess.class, fnClazz, DoFn.class)) {
            field.setAccessible(true);
            DoFn.FieldAccess fieldAccessAnnotation = field.getAnnotation(DoFn.FieldAccess.class);
            if (!Modifier.isFinal(field.getModifiers())) {
                errors.throwIllegalArgument("Non-final field %s annotated with %s. Field access declarations must be final.", field.toString(), DoFnSignatures.format(DoFn.FieldAccess.class));
                continue;
            }
            Class<?> fieldAccessRawType = field.getType();
            if (!fieldAccessRawType.equals(FieldAccessDescriptor.class)) {
                errors.throwIllegalArgument("Field %s annotated with %s, but the value was not of type %s", field.toString(), DoFnSignatures.format(DoFn.FieldAccess.class), DoFnSignatures.format(FieldAccessDescriptor.class));
            }
            fieldAccessDeclarations.put(fieldAccessAnnotation.value(), DoFnSignature.FieldAccessDeclaration.create(fieldAccessAnnotation.value(), field));
        }
        return fieldAccessDeclarations;
    }

    private static Map<String, DoFnSignature.StateDeclaration> analyzeStateDeclarations(ErrorReporter errors, Class<?> fnClazz) {
        HashMap<String, DoFnSignature.StateDeclaration> declarations = new HashMap<String, DoFnSignature.StateDeclaration>();
        for (Field field : ReflectHelpers.declaredFieldsWithAnnotation(DoFn.StateId.class, fnClazz, DoFn.class)) {
            field.setAccessible(true);
            String id = field.getAnnotation(DoFn.StateId.class).value();
            if (declarations.containsKey(id)) {
                errors.throwIllegalArgument("Duplicate %s \"%s\", used on both of [%s] and [%s]", DoFnSignatures.format(DoFn.StateId.class), id, field.toString(), ((DoFnSignature.StateDeclaration)declarations.get(id)).field().toString());
                continue;
            }
            Class<?> stateSpecRawType = field.getType();
            if (!TypeDescriptor.of(stateSpecRawType).isSubtypeOf(TypeDescriptor.of(StateSpec.class))) {
                errors.throwIllegalArgument("%s annotation on non-%s field [%s] that has class %s", DoFnSignatures.format(DoFn.StateId.class), DoFnSignatures.format(StateSpec.class), field.toString(), stateSpecRawType.getName());
                continue;
            }
            if (!Modifier.isFinal(field.getModifiers())) {
                errors.throwIllegalArgument("Non-final field %s annotated with %s. State declarations must be final.", field.toString(), DoFnSignatures.format(DoFn.StateId.class));
                continue;
            }
            Type stateSpecType = field.getGenericType();
            TypeDescriptor<?> stateSpecSubclassTypeDescriptor = TypeDescriptor.of(stateSpecType);
            TypeDescriptor<StateSpec> stateSpecTypeDescriptor = stateSpecSubclassTypeDescriptor.getSupertype(StateSpec.class);
            Type unresolvedStateType = ((ParameterizedType)stateSpecTypeDescriptor.getType()).getActualTypeArguments()[0];
            TypeDescriptor<?> stateType = TypeDescriptor.of(fnClazz).resolveType(unresolvedStateType);
            declarations.put(id, DoFnSignature.StateDeclaration.create(id, field, stateType));
        }
        return ImmutableMap.copyOf(declarations);
    }

    private static @Nullable Method findAnnotatedMethod(ErrorReporter errors, Class<? extends Annotation> anno, Class<?> fnClazz, boolean required) {
        Collection<Method> matches = ReflectHelpers.declaredMethodsWithAnnotation(anno, fnClazz, DoFn.class);
        if (matches.isEmpty()) {
            errors.checkArgument(!required, "No method annotated with @%s found", DoFnSignatures.format(anno));
            return null;
        }
        Method first = matches.iterator().next();
        for (Method other : matches) {
            errors.checkArgument(first.getName().equals(other.getName()) && Arrays.equals(first.getParameterTypes(), other.getParameterTypes()), "Found multiple methods annotated with @%s. [%s] and [%s]", DoFnSignatures.format(anno), DoFnSignatures.format(first), DoFnSignatures.format(other));
        }
        ErrorReporter methodErrors = errors.forMethod(anno, first);
        methodErrors.checkArgument((first.getModifiers() & 1) != 0, "Must be public", new Object[0]);
        methodErrors.checkArgument((first.getModifiers() & 8) == 0, "Must not be static", new Object[0]);
        return first;
    }

    private static String format(Method method) {
        return ReflectHelpers.formatMethod(method);
    }

    private static String format(TypeDescriptor<?> t) {
        return ReflectHelpers.simpleTypeDescription(t.getType());
    }

    private static String format(Class<?> kls) {
        return kls.getSimpleName();
    }

    public static StateSpec<?> getStateSpecOrThrow(DoFnSignature.StateDeclaration stateDeclaration, DoFn<?, ?> target) {
        try {
            Object fieldValue = stateDeclaration.field().get(target);
            Preconditions.checkState(fieldValue instanceof StateSpec, "Malformed %s class %s: state declaration field %s does not have type %s.", (Object)DoFnSignatures.format(DoFn.class), (Object)target.getClass().getName(), (Object)stateDeclaration.field().getName(), StateSpec.class);
            return (StateSpec)stateDeclaration.field().get(target);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException(String.format("Malformed %s class %s: state declaration field %s is not accessible.", DoFnSignatures.format(DoFn.class), target.getClass().getName(), stateDeclaration.field().getName()));
        }
    }

    public static TimerSpec getTimerSpecOrThrow(DoFnSignature.TimerDeclaration timerDeclaration, DoFn<?, ?> target) {
        try {
            Object fieldValue = timerDeclaration.field().get(target);
            Preconditions.checkState(fieldValue instanceof TimerSpec, "Malformed %s class %s: timer declaration field %s does not have type %s.", (Object)DoFnSignatures.format(DoFn.class), (Object)target.getClass().getName(), (Object)timerDeclaration.field().getName(), TimerSpec.class);
            return (TimerSpec)timerDeclaration.field().get(target);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException(String.format("Malformed %s class %s: timer declaration field %s is not accessible.", DoFnSignatures.format(DoFn.class), target.getClass().getName(), timerDeclaration.field().getName()));
        }
    }

    public static TimerSpec getTimerFamilySpecOrThrow(DoFnSignature.TimerFamilyDeclaration timerFamilyDeclaration, DoFn<?, ?> target) {
        try {
            Object fieldValue = timerFamilyDeclaration.field().get(target);
            Preconditions.checkState(fieldValue instanceof TimerSpec, "Malformed %s class %s: timer declaration field %s does not have type %s.", (Object)DoFnSignatures.format(DoFn.class), (Object)target.getClass().getName(), (Object)timerFamilyDeclaration.field().getName(), TimerSpec.class);
            return (TimerSpec)timerFamilyDeclaration.field().get(target);
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException(String.format("Malformed %s class %s: timer declaration field %s is not accessible.", DoFnSignatures.format(DoFn.class), target.getClass().getName(), timerFamilyDeclaration.field().getName()));
        }
    }

    public static boolean isSplittable(DoFn<?, ?> doFn) {
        return DoFnSignatures.signatureForDoFn(doFn).processElement().isSplittable();
    }

    public static boolean isStateful(DoFn<?, ?> doFn) {
        return DoFnSignatures.usesState(doFn) || DoFnSignatures.usesTimers(doFn);
    }

    public static boolean usesMapState(DoFn<?, ?> doFn) {
        return DoFnSignatures.usesGivenStateClass(doFn, MapState.class);
    }

    public static boolean usesSetState(DoFn<?, ?> doFn) {
        return DoFnSignatures.usesGivenStateClass(doFn, SetState.class);
    }

    public static boolean usesOrderedListState(DoFn<?, ?> doFn) {
        return DoFnSignatures.usesGivenStateClass(doFn, OrderedListState.class);
    }

    public static boolean usesValueState(DoFn<?, ?> doFn) {
        return DoFnSignatures.usesGivenStateClass(doFn, ValueState.class) || DoFnSignatures.requiresTimeSortedInput(doFn);
    }

    public static boolean usesBagState(DoFn<?, ?> doFn) {
        return DoFnSignatures.usesGivenStateClass(doFn, BagState.class) || DoFnSignatures.requiresTimeSortedInput(doFn);
    }

    public static boolean usesWatermarkHold(DoFn<?, ?> doFn) {
        return DoFnSignatures.usesGivenStateClass(doFn, WatermarkHoldState.class) || DoFnSignatures.requiresTimeSortedInput(doFn);
    }

    public static boolean usesTimers(DoFn<?, ?> doFn) {
        return DoFnSignatures.signatureForDoFn(doFn).usesTimers() || DoFnSignatures.requiresTimeSortedInput(doFn);
    }

    public static boolean usesState(DoFn<?, ?> doFn) {
        return DoFnSignatures.signatureForDoFn(doFn).usesState() || DoFnSignatures.requiresTimeSortedInput(doFn);
    }

    public static boolean requiresTimeSortedInput(DoFn<?, ?> doFn) {
        return DoFnSignatures.signatureForDoFn(doFn).processElement().requiresTimeSortedInput();
    }

    private static boolean usesGivenStateClass(DoFn<?, ?> doFn, Class<? extends State> stateClass) {
        return DoFnSignatures.signatureForDoFn(doFn).stateDeclarations().values().stream().anyMatch(d -> d.stateType().isSubtypeOf(TypeDescriptor.of(stateClass)));
    }

    static class ErrorReporter {
        private final String label;

        ErrorReporter(@Nullable ErrorReporter root, String label) {
            this.label = root == null ? label : String.format("%s, %s", root.label, label);
        }

        ErrorReporter forMethod(Class<? extends Annotation> annotation, Method method) {
            return new ErrorReporter(this, String.format("@%s %s", DoFnSignatures.format(annotation), method == null ? "(absent)" : DoFnSignatures.format(method)));
        }

        ErrorReporter forParameter(ParameterDescription param) {
            return new ErrorReporter(this, String.format("parameter of type %s at index %s", DoFnSignatures.format(param.getType()), param.getIndex()));
        }

        void throwIllegalArgument(String message, Object ... args) {
            throw new IllegalArgumentException(this.label + ": " + String.format(message, args));
        }

        public void checkArgument(boolean condition, String message, Object ... args) {
            if (!condition) {
                this.throwIllegalArgument(message, args);
            }
        }

        public void checkNotNull(Object value, String message, Object ... args) {
            if (value == null) {
                this.throwIllegalArgument(message, args);
            }
        }
    }

    @AutoValue
    static abstract class ParameterDescription {
        ParameterDescription() {
        }

        public abstract Method getMethod();

        public abstract int getIndex();

        public abstract TypeDescriptor<?> getType();

        public abstract List<Annotation> getAnnotations();

        public static ParameterDescription of(Method method, int index, TypeDescriptor<?> type, List<Annotation> annotations) {
            return new AutoValue_DoFnSignatures_ParameterDescription(method, index, type, annotations);
        }

        public static ParameterDescription of(Method method, int index, TypeDescriptor<?> type, Annotation[] annotations) {
            return new AutoValue_DoFnSignatures_ParameterDescription(method, index, type, Arrays.asList(annotations));
        }
    }

    private static class MethodAnalysisContext {
        private final Map<String, DoFnSignature.Parameter.StateParameter> stateParameters = new HashMap<String, DoFnSignature.Parameter.StateParameter>();
        private final Map<String, DoFnSignature.Parameter.TimerParameter> timerParameters = new HashMap<String, DoFnSignature.Parameter.TimerParameter>();
        private final Map<String, DoFnSignature.Parameter.TimerFamilyParameter> timerFamilyParameters = new HashMap<String, DoFnSignature.Parameter.TimerFamilyParameter>();
        private final List<DoFnSignature.Parameter> extraParameters = new ArrayList<DoFnSignature.Parameter>();

        private MethodAnalysisContext() {
        }

        public boolean hasParameter(Class<? extends DoFnSignature.Parameter> type) {
            return this.extraParameters.stream().anyMatch(Predicates.instanceOf(type)::apply);
        }

        public <T extends DoFnSignature.Parameter> @Nullable Optional<T> findParameter(Class<T> type) {
            List<T> parameters = this.findParameters(type);
            switch (parameters.size()) {
                case 0: {
                    return Optional.empty();
                }
                case 1: {
                    return Optional.of((DoFnSignature.Parameter)parameters.get(0));
                }
            }
            throw new IllegalStateException(String.format("Expected to have found at most one parameter of type %s but found %s.", type, parameters));
        }

        public <T extends DoFnSignature.Parameter> List<T> findParameters(Class<T> type) {
            return this.extraParameters.stream().filter(Predicates.instanceOf(type)).collect(Collectors.toList());
        }

        public Map<String, DoFnSignature.Parameter.StateParameter> getStateParameters() {
            return Collections.unmodifiableMap(this.stateParameters);
        }

        public Map<String, DoFnSignature.Parameter.TimerParameter> getTimerParameters() {
            return Collections.unmodifiableMap(this.timerParameters);
        }

        public Map<String, DoFnSignature.Parameter.TimerFamilyParameter> getTimerFamilyParameters() {
            return Collections.unmodifiableMap(this.timerFamilyParameters);
        }

        public List<DoFnSignature.Parameter> getExtraParameters() {
            return Collections.unmodifiableList(this.extraParameters);
        }

        public void setParameter(int index, DoFnSignature.Parameter parameter) {
            this.extraParameters.set(index, parameter);
        }

        public void addParameter(DoFnSignature.Parameter param) {
            this.extraParameters.add(param);
            if (param instanceof DoFnSignature.Parameter.StateParameter) {
                DoFnSignature.Parameter.StateParameter stateParameter = (DoFnSignature.Parameter.StateParameter)param;
                this.stateParameters.put(stateParameter.referent().id(), stateParameter);
            }
            if (param instanceof DoFnSignature.Parameter.TimerParameter) {
                DoFnSignature.Parameter.TimerParameter timerParameter = (DoFnSignature.Parameter.TimerParameter)param;
                this.timerParameters.put(timerParameter.referent().id(), timerParameter);
            }
            if (param instanceof DoFnSignature.Parameter.TimerFamilyParameter) {
                DoFnSignature.Parameter.TimerFamilyParameter timerFamilyParameter = (DoFnSignature.Parameter.TimerFamilyParameter)param;
                this.timerFamilyParameters.put(timerFamilyParameter.referent().id(), timerFamilyParameter);
            }
        }

        public static MethodAnalysisContext create() {
            return new MethodAnalysisContext();
        }
    }

    @VisibleForTesting
    static class FnAnalysisContext {
        private final Map<String, DoFnSignature.StateDeclaration> stateDeclarations = new HashMap<String, DoFnSignature.StateDeclaration>();
        private final Map<String, DoFnSignature.TimerDeclaration> timerDeclarations = new HashMap<String, DoFnSignature.TimerDeclaration>();
        private final Map<String, DoFnSignature.TimerFamilyDeclaration> timerFamilyDeclarations = new HashMap<String, DoFnSignature.TimerFamilyDeclaration>();
        private final Map<String, DoFnSignature.FieldAccessDeclaration> fieldAccessDeclarations = new HashMap<String, DoFnSignature.FieldAccessDeclaration>();

        private FnAnalysisContext() {
        }

        public static FnAnalysisContext create() {
            return new FnAnalysisContext();
        }

        public Map<String, DoFnSignature.StateDeclaration> getStateDeclarations() {
            return Collections.unmodifiableMap(this.stateDeclarations);
        }

        public Map<String, DoFnSignature.TimerDeclaration> getTimerDeclarations() {
            return Collections.unmodifiableMap(this.timerDeclarations);
        }

        public Map<String, DoFnSignature.TimerFamilyDeclaration> getTimerFamilyDeclarations() {
            return Collections.unmodifiableMap(this.timerFamilyDeclarations);
        }

        public @Nullable Map<String, DoFnSignature.FieldAccessDeclaration> getFieldAccessDeclarations() {
            return this.fieldAccessDeclarations;
        }

        public void addStateDeclaration(DoFnSignature.StateDeclaration decl) {
            this.stateDeclarations.put(decl.id(), decl);
        }

        public void addStateDeclarations(Iterable<DoFnSignature.StateDeclaration> decls) {
            for (DoFnSignature.StateDeclaration decl : decls) {
                this.addStateDeclaration(decl);
            }
        }

        public void addTimerDeclaration(DoFnSignature.TimerDeclaration decl) {
            this.timerDeclarations.put(decl.id(), decl);
        }

        public void addTimerFamilyDeclaration(DoFnSignature.TimerFamilyDeclaration decl) {
            this.timerFamilyDeclarations.put(decl.id(), decl);
        }

        public void addTimerDeclarations(Iterable<DoFnSignature.TimerDeclaration> decls) {
            for (DoFnSignature.TimerDeclaration decl : decls) {
                this.addTimerDeclaration(decl);
            }
        }

        public void addTimerFamilyDeclarations(Iterable<DoFnSignature.TimerFamilyDeclaration> decls) {
            for (DoFnSignature.TimerFamilyDeclaration decl : decls) {
                this.addTimerFamilyDeclaration(decl);
            }
        }

        public void addFieldAccessDeclaration(DoFnSignature.FieldAccessDeclaration decl) {
            this.fieldAccessDeclarations.put(decl.id(), decl);
        }

        public void addFieldAccessDeclarations(Iterable<DoFnSignature.FieldAccessDeclaration> decls) {
            for (DoFnSignature.FieldAccessDeclaration decl : decls) {
                this.addFieldAccessDeclaration(decl);
            }
        }
    }
}

