/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterPane
extends Trigger.OnceTrigger {
    private final int countElems;

    private AfterPane(int countElems) {
        super(null);
        this.countElems = countElems;
    }

    public int getElementCount() {
        return this.countElems;
    }

    public static AfterPane elementCountAtLeast(int countElems) {
        return new AfterPane(countElems);
    }

    @Override
    public boolean isCompatible(Trigger other) {
        return this.equals(other);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(BoundedWindow window) {
        return BoundedWindow.TIMESTAMP_MAX_VALUE;
    }

    @Override
    protected Trigger.OnceTrigger getContinuationTrigger(List<Trigger> continuationTriggers) {
        return AfterPane.elementCountAtLeast(1);
    }

    @Override
    public String toString() {
        return "AfterPane.elementCountAtLeast(" + this.countElems + ")";
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfterPane)) {
            return false;
        }
        AfterPane that = (AfterPane)obj;
        return this.countElems == that.countElems;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.countElems);
    }
}

