/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.AutoValue_Window;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Ordering;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

@AutoValue
public abstract class Window<T>
extends PTransform<PCollection<T>, PCollection<T>> {
    public static <T> Window<T> into(WindowFn<? super T, ?> fn) {
        try {
            fn.windowCoder().verifyDeterministic();
        }
        catch (Coder.NonDeterministicException e) {
            throw new IllegalArgumentException("Window coders must be deterministic.", e);
        }
        return super.withWindowFn(fn);
    }

    public static <T> Window<T> configure() {
        return new AutoValue_Window.Builder().build();
    }

    public abstract @Nullable WindowFn<? super T, ?> getWindowFn();

    abstract @Nullable Trigger getTrigger();

    abstract @Nullable WindowingStrategy.AccumulationMode getAccumulationMode();

    abstract @Nullable Duration getAllowedLateness();

    abstract @Nullable ClosingBehavior getClosingBehavior();

    abstract @Nullable OnTimeBehavior getOnTimeBehavior();

    abstract @Nullable TimestampCombiner getTimestampCombiner();

    abstract Builder<T> toBuilder();

    private Window<T> withWindowFn(WindowFn<? super T, ?> windowFn) {
        return this.toBuilder().setWindowFn(windowFn).build();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public Window<T> triggering(Trigger trigger) {
        return this.toBuilder().setTrigger(trigger).build();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public Window<T> discardingFiredPanes() {
        return this.toBuilder().setAccumulationMode(WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES).build();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public Window<T> accumulatingFiredPanes() {
        return this.toBuilder().setAccumulationMode(WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES).build();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public Window<T> withAllowedLateness(Duration allowedLateness) {
        return this.toBuilder().setAllowedLateness(allowedLateness).build();
    }

    @Experimental(value=Experimental.Kind.OUTPUT_TIME)
    public Window<T> withTimestampCombiner(TimestampCombiner timestampCombiner) {
        return this.toBuilder().setTimestampCombiner(timestampCombiner).build();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public Window<T> withAllowedLateness(Duration allowedLateness, ClosingBehavior behavior) {
        return this.toBuilder().setAllowedLateness(allowedLateness).setClosingBehavior(behavior).build();
    }

    @Experimental(value=Experimental.Kind.TRIGGER)
    public Window<T> withOnTimeBehavior(OnTimeBehavior behavior) {
        return this.toBuilder().setOnTimeBehavior(behavior).build();
    }

    public WindowingStrategy<?, ?> getOutputStrategyInternal(WindowingStrategy<?, ?> inputStrategy) {
        WindowingStrategy<?, ?> result = inputStrategy;
        if (this.getWindowFn() != null) {
            result = result.withAlreadyMerged(false).withWindowFn(this.getWindowFn());
        }
        if (this.getTrigger() != null) {
            result = result.withTrigger(this.getTrigger());
        }
        if (this.getAccumulationMode() != null) {
            result = result.withMode(this.getAccumulationMode());
        }
        if (this.getAllowedLateness() != null) {
            result = result.withAllowedLateness(Ordering.natural().max(this.getAllowedLateness(), inputStrategy.getAllowedLateness()));
        }
        if (this.getClosingBehavior() != null) {
            result = result.withClosingBehavior(this.getClosingBehavior());
        }
        if (this.getOnTimeBehavior() != null) {
            result = result.withOnTimeBehavior(this.getOnTimeBehavior());
        }
        if (this.getTimestampCombiner() != null) {
            result = result.withTimestampCombiner(this.getTimestampCombiner());
        }
        return result;
    }

    private void applicableTo(PCollection<?> input) {
        WindowingStrategy<?, ?> outputStrategy = this.getOutputStrategyInternal(input.getWindowingStrategy());
        if (outputStrategy.isTriggerSpecified() && !(outputStrategy.getTrigger() instanceof DefaultTrigger) && !(outputStrategy.getWindowFn() instanceof GlobalWindows) && !outputStrategy.isAllowedLatenessSpecified()) {
            throw new IllegalArgumentException("Except when using GlobalWindows, calling .triggering() to specify a trigger requires that the allowed lateness be specified using .withAllowedLateness() to set the upper bound on how late data can arrive before being dropped. See Javadoc for more details.");
        }
        if (!outputStrategy.isModeSpecified() && this.canProduceMultiplePanes(outputStrategy)) {
            throw new IllegalArgumentException("Calling .triggering() to specify a trigger or calling .withAllowedLateness() to specify an allowed lateness greater than zero requires that the accumulation mode be specified using .discardingFiredPanes() or .accumulatingFiredPanes(). See Javadoc for more details.");
        }
    }

    private boolean canProduceMultiplePanes(WindowingStrategy<?, ?> strategy) {
        boolean dataCanArriveLate = !(strategy.getWindowFn() instanceof GlobalWindows) && strategy.getAllowedLateness().getMillis() > 0L;
        boolean hasCustomTrigger = !(strategy.getTrigger() instanceof DefaultTrigger);
        return dataCanArriveLate || hasCustomTrigger;
    }

    @Override
    public PCollection<T> expand(PCollection<T> input) {
        this.applicableTo(input);
        WindowingStrategy<?, ?> outputStrategy = this.getOutputStrategyInternal(input.getWindowingStrategy());
        if (this.getWindowFn() == null) {
            return ((PCollection)PCollectionList.of(input).apply(Flatten.pCollections())).setWindowingStrategyInternal(outputStrategy);
        }
        return (PCollection)input.apply(new Assign(this, outputStrategy));
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        if (this.getWindowFn() != null) {
            builder.add(DisplayData.item("windowFn", this.getWindowFn().getClass()).withLabel("Windowing Function")).include("windowFn", this.getWindowFn());
        }
        if (this.getAllowedLateness() != null) {
            builder.addIfNotDefault(DisplayData.item("allowedLateness", this.getAllowedLateness()).withLabel("Allowed Lateness"), Duration.millis(BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()));
        }
        if (this.getTrigger() != null && !(this.getTrigger() instanceof DefaultTrigger)) {
            builder.add(DisplayData.item("trigger", this.getTrigger().toString()).withLabel("Trigger"));
        }
        if (this.getAccumulationMode() != null) {
            builder.add(DisplayData.item("accumulationMode", this.getAccumulationMode().toString()).withLabel("Accumulation Mode"));
        }
        if (this.getClosingBehavior() != null) {
            builder.add(DisplayData.item("closingBehavior", this.getClosingBehavior().toString()).withLabel("Window Closing Behavior"));
        }
        if (this.getTimestampCombiner() != null) {
            builder.add(DisplayData.item("timestampCombiner", this.getTimestampCombiner().toString()).withLabel("Timestamp Combiner"));
        }
    }

    @Override
    protected String getKindString() {
        return "Window.Into()";
    }

    public static <T> Remerge<T> remerge() {
        return new Remerge();
    }

    private static class Remerge<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private Remerge() {
        }

        @Override
        public PCollection<T> expand(PCollection<T> input) {
            return ((PCollection)input.apply("Identity", MapElements.via(new SimpleFunction<T, T>(){

                @Override
                public T apply(T element) {
                    return element;
                }
            }))).setWindowingStrategyInternal(input.getWindowingStrategy().withAlreadyMerged(false));
        }
    }

    public static class Assign<T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final Window<T> original;
        private final WindowingStrategy<T, ?> updatedStrategy;

        @VisibleForTesting
        Assign(Window<T> original, WindowingStrategy updatedStrategy) {
            this.original = original;
            this.updatedStrategy = updatedStrategy;
        }

        @Override
        public PCollection<T> expand(PCollection<T> input) {
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), this.updatedStrategy, input.isBounded(), input.getCoder());
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            this.original.populateDisplayData(builder);
        }

        public @Nullable WindowFn<T, ?> getWindowFn() {
            return this.updatedStrategy.getWindowFn();
        }
    }

    @AutoValue.Builder
    static abstract class Builder<T> {
        Builder() {
        }

        abstract Builder<T> setWindowFn(WindowFn<? super T, ?> var1);

        abstract Builder<T> setTrigger(Trigger var1);

        abstract Builder<T> setAccumulationMode(WindowingStrategy.AccumulationMode var1);

        abstract Builder<T> setAllowedLateness(Duration var1);

        abstract Builder<T> setClosingBehavior(ClosingBehavior var1);

        abstract Builder<T> setOnTimeBehavior(OnTimeBehavior var1);

        abstract Builder<T> setTimestampCombiner(TimestampCombiner var1);

        abstract Window<T> build();
    }

    public static enum OnTimeBehavior {
        FIRE_ALWAYS,
        FIRE_IF_NON_EMPTY;

    }

    public static enum ClosingBehavior {
        FIRE_ALWAYS,
        FIRE_IF_NON_EMPTY;

    }
}

