/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.Arrays;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class MovingFunction {
    private final long sampleUpdateMs;
    private final int numSignificantBuckets;
    private final int numSignificantSamples;
    private final Combine.BinaryCombineLongFn function;
    private final long[] buckets;
    private final int[] numSamples;
    private long currentMsSinceEpoch;
    private int currentIndex;

    public MovingFunction(long samplePeriodMs, long sampleUpdateMs, int numSignificantBuckets, int numSignificantSamples, Combine.BinaryCombineLongFn function) {
        this.sampleUpdateMs = sampleUpdateMs;
        this.numSignificantBuckets = numSignificantBuckets;
        this.numSignificantSamples = numSignificantSamples;
        this.function = function;
        int n = (int)(samplePeriodMs / sampleUpdateMs);
        this.buckets = new long[n];
        Arrays.fill(this.buckets, function.identity());
        this.numSamples = new int[n];
        Arrays.fill(this.numSamples, 0);
        this.currentMsSinceEpoch = -1L;
        this.currentIndex = 0;
    }

    private void flush(long nowMsSinceEpoch) {
        Preconditions.checkArgument(nowMsSinceEpoch >= 0L, "Only positive timestamps supported");
        Preconditions.checkArgument(nowMsSinceEpoch >= this.currentMsSinceEpoch, "Attempting to move backwards");
        this.currentMsSinceEpoch = nowMsSinceEpoch - nowMsSinceEpoch % this.sampleUpdateMs;
        for (int newBuckets = Math.min((int)((nowMsSinceEpoch - this.currentMsSinceEpoch) / this.sampleUpdateMs), this.buckets.length); newBuckets > 0; --newBuckets) {
            this.currentIndex = (this.currentIndex + 1) % this.buckets.length;
            this.buckets[this.currentIndex] = this.function.identity();
            this.numSamples[this.currentIndex] = 0;
        }
    }

    public void add(long nowMsSinceEpoch, long value) {
        this.flush(nowMsSinceEpoch);
        this.buckets[this.currentIndex] = this.function.apply(this.buckets[this.currentIndex], value);
        int n = this.currentIndex;
        this.numSamples[n] = this.numSamples[n] + 1;
    }

    public long get(long nowMsSinceEpoch) {
        this.flush(nowMsSinceEpoch);
        long result = this.function.identity();
        for (long bucket : this.buckets) {
            result = this.function.apply(result, bucket);
        }
        return result;
    }

    public boolean isSignificant() {
        int totalSamples = 0;
        int activeBuckets = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            totalSamples += this.numSamples[i];
            if (this.numSamples[i] <= 0) continue;
            ++activeBuckets;
        }
        return activeBuckets >= this.numSignificantBuckets || totalSamples >= this.numSignificantSamples;
    }
}

