/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.util.AutoValue_RowJson_RowJsonDeserializer_FieldValue;
import org.apache.beam.sdk.util.RowJsonValueExtractors;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.DateTime;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class RowJson {
    private static final ImmutableSet<Schema.TypeName> SUPPORTED_TYPES = ImmutableSet.of(Schema.TypeName.BYTE, Schema.TypeName.INT16, Schema.TypeName.INT32, Schema.TypeName.INT64, Schema.TypeName.FLOAT, Schema.TypeName.DOUBLE, new Schema.TypeName[]{Schema.TypeName.BOOLEAN, Schema.TypeName.STRING, Schema.TypeName.DECIMAL, Schema.TypeName.DATETIME});
    private static final ImmutableSet<String> KNOWN_LOGICAL_TYPE_IDENTIFIERS = ImmutableSet.of(SqlTypes.DATE.getIdentifier(), SqlTypes.TIME.getIdentifier(), SqlTypes.DATETIME.getIdentifier());

    public static void verifySchemaSupported(Schema schema) {
        ImmutableList<UnsupportedField> unsupportedFields = RowJson.findUnsupportedFields(schema);
        if (!unsupportedFields.isEmpty()) {
            throw new UnsupportedRowJsonException(String.format("Field type%s %s not supported when converting between JSON and Rows. Supported types are: %s", unsupportedFields.size() > 1 ? "s" : "", unsupportedFields.toString(), SUPPORTED_TYPES.toString()));
        }
    }

    private static ImmutableList<UnsupportedField> findUnsupportedFields(Schema schema) {
        return schema.getFields().stream().flatMap(field -> RowJson.findUnsupportedFields(field).stream()).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<UnsupportedField> findUnsupportedFields(Schema.Field field) {
        return RowJson.findUnsupportedFields(field.getType(), field.getName());
    }

    private static ImmutableList<UnsupportedField> findUnsupportedFields(Schema.FieldType fieldType, String fieldName) {
        Schema.TypeName fieldTypeName = fieldType.getTypeName();
        if (fieldTypeName.isCompositeType()) {
            return fieldType.getRowSchema().getFields().stream().flatMap(field -> RowJson.findUnsupportedFields(field.getType(), fieldName + "." + field.getName()).stream()).collect(ImmutableList.toImmutableList());
        }
        if (fieldTypeName.isCollectionType()) {
            return RowJson.findUnsupportedFields(fieldType.getCollectionElementType(), fieldName + "[]");
        }
        if (fieldTypeName.isLogicalType()) {
            if (KNOWN_LOGICAL_TYPE_IDENTIFIERS.contains(fieldType.getLogicalType().getIdentifier())) {
                return ImmutableList.of();
            }
            return RowJson.findUnsupportedFields(fieldType.getLogicalType().getBaseType(), fieldName);
        }
        if (!SUPPORTED_TYPES.contains((Object)fieldTypeName)) {
            return ImmutableList.of(new UnsupportedField(fieldName, fieldTypeName));
        }
        return ImmutableList.of();
    }

    public static class UnsupportedRowJsonException
    extends RuntimeException {
        UnsupportedRowJsonException(String message, Throwable reason) {
            super(message, reason);
        }

        UnsupportedRowJsonException(String message) {
            super(message);
        }
    }

    public static class RowJsonSerializer
    extends StdSerializer<Row> {
        private final Schema schema;
        private Boolean dropNullsOnWrite = false;

        public static RowJsonSerializer forSchema(Schema schema) {
            RowJson.verifySchemaSupported(schema);
            return new RowJsonSerializer(schema);
        }

        private RowJsonSerializer(Schema schema) {
            super(Row.class);
            this.schema = schema;
        }

        public RowJsonSerializer withDropNullsOnWrite(Boolean dropNullsOnWrite) {
            this.dropNullsOnWrite = dropNullsOnWrite;
            return this;
        }

        @Override
        public void serialize(Row value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            this.writeRow(value, this.schema, gen);
        }

        private void writeRow(Row row, Schema schema, JsonGenerator gen) throws IOException {
            gen.writeStartObject();
            for (int i = 0; i < schema.getFieldCount(); ++i) {
                Schema.Field field = schema.getField(i);
                Object value = row.getValue(i);
                if (this.dropNullsOnWrite.booleanValue() && value == null && field.getType().getNullable().booleanValue()) continue;
                gen.writeFieldName(field.getName());
                if (field.getType().getNullable().booleanValue() && value == null) {
                    gen.writeNull();
                    continue;
                }
                this.writeValue(gen, field.getType(), value);
            }
            gen.writeEndObject();
        }

        private void writeValue(JsonGenerator gen, Schema.FieldType type, Object value) throws IOException {
            switch (type.getTypeName()) {
                case BOOLEAN: {
                    gen.writeBoolean((Boolean)value);
                    break;
                }
                case STRING: {
                    gen.writeString((String)value);
                    break;
                }
                case BYTE: {
                    gen.writeNumber(((Byte)value).byteValue());
                    break;
                }
                case DOUBLE: {
                    gen.writeNumber((Double)value);
                    break;
                }
                case FLOAT: {
                    gen.writeNumber(((Float)value).floatValue());
                    break;
                }
                case INT16: {
                    gen.writeNumber((Short)value);
                    break;
                }
                case INT32: {
                    gen.writeNumber((Integer)value);
                    break;
                }
                case INT64: {
                    gen.writeNumber((Long)value);
                    break;
                }
                case DECIMAL: {
                    gen.writeNumber((BigDecimal)value);
                    break;
                }
                case DATETIME: {
                    gen.writeString(((DateTime)value).toString());
                    break;
                }
                case ARRAY: 
                case ITERABLE: {
                    gen.writeStartArray();
                    for (Object element : (Iterable)value) {
                        this.writeValue(gen, type.getCollectionElementType(), element);
                    }
                    gen.writeEndArray();
                    break;
                }
                case ROW: {
                    this.writeRow((Row)value, type.getRowSchema(), gen);
                    break;
                }
                case LOGICAL_TYPE: {
                    String identifier = type.getLogicalType().getIdentifier();
                    if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                        gen.writeString(((LocalDate)value).toString());
                        break;
                    }
                    if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                        gen.writeString(((LocalTime)value).toString());
                        break;
                    }
                    if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                        gen.writeString(((LocalDateTime)value).toString());
                        break;
                    }
                    this.writeValue(gen, type.getLogicalType().getBaseType(), value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported field type: " + type);
                }
            }
        }
    }

    public static class RowJsonDeserializer
    extends StdDeserializer<Row> {
        private static final boolean SEQUENTIAL = false;
        private static final ImmutableMap<Schema.TypeName, RowJsonValueExtractors.ValueExtractor<?>> JSON_VALUE_GETTERS = ImmutableMap.builder().put(Schema.TypeName.BYTE, RowJsonValueExtractors.byteValueExtractor()).put(Schema.TypeName.INT16, RowJsonValueExtractors.shortValueExtractor()).put(Schema.TypeName.INT32, RowJsonValueExtractors.intValueExtractor()).put(Schema.TypeName.INT64, RowJsonValueExtractors.longValueExtractor()).put(Schema.TypeName.FLOAT, RowJsonValueExtractors.floatValueExtractor()).put(Schema.TypeName.DOUBLE, RowJsonValueExtractors.doubleValueExtractor()).put(Schema.TypeName.BOOLEAN, RowJsonValueExtractors.booleanValueExtractor()).put(Schema.TypeName.STRING, RowJsonValueExtractors.stringValueExtractor()).put(Schema.TypeName.DECIMAL, RowJsonValueExtractors.decimalValueExtractor()).put(Schema.TypeName.DATETIME, RowJsonValueExtractors.datetimeValueExtractor()).build();
        private final Schema schema;
        private NullBehavior nullBehavior = NullBehavior.ACCEPT_MISSING_OR_NULL;

        public static RowJsonDeserializer forSchema(Schema schema) {
            RowJson.verifySchemaSupported(schema);
            return new RowJsonDeserializer(schema);
        }

        private RowJsonDeserializer(Schema schema) {
            super(Row.class);
            this.schema = schema;
        }

        public RowJsonDeserializer withNullBehavior(NullBehavior behavior) {
            this.nullBehavior = behavior;
            return this;
        }

        @Override
        public Row deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return (Row)this.extractJsonNodeValue(FieldValue.of("root", Schema.FieldType.row(this.schema), (JsonNode)jsonParser.readValueAsTree()));
        }

        private Object extractJsonNodeValue(FieldValue fieldValue) {
            if (fieldValue.type().getNullable().booleanValue()) {
                if (!fieldValue.isJsonValuePresent()) {
                    switch (this.nullBehavior) {
                        case ACCEPT_MISSING_OR_NULL: 
                        case REQUIRE_MISSING: {
                            return null;
                        }
                        case REQUIRE_NULL: {
                            throw new UnsupportedRowJsonException("Field '" + fieldValue.name() + "' is not present in the JSON object.");
                        }
                    }
                }
                if (fieldValue.isJsonNull()) {
                    switch (this.nullBehavior) {
                        case ACCEPT_MISSING_OR_NULL: 
                        case REQUIRE_NULL: {
                            return null;
                        }
                        case REQUIRE_MISSING: {
                            throw new UnsupportedRowJsonException("Field '" + fieldValue.name() + "' has a null value in the JSON object.");
                        }
                    }
                }
            } else {
                if (!fieldValue.isJsonValuePresent()) {
                    throw new UnsupportedRowJsonException("Non-nullable field '" + fieldValue.name() + "' is not present in the JSON object.");
                }
                if (fieldValue.isJsonNull()) {
                    throw new UnsupportedRowJsonException("Non-nullable field '" + fieldValue.name() + "' has value null in the JSON object.");
                }
            }
            if (fieldValue.isRowType()) {
                return this.jsonObjectToRow(fieldValue);
            }
            if (fieldValue.isArrayType()) {
                return this.jsonArrayToList(fieldValue);
            }
            if (fieldValue.typeName().isLogicalType()) {
                String identifier = fieldValue.type().getLogicalType().getIdentifier();
                if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                    return RowJsonValueExtractors.dateValueExtractor().extractValue(fieldValue.jsonValue());
                }
                if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                    return RowJsonValueExtractors.timeValueExtractor().extractValue(fieldValue.jsonValue());
                }
                if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                    return RowJsonValueExtractors.localDatetimeValueExtractor().extractValue(fieldValue.jsonValue());
                }
                return this.extractJsonNodeValue(FieldValue.of(fieldValue.name(), fieldValue.type().getLogicalType().getBaseType(), fieldValue.jsonValue()));
            }
            return RowJsonDeserializer.extractJsonPrimitiveValue(fieldValue);
        }

        private Row jsonObjectToRow(FieldValue rowFieldValue) {
            if (!rowFieldValue.isJsonObject()) {
                throw new UnsupportedRowJsonException("Expected JSON object for field '" + rowFieldValue.name() + "'. Unable to convert '" + rowFieldValue.jsonValue().asText() + "' to Beam Row, it is not a JSON object. Currently only JSON objects can be parsed to Beam Rows");
            }
            return rowFieldValue.rowSchema().getFields().stream().map(schemaField -> this.extractJsonNodeValue(FieldValue.of(schemaField.getName(), schemaField.getType(), rowFieldValue.jsonFieldValue(schemaField.getName())))).collect(Row.toRow(rowFieldValue.rowSchema()));
        }

        private Object jsonArrayToList(FieldValue arrayFieldValue) {
            if (!arrayFieldValue.isJsonArray()) {
                throw new UnsupportedRowJsonException("Expected JSON array for field '" + arrayFieldValue.name() + "'. Instead got " + arrayFieldValue.jsonNodeType().name());
            }
            return arrayFieldValue.jsonArrayElements().map(jsonArrayElement -> this.extractJsonNodeValue(FieldValue.of(arrayFieldValue.name() + "[]", arrayFieldValue.arrayElementType(), jsonArrayElement))).collect(ImmutableList.toImmutableList());
        }

        private static Object extractJsonPrimitiveValue(FieldValue fieldValue) {
            try {
                return JSON_VALUE_GETTERS.get((Object)fieldValue.typeName()).extractValue(fieldValue.jsonValue());
            }
            catch (RuntimeException e) {
                throw new UnsupportedRowJsonException("Unable to get value from field '" + fieldValue.name() + "'. Schema type '" + (Object)((Object)fieldValue.typeName()) + "'. JSON node type " + fieldValue.jsonNodeType().name(), e);
            }
        }

        @AutoValue
        static abstract class FieldValue {
            FieldValue() {
            }

            abstract String name();

            abstract Schema.FieldType type();

            abstract @Nullable JsonNode jsonValue();

            Schema.TypeName typeName() {
                return this.type().getTypeName();
            }

            boolean isJsonValuePresent() {
                return this.jsonValue() != null;
            }

            boolean isJsonNull() {
                return this.jsonValue().isNull();
            }

            JsonNodeType jsonNodeType() {
                return this.jsonValue().getNodeType();
            }

            boolean isJsonArray() {
                return this.jsonValue().isArray();
            }

            Stream<JsonNode> jsonArrayElements() {
                return StreamSupport.stream(this.jsonValue().spliterator(), false);
            }

            boolean isArrayType() {
                return Schema.TypeName.ARRAY.equals((Object)this.type().getTypeName()) || Schema.TypeName.ITERABLE.equals((Object)this.type().getTypeName());
            }

            Schema.FieldType arrayElementType() {
                return this.type().getCollectionElementType();
            }

            boolean isJsonObject() {
                return this.jsonValue().isObject();
            }

            JsonNode jsonFieldValue(String fieldName) {
                return this.jsonValue().get(fieldName);
            }

            boolean isRowType() {
                return Schema.TypeName.ROW.equals((Object)this.type().getTypeName());
            }

            Schema rowSchema() {
                return this.type().getRowSchema();
            }

            static FieldValue of(String name, Schema.FieldType type, JsonNode jsonValue) {
                return new AutoValue_RowJson_RowJsonDeserializer_FieldValue(name, type, jsonValue);
            }
        }

        public static enum NullBehavior {
            ACCEPT_MISSING_OR_NULL,
            REQUIRE_NULL,
            REQUIRE_MISSING;

        }
    }

    private static class UnsupportedField {
        final String descriptor;
        final Schema.TypeName typeName;

        UnsupportedField(String descriptor, Schema.TypeName typeName) {
            this.descriptor = descriptor;
            this.typeName = typeName;
        }

        public String toString() {
            return this.descriptor + "=" + (Object)((Object)this.typeName);
        }
    }
}

