/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.nullness.qual.Nullable;

@Internal
public class UnownedOutputStream
extends FilterOutputStream {
    public UnownedOutputStream(OutputStream delegate) {
        super(delegate);
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Caller does not own the underlying output stream  and should not call close().");
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof UnownedOutputStream && ((UnownedOutputStream)obj).out.equals(this.out);
    }

    public int hashCode() {
        return this.out.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(UnownedOutputStream.class).add("out", this.out).toString();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }
}

