/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p36p0.io.grpc.internal.testing;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.common.base.Charsets;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.common.base.Function;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.common.collect.Iterators;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.common.collect.Maps;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.Context;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.common.Scope;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.stats.Measure;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.stats.MeasureMap;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.stats.StatsRecorder;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.tags.Tag;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.tags.TagContext;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.tags.TagContextBuilder;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.tags.TagKey;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.tags.TagMetadata;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.tags.TagValue;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.tags.Tagger;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.tags.propagation.TagContextBinarySerializer;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.tags.propagation.TagContextDeserializationException;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.tags.unsafe.ContextUtils;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.trace.Annotation;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.trace.AttributeValue;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.trace.EndSpanOptions;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.trace.Link;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.trace.MessageEvent;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.trace.Sampler;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.trace.Span;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.trace.SpanBuilder;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.trace.SpanContext;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.trace.SpanId;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.trace.TraceId;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.trace.TraceOptions;

public class StatsTestUtils {
    public static final TagKey EXTRA_TAG = TagKey.create("/rpc/test/extratag");
    private static final String EXTRA_TAG_HEADER_VALUE_PREFIX = "extratag:";

    private StatsTestUtils() {
    }

    private static ImmutableMap<TagKey, TagValue> getTags(TagContext tags) {
        return tags instanceof FakeTagContext ? ((FakeTagContext)tags).getTags() : ImmutableMap.of();
    }

    public static class MockableSpan
    extends Span {
        public static MockableSpan generateRandomSpan(Random random) {
            return new MockableSpan(SpanContext.create(TraceId.generateRandomId(random), SpanId.generateRandomId(random), TraceOptions.DEFAULT), null);
        }

        @Override
        public void putAttributes(Map<String, AttributeValue> attributes) {
        }

        @Override
        public void addAnnotation(String description, Map<String, AttributeValue> attributes) {
        }

        @Override
        public void addAnnotation(Annotation annotation) {
        }

        @Override
        public void addMessageEvent(MessageEvent messageEvent) {
        }

        @Override
        public void addLink(Link link) {
        }

        @Override
        public void end(EndSpanOptions options) {
        }

        private MockableSpan(SpanContext context, @Nullable EnumSet<Span.Options> options) {
            super(context, options);
        }

        public static class Builder
        extends SpanBuilder {
            @Override
            public SpanBuilder setSampler(Sampler sampler) {
                return this;
            }

            @Override
            public SpanBuilder setParentLinks(List<Span> parentLinks) {
                return this;
            }

            @Override
            public SpanBuilder setRecordEvents(boolean recordEvents) {
                return this;
            }

            @Override
            public Span startSpan() {
                return null;
            }
        }
    }

    public static class FakeTagContextBuilder
    extends TagContextBuilder {
        private final Map<TagKey, TagValue> tagsBuilder = Maps.newHashMap();

        private FakeTagContextBuilder(Map<TagKey, TagValue> tags) {
            this.tagsBuilder.putAll(tags);
        }

        @Override
        public TagContextBuilder put(TagKey key, TagValue value) {
            this.tagsBuilder.put(key, value);
            return this;
        }

        @Override
        public TagContextBuilder remove(TagKey key) {
            this.tagsBuilder.remove(key);
            return this;
        }

        @Override
        public TagContext build() {
            FakeTagContext context = new FakeTagContext(ImmutableMap.copyOf(this.tagsBuilder));
            return context;
        }

        @Override
        public Scope buildScoped() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class FakeTagContext
    extends TagContext {
        private static final FakeTagContext EMPTY = new FakeTagContext(ImmutableMap.of());
        private static final TagMetadata METADATA_PROPAGATING = TagMetadata.create(TagMetadata.TagTtl.UNLIMITED_PROPAGATION);
        private final ImmutableMap<TagKey, TagValue> tags;

        private FakeTagContext(ImmutableMap<TagKey, TagValue> tags) {
            this.tags = tags;
        }

        public ImmutableMap<TagKey, TagValue> getTags() {
            return this.tags;
        }

        @Override
        public String toString() {
            return "[tags=" + this.tags + "]";
        }

        @Override
        protected Iterator<Tag> getIterator() {
            return Iterators.transform(((ImmutableSet)this.tags.entrySet()).iterator(), new Function<Map.Entry<TagKey, TagValue>, Tag>(){

                @Override
                public Tag apply(@Nullable Map.Entry<TagKey, TagValue> entry) {
                    return Tag.create(entry.getKey(), entry.getValue(), METADATA_PROPAGATING);
                }
            });
        }
    }

    public static final class FakeStatsRecord
    extends MeasureMap {
        private final BlockingQueue<MetricsRecord> recordSink;
        public final Map<Measure, Number> metrics = Maps.newHashMap();

        private FakeStatsRecord(FakeStatsRecorder statsRecorder) {
            this.recordSink = statsRecorder.getCurrentRecordSink();
        }

        @Override
        public MeasureMap put(Measure.MeasureDouble measure, double value) {
            this.metrics.put(measure, value);
            return this;
        }

        @Override
        public MeasureMap put(Measure.MeasureLong measure, long value) {
            this.metrics.put(measure, value);
            return this;
        }

        @Override
        public void record(TagContext tags) {
            this.recordSink.add(new MetricsRecord(StatsTestUtils.getTags(tags), ImmutableMap.copyOf(this.metrics)));
        }

        @Override
        public void record() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class FakeTagContextBinarySerializer
    extends TagContextBinarySerializer {
        private final FakeTagger tagger = new FakeTagger();

        @Override
        public TagContext fromByteArray(byte[] bytes) throws TagContextDeserializationException {
            String serializedString = new String(bytes, Charsets.UTF_8);
            if (serializedString.startsWith(StatsTestUtils.EXTRA_TAG_HEADER_VALUE_PREFIX)) {
                return this.tagger.emptyBuilder().putLocal(EXTRA_TAG, TagValue.create(serializedString.substring(StatsTestUtils.EXTRA_TAG_HEADER_VALUE_PREFIX.length()))).build();
            }
            throw new TagContextDeserializationException("Malformed value");
        }

        @Override
        public byte[] toByteArray(TagContext tags) {
            TagValue extraTagValue = (TagValue)StatsTestUtils.getTags(tags).get(EXTRA_TAG);
            if (extraTagValue == null) {
                throw new UnsupportedOperationException("TagContext must contain EXTRA_TAG");
            }
            return (StatsTestUtils.EXTRA_TAG_HEADER_VALUE_PREFIX + extraTagValue.asString()).getBytes(Charsets.UTF_8);
        }
    }

    public static final class FakeTagger
    extends Tagger {
        @Override
        public FakeTagContext empty() {
            return FakeTagContext.EMPTY;
        }

        @Override
        public TagContext getCurrentTagContext() {
            return ContextUtils.getValue(Context.current());
        }

        @Override
        public TagContextBuilder emptyBuilder() {
            return new FakeTagContextBuilder(ImmutableMap.of());
        }

        @Override
        public FakeTagContextBuilder toBuilder(TagContext tags) {
            return new FakeTagContextBuilder(StatsTestUtils.getTags(tags));
        }

        @Override
        public TagContextBuilder currentBuilder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Scope withTagContext(TagContext tags) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class FakeStatsRecorder
    extends StatsRecorder {
        private BlockingQueue<MetricsRecord> records;

        public FakeStatsRecorder() {
            this.rolloverRecords();
        }

        @Override
        public MeasureMap newMeasureMap() {
            return new FakeStatsRecord(this);
        }

        public MetricsRecord pollRecord() {
            return (MetricsRecord)this.getCurrentRecordSink().poll();
        }

        public MetricsRecord pollRecord(long timeout, TimeUnit unit) throws InterruptedException {
            return this.getCurrentRecordSink().poll(timeout, unit);
        }

        public synchronized void rolloverRecords() {
            this.records = new LinkedBlockingQueue<MetricsRecord>();
        }

        private synchronized BlockingQueue<MetricsRecord> getCurrentRecordSink() {
            return this.records;
        }
    }

    public static class MetricsRecord {
        public final ImmutableMap<TagKey, TagValue> tags;
        public final ImmutableMap<Measure, Number> metrics;

        private MetricsRecord(ImmutableMap<TagKey, TagValue> tags, ImmutableMap<Measure, Number> metrics) {
            this.tags = tags;
            this.metrics = metrics;
        }

        @Nullable
        public Double getMetric(Measure measure) {
            for (Map.Entry m3 : this.metrics.entrySet()) {
                if (!((Measure)m3.getKey()).equals(measure)) continue;
                Number value = (Number)m3.getValue();
                if (value instanceof Double) {
                    return (Double)value;
                }
                if (value instanceof Long) {
                    return (double)((Long)value);
                }
                throw new AssertionError((Object)("Unexpected measure value type: " + value.getClass().getName()));
            }
            return null;
        }

        public long getMetricAsLongOrFail(Measure measure) {
            Double doubleValue = this.getMetric(measure);
            Preconditions.checkNotNull(doubleValue, "Measure not found: %s", (Object)measure.getName());
            long longValue = (long)(Math.abs(doubleValue) + 1.0E-4);
            if (doubleValue < 0.0) {
                longValue = -longValue;
            }
            return longValue;
        }

        public String toString() {
            return "[tags=" + this.tags + ", metrics=" + this.metrics + "]";
        }
    }
}

