/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.control;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.fn.harness.control.AutoValue_ExecutionStateSampler_ExecutionStateTrackerStatus;
import org.apache.beam.fn.harness.control.BundleProgressReporter;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.core.metrics.MonitoringInfoEncodings;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.Histogram;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.options.ExecutorOptions;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionStateSampler {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ExecutionStateSampler.class);
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_SAMPLING_PERIOD_MS = 200;
    private static final @UnknownKeyFor @NonNull @Initialized long MAX_LULL_TIME_MS = TimeUnit.MINUTES.toMillis(5L);
    private static final @UnknownKeyFor @NonNull @Initialized PeriodFormatter DURATION_FORMATTER = new PeriodFormatterBuilder().appendDays().appendSuffix("d").minimumPrintedDigits(2).appendHours().appendSuffix("h").printZeroAlways().appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s").toFormatter();
    private final @UnknownKeyFor @NonNull @Initialized int periodMs;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DateTimeUtils.MillisProvider clock;
    @GuardedBy(value="activeStateTrackers")
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker> activeStateTrackers;
    private final @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @Nullable @Initialized Void> stateSamplingThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionStateSampler(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DateTimeUtils.MillisProvider clock) {
        String samplingPeriodMills = ExperimentalOptions.getExperimentValue((PipelineOptions)options, (String)"state_sampling_period_millis");
        this.periodMs = samplingPeriodMills == null ? 200 : Integer.parseInt(samplingPeriodMills);
        this.clock = clock;
        this.activeStateTrackers = new HashSet<ExecutionStateTracker>();
        ExecutionStateSampler executionStateSampler = this;
        synchronized (executionStateSampler) {
            this.stateSamplingThread = ((ExecutorOptions)options.as(ExecutorOptions.class)).getScheduledExecutorService().submit(this::stateSampler);
        }
    }

    public void stop() {
        this.stateSamplingThread.cancel(true);
        try {
            this.stateSamplingThread.get(5L * (long)this.periodMs, TimeUnit.MILLISECONDS);
        }
        catch (CancellationException cancellationException) {
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Failed to stop state sampling after waiting 5 sampling periods.", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Exception in state sampler", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @UnknownKeyFor @Nullable @Initialized Void stateSampler() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ExecutionStateSampler executionStateSampler = this;
        synchronized (executionStateSampler) {
            if (this.stateSamplingThread == null) {
                throw new IllegalStateException("Underinitialized ExecutionStateSampler instance");
            }
        }
        long lastSampleTimeMillis = this.clock.getMillis();
        long targetTimeMillis = lastSampleTimeMillis + (long)this.periodMs;
        while (!Thread.interrupted()) {
            long currentTimeMillis = this.clock.getMillis();
            long difference = targetTimeMillis - currentTimeMillis;
            if (difference > 0L) {
                Thread.sleep(difference);
                continue;
            }
            long millisSinceLastSample = currentTimeMillis - lastSampleTimeMillis;
            Set<ExecutionStateTracker> set = this.activeStateTrackers;
            synchronized (set) {
                for (ExecutionStateTracker activeTracker : this.activeStateTrackers) {
                    activeTracker.takeSample(currentTimeMillis, millisSinceLastSample);
                }
            }
            lastSampleTimeMillis = currentTimeMillis;
            targetTimeMillis = lastSampleTimeMillis + (long)this.periodMs;
        }
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker create() {
        return new ExecutionStateTracker();
    }

    @AutoValue
    public static abstract class ExecutionStateTrackerStatus {
        public static @UnknownKeyFor @NonNull @Initialized ExecutionStateTrackerStatus create(@Nullable @UnknownKeyFor @Initialized String ptransformId, @Nullable @UnknownKeyFor @Initialized String ptransformUniqueName, @UnknownKeyFor @NonNull @Initialized Thread trackedThread, @UnknownKeyFor @NonNull @Initialized long lastTransitionTimeMs, @Nullable @UnknownKeyFor @Initialized String processBundleId) {
            return new AutoValue_ExecutionStateSampler_ExecutionStateTrackerStatus(ptransformId, ptransformUniqueName, trackedThread, lastTransitionTimeMs, processBundleId);
        }

        public abstract @Nullable @UnknownKeyFor @Initialized String getPTransformId();

        public abstract @Nullable @UnknownKeyFor @Initialized String getPTransformUniqueName();

        public abstract @UnknownKeyFor @NonNull @Initialized Thread getTrackedThread();

        public abstract @UnknownKeyFor @NonNull @Initialized long getLastTransitionTimeMillis();

        public abstract @Nullable @UnknownKeyFor @Initialized String getProcessBundleId();
    }

    public class ExecutionStateTracker
    implements BundleProgressReporter {
        private final @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap metricsContainerRegistry = new MetricsContainerStepMap();
        private final @UnknownKeyFor @NonNull @Initialized MetricsContainer metricsContainer;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker. @UnknownKeyFor @NonNull @Initialized ExecutionStateImpl> executionStates = new ArrayList<ExecutionStateImpl>();
        private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@Nullable @UnknownKeyFor @Initialized String> processBundleId;
        private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@Nullable @UnknownKeyFor @Initialized Thread> trackedThread = new AtomicReference();
        private final @UnknownKeyFor @NonNull @Initialized AtomicLong lastTransitionTime = new AtomicLong();
        private @UnknownKeyFor @NonNull @Initialized long numTransitions;
        private final @UnknownKeyFor @NonNull @Initialized AtomicLong numTransitionsLazy = new AtomicLong();
        private @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker. @Nullable @UnknownKeyFor @Initialized ExecutionStateImpl currentState;
        private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker. @Nullable @UnknownKeyFor @Initialized ExecutionStateImpl> currentStateLazy = new AtomicReference();
        private @UnknownKeyFor @NonNull @Initialized long transitionsAtLastSample;

        private ExecutionStateTracker() {
            this.processBundleId = new AtomicReference();
            this.metricsContainer = new MetricsContainerForTracker(this);
        }

        public @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap getMetricsContainerRegistry() {
            return this.metricsContainerRegistry;
        }

        public @UnknownKeyFor @NonNull @Initialized MetricsContainer getMetricsContainer() {
            return this.metricsContainer;
        }

        public @UnknownKeyFor @NonNull @Initialized ExecutionState create(@UnknownKeyFor @NonNull @Initialized String shortId, @UnknownKeyFor @NonNull @Initialized String ptransformId, @UnknownKeyFor @NonNull @Initialized String ptransformUniqueName, @UnknownKeyFor @NonNull @Initialized String stateName) {
            ExecutionStateImpl newState = new ExecutionStateImpl(shortId, ptransformId, ptransformUniqueName, stateName, this.metricsContainerRegistry.getContainer(ptransformId));
            this.executionStates.add(newState);
            return newState;
        }

        private void takeSample(@UnknownKeyFor @NonNull @Initialized long currentTimeMillis, @UnknownKeyFor @NonNull @Initialized long millisSinceLastSample) {
            long transitionsAtThisSample;
            ExecutionStateImpl currentExecutionState = this.currentStateLazy.get();
            if (currentExecutionState != null) {
                currentExecutionState.takeSample(millisSinceLastSample);
            }
            if ((transitionsAtThisSample = this.numTransitionsLazy.get()) != this.transitionsAtLastSample) {
                this.lastTransitionTime.lazySet(currentTimeMillis);
                this.transitionsAtLastSample = transitionsAtThisSample;
            } else {
                long lullTimeMs = currentTimeMillis - this.lastTransitionTime.get();
                Thread thread = this.trackedThread.get();
                if (lullTimeMs > MAX_LULL_TIME_MS) {
                    if (thread == null) {
                        LOG.warn(String.format("Operation ongoing in bundle %s for at least %s without outputting or completing (stack trace unable to be generated).", this.processBundleId.get(), DURATION_FORMATTER.print((ReadablePeriod)Duration.millis((long)lullTimeMs).toPeriod())));
                    } else if (currentExecutionState == null) {
                        LOG.warn(String.format("Operation ongoing in bundle %s for at least %s without outputting or completing:%n  at %s", this.processBundleId.get(), DURATION_FORMATTER.print((ReadablePeriod)Duration.millis((long)lullTimeMs).toPeriod()), Joiner.on((String)"\n  at ").join((Object[])thread.getStackTrace())));
                    } else {
                        LOG.warn(String.format("Operation ongoing in bundle %s for PTransform{id=%s, name=%s, state=%s} for at least %s without outputting or completing:%n  at %s", this.processBundleId.get(), currentExecutionState.ptransformId, currentExecutionState.ptransformUniqueName, currentExecutionState.stateName, DURATION_FORMATTER.print((ReadablePeriod)Duration.millis((long)lullTimeMs).toPeriod()), Joiner.on((String)"\n  at ").join((Object[])thread.getStackTrace())));
                    }
                }
            }
        }

        public @Nullable @UnknownKeyFor @Initialized ExecutionStateTrackerStatus getStatus() {
            Thread thread = this.trackedThread.get();
            if (thread == null) {
                return null;
            }
            long lastTransitionTimeMs = this.lastTransitionTime.get();
            ExecutionStateImpl current = this.currentStateLazy.get();
            if (current != null) {
                return ExecutionStateTrackerStatus.create(current.ptransformId, current.ptransformUniqueName, thread, lastTransitionTimeMs, this.processBundleId.get());
            }
            return ExecutionStateTrackerStatus.create(null, null, thread, lastTransitionTimeMs, this.processBundleId.get());
        }

        public @Nullable @UnknownKeyFor @Initialized String getCurrentThreadsPTransformId() {
            if (this.currentState == null) {
                return null;
            }
            return this.currentState.ptransformId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(@UnknownKeyFor @NonNull @Initialized String processBundleId) {
            this.processBundleId.lazySet(processBundleId);
            this.lastTransitionTime.lazySet(ExecutionStateSampler.this.clock.getMillis());
            this.trackedThread.lazySet(Thread.currentThread());
            Set set = ExecutionStateSampler.this.activeStateTrackers;
            synchronized (set) {
                ExecutionStateSampler.this.activeStateTrackers.add(this);
            }
        }

        @Override
        public void updateIntermediateMonitoringData(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> monitoringData) {
            for (ExecutionStateImpl executionState : this.executionStates) {
                executionState.updateMonitoringData(monitoringData);
            }
        }

        @Override
        public void updateFinalMonitoringData(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> monitoringData) {
            for (ExecutionStateImpl executionState : this.executionStates) {
                executionState.updateMonitoringData(monitoringData);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            Set set = ExecutionStateSampler.this.activeStateTrackers;
            synchronized (set) {
                ExecutionStateSampler.this.activeStateTrackers.remove(this);
                for (ExecutionStateImpl executionState : this.executionStates) {
                    executionState.reset();
                }
                this.transitionsAtLastSample = 0L;
            }
            this.processBundleId.lazySet(null);
            this.trackedThread.lazySet(null);
            this.numTransitions = 0L;
            this.numTransitionsLazy.lazySet(0L);
            this.lastTransitionTime.lazySet(0L);
            this.metricsContainerRegistry.reset();
        }

        private class ExecutionStateImpl
        implements ExecutionState {
            private final @UnknownKeyFor @NonNull @Initialized String shortId;
            private final @UnknownKeyFor @NonNull @Initialized String ptransformId;
            private final @UnknownKeyFor @NonNull @Initialized String ptransformUniqueName;
            private final @UnknownKeyFor @NonNull @Initialized String stateName;
            private final @UnknownKeyFor @NonNull @Initialized MetricsContainer metricsContainer;
            private @UnknownKeyFor @NonNull @Initialized long msecs;
            private final @UnknownKeyFor @NonNull @Initialized AtomicLong lazyMsecs;
            private @UnknownKeyFor @NonNull @Initialized boolean hasReportedValue;
            private @UnknownKeyFor @NonNull @Initialized long lastReportedValue;
            private @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker. @Nullable @UnknownKeyFor @Initialized ExecutionStateImpl previousState;

            private ExecutionStateImpl(@UnknownKeyFor @NonNull @Initialized String shortId, @UnknownKeyFor @NonNull @Initialized String ptransformId, @UnknownKeyFor @NonNull @Initialized String ptransformName, @UnknownKeyFor @NonNull @Initialized String stateName, MetricsContainer metricsContainer) {
                this.shortId = shortId;
                this.ptransformId = ptransformId;
                this.ptransformUniqueName = ptransformName;
                this.stateName = stateName;
                this.metricsContainer = metricsContainer;
                this.lazyMsecs = new AtomicLong();
            }

            public void takeSample(@UnknownKeyFor @NonNull @Initialized long millisSinceLastSample) {
                this.msecs += millisSinceLastSample;
                this.lazyMsecs.set(this.msecs);
            }

            public void updateMonitoringData(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> monitoringData) {
                long msecsReads = this.lazyMsecs.get();
                if (this.hasReportedValue && this.lastReportedValue == msecsReads) {
                    return;
                }
                monitoringData.put(this.shortId, MonitoringInfoEncodings.encodeInt64Counter(msecsReads));
                this.lastReportedValue = msecsReads;
                this.hasReportedValue = true;
            }

            public void reset() {
                if (this.hasReportedValue) {
                    this.msecs = 0L;
                    this.lazyMsecs.set(0L);
                    this.lastReportedValue = 0L;
                }
            }

            @Override
            public void activate() {
                this.previousState = ExecutionStateTracker.this.currentState;
                ExecutionStateTracker.this.currentState = this;
                ExecutionStateTracker.this.currentStateLazy.lazySet(this);
                ExecutionStateTracker.this.numTransitions += 1L;
                ExecutionStateTracker.this.numTransitionsLazy.lazySet(ExecutionStateTracker.this.numTransitions);
            }

            @Override
            public void deactivate() {
                ExecutionStateTracker.this.currentState = this.previousState;
                ExecutionStateTracker.this.currentStateLazy.lazySet(this.previousState);
                this.previousState = null;
                ExecutionStateTracker.this.numTransitions += 1L;
                ExecutionStateTracker.this.numTransitionsLazy.lazySet(ExecutionStateTracker.this.numTransitions);
            }
        }
    }

    private static class MetricsContainerForTracker
    implements MetricsContainer {
        private final transient @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker tracker;

        private MetricsContainerForTracker(@UnknownKeyFor @NonNull @Initialized ExecutionStateSampler. @UnknownKeyFor @NonNull @Initialized ExecutionStateTracker tracker) {
            this.tracker = tracker;
        }

        public @UnknownKeyFor @NonNull @Initialized Counter getCounter(@UnknownKeyFor @NonNull @Initialized MetricName metricName) {
            if (this.tracker.currentState != null) {
                return this.tracker.currentState.metricsContainer.getCounter(metricName);
            }
            return this.tracker.metricsContainerRegistry.getUnboundContainer().getCounter(metricName);
        }

        public @UnknownKeyFor @NonNull @Initialized Distribution getDistribution(@UnknownKeyFor @NonNull @Initialized MetricName metricName) {
            if (this.tracker.currentState != null) {
                return this.tracker.currentState.metricsContainer.getDistribution(metricName);
            }
            return this.tracker.metricsContainerRegistry.getUnboundContainer().getDistribution(metricName);
        }

        public @UnknownKeyFor @NonNull @Initialized Gauge getGauge(@UnknownKeyFor @NonNull @Initialized MetricName metricName) {
            if (this.tracker.currentState != null) {
                return this.tracker.currentState.metricsContainer.getGauge(metricName);
            }
            return this.tracker.metricsContainerRegistry.getUnboundContainer().getGauge(metricName);
        }

        public @UnknownKeyFor @NonNull @Initialized Histogram getHistogram(@UnknownKeyFor @NonNull @Initialized MetricName metricName, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized HistogramData.BucketType bucketType) {
            if (this.tracker.currentState != null) {
                return this.tracker.currentState.metricsContainer.getHistogram(metricName, bucketType);
            }
            return this.tracker.metricsContainerRegistry.getUnboundContainer().getHistogram(metricName, bucketType);
        }

        public @UnknownKeyFor @NonNull @Initialized Iterable<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo> getMonitoringInfos() {
            if (this.tracker.currentState != null) {
                return this.tracker.currentState.metricsContainer.getMonitoringInfos();
            }
            return this.tracker.metricsContainerRegistry.getUnboundContainer().getMonitoringInfos();
        }
    }

    public static interface ExecutionState {
        public void activate();

        public void deactivate();
    }
}

