/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.Caches;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.StateFetchingIterators;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.stream.PrefetchableIterable;
import org.apache.beam.sdk.fn.stream.PrefetchableIterables;
import org.apache.beam.sdk.fn.stream.PrefetchableIterator;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class MultimapUserState<@UnknownKeyFor K, @UnknownKeyFor V> {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cache;
    private final @UnknownKeyFor @NonNull @Initialized BeamFnStateClient beamFnStateClient;
    private final @UnknownKeyFor @NonNull @Initialized Coder<K> mapKeyCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;
    private final  @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest keysStateRequest;
    private final  @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest userStateRequest;
    private final @UnknownKeyFor @NonNull @Initialized StateFetchingIterators.CachingStateIterable<K> persistedKeys;
    private @UnknownKeyFor @NonNull @Initialized boolean isClosed;
    private @UnknownKeyFor @NonNull @Initialized boolean isCleared;
    private @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized Object, K> pendingRemoves = Maps.newHashMap();
    private @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized List<V>>> pendingAdds = Maps.newHashMap();
    private @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized StateFetchingIterators.CachingStateIterable<V>>> persistedValues = Maps.newHashMap();

    public MultimapUserState(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cache, @UnknownKeyFor @NonNull @Initialized BeamFnStateClient beamFnStateClient, @UnknownKeyFor @NonNull @Initialized String instructionId,  @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateKey stateKey, @UnknownKeyFor @NonNull @Initialized Coder<K> mapKeyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        Preconditions.checkArgument((boolean)stateKey.hasMultimapKeysUserState(), (String)"Expected MultimapKeysUserState StateKey but received %s.", (Object)stateKey);
        this.cache = cache;
        this.beamFnStateClient = beamFnStateClient;
        this.mapKeyCoder = mapKeyCoder;
        this.valueCoder = valueCoder;
        this.keysStateRequest = BeamFnApi.StateRequest.newBuilder().setInstructionId(instructionId).setStateKey(stateKey).build();
        this.persistedKeys = StateFetchingIterators.readAllAndDecodeStartingFrom(cache, beamFnStateClient, this.keysStateRequest, mapKeyCoder);
        BeamFnApi.StateRequest.Builder userStateRequestBuilder = BeamFnApi.StateRequest.newBuilder();
        userStateRequestBuilder.setInstructionId(instructionId).getStateKeyBuilder().getMultimapUserStateBuilder().setTransformId(stateKey.getMultimapKeysUserState().getTransformId()).setUserStateId(stateKey.getMultimapKeysUserState().getUserStateId()).setWindow(stateKey.getMultimapKeysUserState().getWindow()).setKey(stateKey.getMultimapKeysUserState().getKey());
        this.userStateRequest = userStateRequestBuilder.build();
    }

    public void clear() {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"Multimap user state is no longer usable because it is closed for %s", (Object)this.keysStateRequest.getStateKey());
        this.isCleared = true;
        this.persistedValues = Maps.newHashMap();
        this.pendingRemoves = Maps.newHashMap();
        this.pendingAdds = Maps.newHashMap();
    }

    public @UnknownKeyFor @NonNull @Initialized PrefetchableIterable<V> get(K key) {
        PrefetchableIterable<Object> pendingValues;
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"Multimap user state is no longer usable because it is closed for %s", (Object)this.keysStateRequest.getStateKey());
        Object structuralKey = this.mapKeyCoder.structuralValue(key);
        KV<K, List<V>> pendingAddValues = this.pendingAdds.get(structuralKey);
        PrefetchableIterable<Object> prefetchableIterable = pendingValues = pendingAddValues == null ? PrefetchableIterables.fromArray(new Object[0]) : PrefetchableIterables.limit((Iterable)pendingAddValues.getValue(), ((List)pendingAddValues.getValue()).size());
        if (this.isCleared || this.pendingRemoves.containsKey(structuralKey)) {
            return pendingValues;
        }
        return PrefetchableIterables.concat(this.getPersistedValues(structuralKey, key), pendingValues);
    }

    public @UnknownKeyFor @NonNull @Initialized PrefetchableIterable<K> keys() {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"Multimap user state is no longer usable because it is closed for %s", (Object)this.keysStateRequest.getStateKey());
        if (this.isCleared) {
            ArrayList<Object> keys = new ArrayList<Object>(this.pendingAdds.size());
            for (Map.Entry<Object, KV<K, List<V>>> entry : this.pendingAdds.entrySet()) {
                keys.add(entry.getValue().getKey());
            }
            return PrefetchableIterables.concat(keys);
        }
        final HashSet<Object> pendingRemovesNow = new HashSet<Object>(this.pendingRemoves.keySet());
        final HashMap<Object, Object> pendingAddsNow = new HashMap<Object, Object>();
        for (Map.Entry<Object, KV<K, List<V>>> entry : this.pendingAdds.entrySet()) {
            pendingAddsNow.put(entry.getKey(), entry.getValue().getKey());
        }
        return new PrefetchableIterables.Default<K>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<K> createIterator() {
                return new PrefetchableIterator<K>(){
                    @UnknownKeyFor @NonNull @Initialized PrefetchableIterator<K> persistedKeysIterator;
                    @UnknownKeyFor @NonNull @Initialized Iterator<K> pendingAddsNowIterator;
                    @UnknownKeyFor @NonNull @Initialized boolean hasNext;
                    K nextKey;
                    {
                        this.persistedKeysIterator = MultimapUserState.this.persistedKeys.iterator();
                    }

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized boolean isReady() {
                        return this.persistedKeysIterator.isReady();
                    }

                    @Override
                    public void prefetch() {
                        if (!this.isReady()) {
                            this.persistedKeysIterator.prefetch();
                        }
                    }

                    @Override
                    @Pure
                    public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
                        if (this.hasNext) {
                            return true;
                        }
                        while (this.persistedKeysIterator.hasNext()) {
                            this.nextKey = this.persistedKeysIterator.next();
                            Object nextKeyStructuralValue = MultimapUserState.this.mapKeyCoder.structuralValue(this.nextKey);
                            if (pendingRemovesNow.contains(nextKeyStructuralValue)) continue;
                            if (pendingAddsNow.containsKey(nextKeyStructuralValue)) {
                                pendingAddsNow.remove(nextKeyStructuralValue);
                            }
                            this.hasNext = true;
                            return true;
                        }
                        if (this.pendingAddsNowIterator == null) {
                            this.pendingAddsNowIterator = pendingAddsNow.values().iterator();
                        }
                        if (this.pendingAddsNowIterator.hasNext()) {
                            this.nextKey = this.pendingAddsNowIterator.next();
                            this.hasNext = true;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public K next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.hasNext = false;
                        return this.nextKey;
                    }
                };
            }
        };
    }

    public void put(K key, V value) {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"Multimap user state is no longer usable because it is closed for %s", (Object)this.keysStateRequest.getStateKey());
        Object keyStructuralValue = this.mapKeyCoder.structuralValue(key);
        this.pendingAdds.putIfAbsent(keyStructuralValue, KV.of(key, new ArrayList()));
        ((List)this.pendingAdds.get(keyStructuralValue).getValue()).add(value);
    }

    public void remove(K key) {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"Multimap user state is no longer usable because it is closed for %s", (Object)this.keysStateRequest.getStateKey());
        Object keyStructuralValue = this.mapKeyCoder.structuralValue(key);
        this.pendingAdds.remove(keyStructuralValue);
        if (!this.isCleared) {
            this.pendingRemoves.put(keyStructuralValue, key);
        }
    }

    public void asyncClose() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"Multimap user state is no longer usable because it is closed for %s", (Object)this.keysStateRequest.getStateKey());
        this.isClosed = true;
        if (!this.isCleared && this.pendingRemoves.isEmpty() && this.pendingAdds.isEmpty()) {
            return;
        }
        this.startStateApiWrites();
        this.updateCache();
    }

    private void startStateApiWrites() {
        BeamFnApi.StateRequest request;
        if (this.isCleared) {
            this.beamFnStateClient.handle(this.keysStateRequest.toBuilder().setClear(BeamFnApi.StateClearRequest.getDefaultInstance()));
        } else if (!this.pendingRemoves.isEmpty()) {
            for (K k : this.pendingRemoves.values()) {
                request = this.createUserStateRequest(k);
                this.beamFnStateClient.handle(request.toBuilder().setClear(BeamFnApi.StateClearRequest.getDefaultInstance()));
            }
        }
        if (!this.pendingAdds.isEmpty()) {
            for (KV kV : this.pendingAdds.values()) {
                request = this.createUserStateRequest(kV.getKey());
                this.beamFnStateClient.handle(request.toBuilder().setAppend(BeamFnApi.StateAppendRequest.newBuilder().setData(this.encodeValues((Iterable)kV.getValue()))));
            }
        }
    }

    private void updateCache() {
        ArrayList<Object> pendingAddsKeys = new ArrayList<Object>(this.pendingAdds.size());
        for (KV<K, List<V>> kV : this.pendingAdds.values()) {
            pendingAddsKeys.add(kV.getKey());
        }
        if (this.isCleared) {
            this.persistedKeys.clearAndAppend(pendingAddsKeys);
            for (Map.Entry entry : this.pendingAdds.entrySet()) {
                StateFetchingIterators.CachingStateIterable<V> iterable = this.getPersistedValues(entry.getKey(), ((KV)entry.getValue()).getKey());
                iterable.clearAndAppend((List)((KV)entry.getValue()).getValue());
            }
        } else {
            this.persistedKeys.remove(this.pendingRemoves.keySet());
            this.persistedKeys.append(pendingAddsKeys);
            for (Map.Entry entry : this.pendingRemoves.entrySet()) {
                StateFetchingIterators.CachingStateIterable<V> iterable = this.getPersistedValues(entry.getKey(), entry.getValue());
                iterable.clearAndAppend(Collections.emptyList());
            }
            for (Map.Entry entry : this.pendingAdds.entrySet()) {
                KV<K, StateFetchingIterators.CachingStateIterable<V>> value = this.persistedValues.get(entry.getKey());
                if (value == null) continue;
                ((StateFetchingIterators.CachingStateIterable)value.getValue()).append((List)((KV)entry.getValue()).getValue());
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized ByteString encodeValues(@UnknownKeyFor @NonNull @Initialized Iterable<V> values) {
        try {
            ByteStringOutputStream output = new ByteStringOutputStream();
            for (V value : values) {
                this.valueCoder.encode(value, (OutputStream)output);
            }
            return output.toByteString();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to encode values for multimap user state id %s.", this.keysStateRequest.getStateKey().getMultimapKeysUserState().getUserStateId()), e);
        }
    }

    private  @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest createUserStateRequest(K key) {
        try {
            ByteStringOutputStream output = new ByteStringOutputStream();
            this.mapKeyCoder.encode(key, (OutputStream)output);
            BeamFnApi.StateRequest.Builder request = this.userStateRequest.toBuilder();
            request.getStateKeyBuilder().getMultimapUserStateBuilder().setMapKey(output.toByteString());
            return request.build();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to encode key for multimap user state id %s.", this.keysStateRequest.getStateKey().getMultimapKeysUserState().getUserStateId()), e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized StateFetchingIterators.CachingStateIterable<V> getPersistedValues(@UnknownKeyFor @NonNull @Initialized Object structuralKey, K key) {
        return (StateFetchingIterators.CachingStateIterable)this.persistedValues.computeIfAbsent(structuralKey, unused -> {
            BeamFnApi.StateRequest request = this.createUserStateRequest(key);
            return KV.of((Object)key, StateFetchingIterators.readAllAndDecodeStartingFrom(Caches.subCache(this.cache, "ValuesForKey", request.getStateKey().getMultimapUserState().getMapKey()), this.beamFnStateClient, request, this.valueCoder));
        }).getValue();
    }
}

