/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.test;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ForwardingExecutorService;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestExecutors {
    public static @UnknownKeyFor @NonNull @Initialized TestExecutorService from(@UnknownKeyFor @NonNull @Initialized ExecutorService staticExecutorService) {
        return TestExecutors.from(() -> staticExecutorService);
    }

    public static @UnknownKeyFor @NonNull @Initialized TestExecutorService from(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized ExecutorService> executorServiceSuppler) {
        return new FromSupplier(executorServiceSuppler);
    }

    private static class FromSupplier
    extends ForwardingExecutorService
    implements TestExecutorService {
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized ExecutorService> executorServiceSupplier;
        private @UnknownKeyFor @NonNull @Initialized ExecutorService delegate;

        private FromSupplier(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized ExecutorService> executorServiceSupplier) {
            this.executorServiceSupplier = executorServiceSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Statement apply(final @UnknownKeyFor @NonNull @Initialized Statement statement, @UnknownKeyFor @NonNull @Initialized Description arg1) {
            return new Statement(){

                @Override
                public void evaluate() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                    Throwable thrown = null;
                    delegate = (ExecutorService)executorServiceSupplier.get();
                    try {
                        statement.evaluate();
                    }
                    catch (Throwable t2) {
                        thrown = t2;
                    }
                    this.shutdown();
                    if (!this.awaitTermination(5L, TimeUnit.SECONDS)) {
                        this.shutdownNow();
                        IllegalStateException e = new IllegalStateException("Test executor failed to shutdown cleanly.");
                        if (thrown != null) {
                            thrown.addSuppressed(e);
                        } else {
                            thrown = e;
                        }
                    }
                    if (thrown != null) {
                        throw thrown;
                    }
                }
            };
        }

        protected @UnknownKeyFor @NonNull @Initialized ExecutorService delegate() {
            return this.delegate;
        }
    }

    public static interface TestExecutorService
    extends ExecutorService,
    TestRule {
    }
}

