/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface BundleProgressReporter {
    public void updateIntermediateMonitoringData(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> var1);

    public void updateFinalMonitoringData(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> var1);

    public void reset();

    @NotThreadSafe
    public static class InMemory
    implements BundleProgressReporter,
    Registrar {
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BundleProgressReporter> reporters = new ArrayList<BundleProgressReporter>();

        @Override
        public void register(@UnknownKeyFor @NonNull @Initialized BundleProgressReporter reporter) {
            if (this.reporters.contains(reporter)) {
                throw new IllegalStateException(reporter + " was being added multiple times.");
            }
            this.reporters.add(reporter);
        }

        @Override
        public void updateIntermediateMonitoringData(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> monitoringData) {
            for (BundleProgressReporter reporter : this.reporters) {
                reporter.updateIntermediateMonitoringData(monitoringData);
            }
        }

        @Override
        public void updateFinalMonitoringData(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> monitoringData) {
            for (BundleProgressReporter reporter : this.reporters) {
                reporter.updateFinalMonitoringData(monitoringData);
            }
        }

        @Override
        public void reset() {
            for (BundleProgressReporter reporter : this.reporters) {
                reporter.reset();
            }
        }
    }

    public static interface Registrar {
        public void register(@UnknownKeyFor @NonNull @Initialized BundleProgressReporter var1);
    }
}

