/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Map;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FlattenRunner<@UnknownKeyFor InputT> {

    static class Factory<@UnknownKeyFor InputT>
    implements PTransformRunnerFactory<FlattenRunner<InputT>> {
        Factory() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FlattenRunner<InputT> createRunnerForPTransform(@UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String output = (String)Iterables.getOnlyElement(context.getPTransform().getOutputsMap().values());
            FnDataReceiver receiver = context.getPCollectionConsumer(output);
            FlattenRunner runner = new FlattenRunner();
            for (String pCollectionId : context.getPTransform().getInputsMap().values()) {
                context.addPCollectionConsumer(pCollectionId, receiver);
            }
            return runner;
        }
    }

    @AutoService(value={PTransformRunnerFactory.Registrar.class})
    public static class Registrar
    implements PTransformRunnerFactory.Registrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory> getPTransformRunnerFactories() {
            return ImmutableMap.of((Object)"beam:transform:flatten:v1", new Factory());
        }
    }
}

