/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.core.construction.PTransformReplacements;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.sdk.fn.splittabledofn.RestrictionTrackers;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerMap;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.Uninterruptibles;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

public class SplittableParDoNaiveBounded {

    public static class NaiveProcessFn<InputT, OutputT, RestrictionT, PositionT, WatermarkEstimatorStateT>
    extends DoFn<KV<InputT, RestrictionT>, OutputT> {
        private final DoFn<InputT, OutputT> fn;
        private final Map<String, PCollectionView<?>> sideInputMapping;
        private transient @Nullable DoFnInvoker<InputT, OutputT> invoker;

        NaiveProcessFn(DoFn<InputT, OutputT> fn, Map<String, PCollectionView<?>> sideInputMapping) {
            this.fn = fn;
            this.sideInputMapping = sideInputMapping;
        }

        @DoFn.Setup
        public void setup(final PipelineOptions options) {
            this.invoker = DoFnInvokers.invokerFor(this.fn);
            this.invoker.invokeSetup((DoFnInvoker.ArgumentProvider)new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                public PipelineOptions pipelineOptions() {
                    return options;
                }

                public String getErrorContext() {
                    return "SplittableParDoNaiveBounded/Setup";
                }
            });
        }

        @DoFn.StartBundle
        public void startBundle(final DoFn.StartBundleContext c) {
            this.invoker.invokeStartBundle((DoFnInvoker.ArgumentProvider)new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
                    return new DoFn.StartBundleContext(){

                        public PipelineOptions getPipelineOptions() {
                            return c.getPipelineOptions();
                        }
                    };
                }

                public PipelineOptions pipelineOptions() {
                    return c.getPipelineOptions();
                }

                public String getErrorContext() {
                    return "SplittableParDoNaiveBounded/StartBundle";
                }
            });
        }

        @DoFn.ProcessElement
        public void process(final DoFn.ProcessContext c, final BoundedWindow w) {
            Object initialWatermarkEstimatorState = this.invoker.invokeGetInitialWatermarkEstimatorState((DoFnInvoker.ArgumentProvider)new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                public InputT element(DoFn<InputT, OutputT> doFn) {
                    return ((KV)c.element()).getKey();
                }

                public Object restriction() {
                    return ((KV)c.element()).getValue();
                }

                public Instant timestamp(DoFn<InputT, OutputT> doFn) {
                    return c.timestamp();
                }

                public PipelineOptions pipelineOptions() {
                    return c.getPipelineOptions();
                }

                public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
                    return c.pane();
                }

                public BoundedWindow window() {
                    return w;
                }

                public Object sideInput(String tagId) {
                    PCollectionView view = (PCollectionView)sideInputMapping.get(tagId);
                    if (view == null) {
                        throw new IllegalArgumentException("calling getSideInput() with unknown view");
                    }
                    return c.sideInput(view);
                }

                public String getErrorContext() {
                    return NaiveProcessFn.class.getSimpleName() + ".invokeGetInitialWatermarkEstimatorState";
                }
            });
            Object restriction = ((KV)c.element()).getValue();
            Object watermarkEstimatorState = initialWatermarkEstimatorState;
            while (true) {
                final Object currentRestriction = restriction;
                final Object currentWatermarkEstimatorState = watermarkEstimatorState;
                RestrictionTracker tracker = RestrictionTrackers.observe(this.invoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                    public InputT element(DoFn<InputT, OutputT> doFn) {
                        return ((KV)c.element()).getKey();
                    }

                    public RestrictionT restriction() {
                        return currentRestriction;
                    }

                    public Instant timestamp(DoFn<InputT, OutputT> doFn) {
                        return c.timestamp();
                    }

                    public PipelineOptions pipelineOptions() {
                        return c.getPipelineOptions();
                    }

                    public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
                        return c.pane();
                    }

                    public BoundedWindow window() {
                        return w;
                    }

                    public Object sideInput(String tagId) {
                        PCollectionView view = (PCollectionView)sideInputMapping.get(tagId);
                        if (view == null) {
                            throw new IllegalArgumentException("calling getSideInput() with unknown view");
                        }
                        return c.sideInput(view);
                    }

                    public String getErrorContext() {
                        return NaiveProcessFn.class.getSimpleName() + ".invokeNewTracker";
                    }
                }), new RestrictionTrackers.ClaimObserver<PositionT>(){

                    @Override
                    public void onClaimed(PositionT position) {
                    }

                    @Override
                    public void onClaimFailed(PositionT position) {
                    }
                });
                WatermarkEstimator watermarkEstimator = this.invoker.invokeNewWatermarkEstimator((DoFnInvoker.ArgumentProvider)new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                    public InputT element(DoFn<InputT, OutputT> doFn) {
                        return ((KV)c.element()).getKey();
                    }

                    public RestrictionT restriction() {
                        return currentRestriction;
                    }

                    public WatermarkEstimatorStateT watermarkEstimatorState() {
                        return currentWatermarkEstimatorState;
                    }

                    public Instant timestamp(DoFn<InputT, OutputT> doFn) {
                        return c.timestamp();
                    }

                    public PipelineOptions pipelineOptions() {
                        return c.getPipelineOptions();
                    }

                    public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
                        return c.pane();
                    }

                    public BoundedWindow window() {
                        return w;
                    }

                    public Object sideInput(String tagId) {
                        PCollectionView view = (PCollectionView)sideInputMapping.get(tagId);
                        if (view == null) {
                            throw new IllegalArgumentException("calling getSideInput() with unknown view");
                        }
                        return c.sideInput(view);
                    }

                    public String getErrorContext() {
                        return NaiveProcessFn.class.getSimpleName() + ".invokeNewWatermarkEstimator";
                    }
                });
                DoFn.ProcessContinuation continuation = this.invoker.invokeProcessElement(new NestedProcessContext(this.fn, c, ((KV)c.element()).getKey(), w, tracker, watermarkEstimator, this.sideInputMapping, null));
                if (!continuation.shouldResume()) break;
                watermarkEstimatorState = watermarkEstimator.getState();
                SplitResult split = tracker.trySplit(0.0);
                if (split == null) break;
                restriction = split.getResidual();
                Uninterruptibles.sleepUninterruptibly((long)continuation.resumeDelay().getMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }

        @DoFn.FinishBundle
        public void finishBundle(final DoFn.FinishBundleContext c) {
            this.invoker.invokeFinishBundle((DoFnInvoker.ArgumentProvider)new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
                    return new DoFn.FinishBundleContext(){

                        public PipelineOptions getPipelineOptions() {
                            return c.getPipelineOptions();
                        }

                        public void output(@Nullable OutputT output, Instant timestamp, BoundedWindow window) {
                            throw new UnsupportedOperationException("Output from FinishBundle for SDF is not supported in naive implementation");
                        }

                        public <T> void output(TupleTag<T> tag, T output, Instant timestamp, BoundedWindow window) {
                            throw new UnsupportedOperationException("Output from FinishBundle for SDF is not supported in naive implementation");
                        }
                    };
                }

                public PipelineOptions pipelineOptions() {
                    return c.getPipelineOptions();
                }

                public String getErrorContext() {
                    return "SplittableParDoNaiveBounded/StartBundle";
                }
            });
        }

        @DoFn.Teardown
        public void teardown() {
            this.invoker.invokeTeardown();
        }

        private static class NestedProcessContext<InputT, OutputT, RestrictionT, TrackerT extends RestrictionTracker<RestrictionT, ?>, WatermarkEstimatorStateT, WatermarkEstimatorT extends WatermarkEstimator<WatermarkEstimatorStateT>>
        extends DoFn.ProcessContext
        implements DoFnInvoker.ArgumentProvider<InputT, OutputT> {
            private final BoundedWindow window;
            private final DoFn.ProcessContext outerContext;
            private final InputT element;
            private final TrackerT tracker;
            private final WatermarkEstimatorT watermarkEstimator;
            private final Map<String, PCollectionView<?>> sideInputMapping;

            private NestedProcessContext(DoFn<InputT, OutputT> fn, DoFn.ProcessContext outerContext, InputT element, BoundedWindow window, TrackerT tracker, WatermarkEstimatorT watermarkEstimator, Map<String, PCollectionView<?>> sideInputMapping) {
                super(fn);
                this.window = window;
                this.outerContext = outerContext;
                this.element = element;
                this.tracker = tracker;
                this.watermarkEstimator = watermarkEstimator;
                this.sideInputMapping = sideInputMapping;
            }

            public BoundedWindow window() {
                return this.window;
            }

            public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
                return this.outerContext.pane();
            }

            public PipelineOptions pipelineOptions() {
                return this.outerContext.getPipelineOptions();
            }

            public DoFn.ProcessContext processContext(DoFn<InputT, OutputT> doFn) {
                return this;
            }

            public DoFn.OnTimerContext onTimerContext(DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException();
            }

            public InputT element(DoFn<InputT, OutputT> doFn) {
                return this.element;
            }

            public Object key() {
                throw new UnsupportedOperationException();
            }

            public Object sideInput(String tagId) {
                PCollectionView<?> view = this.sideInputMapping.get(tagId);
                if (view == null) {
                    throw new IllegalArgumentException("calling getSideInput() with unknown view");
                }
                return this.sideInput(view);
            }

            public TimerMap timerFamily(String tagId) {
                throw new UnsupportedOperationException();
            }

            public Object schemaElement(int index) {
                throw new UnsupportedOperationException();
            }

            public Instant timestamp(DoFn<InputT, OutputT> doFn) {
                return this.outerContext.timestamp();
            }

            public String timerId(DoFn<InputT, OutputT> doFn) {
                throw new UnsupportedOperationException();
            }

            public DoFn.OutputReceiver<OutputT> outputReceiver(DoFn<InputT, OutputT> doFn) {
                return new DoFn.OutputReceiver<OutputT>(){

                    public void output(OutputT output) {
                        outerContext.output(output);
                    }

                    public void outputWithTimestamp(OutputT output, Instant timestamp) {
                        outerContext.outputWithTimestamp(output, timestamp);
                    }
                };
            }

            public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn<InputT, OutputT> doFn) {
                return new DoFn.MultiOutputReceiver(){

                    public <T> DoFn.OutputReceiver<T> get(final TupleTag<T> tag) {
                        return new DoFn.OutputReceiver<T>(){

                            public void output(T output) {
                                outerContext.output(tag, output);
                            }

                            public void outputWithTimestamp(T output, Instant timestamp) {
                                outerContext.outputWithTimestamp(tag, output, timestamp);
                            }
                        };
                    }

                    public <T> DoFn.OutputReceiver<Row> getRowReceiver(TupleTag<T> tag) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public DoFn.BundleFinalizer bundleFinalizer() {
                throw new UnsupportedOperationException();
            }

            public Object restriction() {
                return this.tracker.currentRestriction();
            }

            public RestrictionTracker<?, ?> restrictionTracker() {
                return this.tracker;
            }

            public PipelineOptions getPipelineOptions() {
                return this.outerContext.getPipelineOptions();
            }

            public void output(OutputT output) {
                this.outerContext.output(output);
            }

            public void outputWithTimestamp(OutputT output, Instant timestamp) {
                this.outerContext.outputWithTimestamp(output, timestamp);
            }

            public <T> void output(TupleTag<T> tag, T output) {
                this.outerContext.output(tag, output);
            }

            public <T> void outputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
                this.outerContext.outputWithTimestamp(tag, output, timestamp);
            }

            public InputT element() {
                return this.element;
            }

            public <T> T sideInput(PCollectionView<T> view) {
                return (T)this.outerContext.sideInput(view);
            }

            public Instant timestamp() {
                return this.outerContext.timestamp();
            }

            public PaneInfo pane() {
                return this.outerContext.pane();
            }

            public Object watermarkEstimatorState() {
                throw new UnsupportedOperationException("@WatermarkEstimatorState parameters are not supported.");
            }

            public WatermarkEstimator<?> watermarkEstimator() {
                return this.watermarkEstimator;
            }

            public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException();
            }

            public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException();
            }

            public DoFn.OutputReceiver<Row> outputRowReceiver(DoFn<InputT, OutputT> doFn) {
                throw new UnsupportedOperationException();
            }

            public TimeDomain timeDomain(DoFn<InputT, OutputT> doFn) {
                throw new IllegalStateException();
            }

            public State state(String stateId, boolean alwaysFetched) {
                throw new UnsupportedOperationException();
            }

            public Timer timer(String timerId) {
                throw new UnsupportedOperationException();
            }

            /* synthetic */ NestedProcessContext(DoFn x0, DoFn.ProcessContext x1, Object x2, BoundedWindow x3, RestrictionTracker x4, WatermarkEstimator x5, Map x6, 1 x7) {
                this(x0, x1, x2, x3, x4, x5, x6);
            }
        }
    }

    static class SplittableProcessNaive<InputT, OutputT, RestrictionT, PositionT, WatermarkEstimatorStateT>
    extends PTransform<PCollection<KV<byte[], KV<InputT, RestrictionT>>>, PCollectionTuple> {
        private final SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT> original;

        SplittableProcessNaive(SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT> original) {
            this.original = original;
        }

        public PCollectionTuple expand(PCollection<KV<byte[], KV<InputT, RestrictionT>>> input) {
            return (PCollectionTuple)((PCollection)((PCollection)input.apply("Reshuffle", (PTransform)Reshuffle.of())).apply("Drop key", (PTransform)Values.create())).apply("NaiveProcess", (PTransform)ParDo.of(new NaiveProcessFn(this.original.getFn(), this.original.getSideInputMapping())).withSideInputs(this.original.getSideInputs()).withOutputTags(this.original.getMainOutputTag(), this.original.getAdditionalOutputTags()));
        }
    }

    public static class OverrideFactory<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT>
    implements PTransformOverrideFactory<PCollection<KV<byte[], KV<InputT, RestrictionT>>>, PCollectionTuple, SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT>> {
        public PTransformOverrideFactory.PTransformReplacement<PCollection<KV<byte[], KV<InputT, RestrictionT>>>, PCollectionTuple> getReplacementTransform(AppliedPTransform<PCollection<KV<byte[], KV<InputT, RestrictionT>>>, PCollectionTuple, SplittableParDo.ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT>> transform) {
            Preconditions.checkArgument((DoFnSignatures.signatureForDoFn(((SplittableParDo.ProcessKeyedElements)transform.getTransform()).getFn()).isBoundedPerElement() == PCollection.IsBounded.BOUNDED ? 1 : 0) != 0, (Object)"Expecting a bounded-per-element splittable DoFn");
            return PTransformOverrideFactory.PTransformReplacement.of(PTransformReplacements.getSingletonMainInput(transform), new SplittableProcessNaive((SplittableParDo.ProcessKeyedElements)transform.getTransform()));
        }

        public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollectionTuple newOutput) {
            return ReplacementOutputs.tagged(outputs, (POutput)newOutput);
        }
    }
}

