/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.debug;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.beam.fn.harness.debug.OutputSampler;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ProtocolStringList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSampler {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DataSampler.class);
    private static final @UnknownKeyFor @NonNull @Initialized String ENABLE_DATA_SAMPLING_EXPERIMENT = "enable_data_sampling";
    private static final @UnknownKeyFor @NonNull @Initialized String ENABLE_ALWAYS_ON_EXCEPTION_SAMPLING_EXPERIMENT = "enable_always_on_exception_sampling";
    private static final @UnknownKeyFor @NonNull @Initialized String DISABLE_ALWAYS_ON_EXCEPTION_SAMPLING_EXPERIMENT = "disable_always_on_exception_sampling";
    private final @UnknownKeyFor @NonNull @Initialized int maxSamples;
    private final @UnknownKeyFor @NonNull @Initialized int sampleEveryN;
    private final @UnknownKeyFor @NonNull @Initialized Boolean onlySampleExceptions;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputSampler<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>> outputSamplers = new ConcurrentHashMap();

    @Nullable
    public static @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized DataSampler create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        boolean disableAlwaysOnExceptionSampling = ExperimentalOptions.hasExperiment((PipelineOptions)options, (String)DISABLE_ALWAYS_ON_EXCEPTION_SAMPLING_EXPERIMENT);
        boolean enableAlwaysOnExceptionSampling = ExperimentalOptions.hasExperiment((PipelineOptions)options, (String)ENABLE_ALWAYS_ON_EXCEPTION_SAMPLING_EXPERIMENT);
        boolean enableDataSampling = ExperimentalOptions.hasExperiment((PipelineOptions)options, (String)ENABLE_DATA_SAMPLING_EXPERIMENT);
        boolean bl = enableAlwaysOnExceptionSampling = enableAlwaysOnExceptionSampling && !disableAlwaysOnExceptionSampling;
        if (enableDataSampling || enableAlwaysOnExceptionSampling) {
            boolean onlySampleExceptions = enableAlwaysOnExceptionSampling && !enableDataSampling;
            return new DataSampler(onlySampleExceptions);
        }
        return null;
    }

    public DataSampler() {
        this(10, 1000, false);
    }

    public DataSampler(@UnknownKeyFor @NonNull @Initialized Boolean onlySampleExceptions) {
        this(10, 1000, onlySampleExceptions);
    }

    public DataSampler(@UnknownKeyFor @NonNull @Initialized int maxSamples, @UnknownKeyFor @NonNull @Initialized int sampleEveryN, @UnknownKeyFor @NonNull @Initialized Boolean onlySampleExceptions) {
        Preconditions.checkArgument((maxSamples > 0 ? 1 : 0) != 0, (Object)"Expected positive number of samples, did you mean to disable data sampling?");
        Preconditions.checkArgument((sampleEveryN > 0 ? 1 : 0) != 0, (Object)"Expected positive number for sampling period, did you mean to disable data sampling?");
        this.maxSamples = maxSamples;
        this.sampleEveryN = sampleEveryN;
        this.onlySampleExceptions = onlySampleExceptions;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized OutputSampler<T> sampleOutput(@UnknownKeyFor @NonNull @Initialized String pcollectionId, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        return this.outputSamplers.computeIfAbsent(pcollectionId, k -> new OutputSampler(coder, this.maxSamples, this.sampleEveryN, this.onlySampleExceptions));
    }

    public synchronized  @UnknownKeyFor @NonNull @Initialized BeamFnApi.InstructionResponse.Builder handleDataSampleRequest( @UnknownKeyFor @NonNull @Initialized BeamFnApi.InstructionRequest request) {
        BeamFnApi.SampleDataRequest sampleDataRequest = request.getSampleData();
        ProtocolStringList pcollections = sampleDataRequest.getPcollectionIdsList();
        BeamFnApi.SampleDataResponse.Builder response = BeamFnApi.SampleDataResponse.newBuilder();
        this.outputSamplers.forEach((arg_0, arg_1) -> DataSampler.lambda$handleDataSampleRequest$1((List)pcollections, response, arg_0, arg_1));
        return BeamFnApi.InstructionResponse.newBuilder().setSampleData(response);
    }

    private static /* synthetic */ void lambda$handleDataSampleRequest$1(List pcollections, BeamFnApi.SampleDataResponse.Builder response, String pcollectionId, OutputSampler outputSampler) {
        if (!pcollections.isEmpty() && !pcollections.contains(pcollectionId)) {
            return;
        }
        try {
            response.putElementSamples(pcollectionId, BeamFnApi.SampleDataResponse.ElementList.newBuilder().addAllElements(outputSampler.samples()).build());
        }
        catch (IOException e) {
            LOG.warn("Could not encode elements from \"" + pcollectionId + "\" to bytes: " + e);
        }
    }
}

