/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.beam.fn.harness.state.AutoValue_FnApiTimerBundleTracker_Modifications;
import org.apache.beam.fn.harness.state.AutoValue_FnApiTimerBundleTracker_TimerInfo;
import org.apache.beam.runners.core.construction.Timer;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ComparisonChain;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Table;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FnApiTimerBundleTracker<@UnknownKeyFor K> {
    private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized ByteString> encodedCurrentKeySupplier;
    private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized ByteString> encodedCurrentWindowSupplier;
    private final @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Modifications<K>> timerModifications = HashBasedTable.create();

    public FnApiTimerBundleTracker(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, @UnknownKeyFor @NonNull @Initialized Supplier<K> currentKeySupplier, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized BoundedWindow> currentWindowSupplier) {
        this.encodedCurrentKeySupplier = FnApiTimerBundleTracker.memoizeFunction(currentKeySupplier, key -> {
            Preconditions.checkState((keyCoder != null ? 1 : 0) != 0, (Object)"Accessing state in unkeyed context, no key coder available");
            ByteStringOutputStream encodedKeyOut = new ByteStringOutputStream();
            try {
                keyCoder.encode(key, (OutputStream)encodedKeyOut, Coder.Context.NESTED);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return encodedKeyOut.toByteString();
        });
        this.encodedCurrentWindowSupplier = FnApiTimerBundleTracker.memoizeFunction(currentWindowSupplier, window -> {
            ByteStringOutputStream encodedWindowOut = new ByteStringOutputStream();
            try {
                windowCoder.encode(window, (OutputStream)encodedWindowOut);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return encodedWindowOut.toByteString();
        });
    }

    public void reset() {
        this.timerModifications.clear();
    }

    public void timerModified(@UnknownKeyFor @NonNull @Initialized String timerFamilyOrId, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain, @UnknownKeyFor @NonNull @Initialized Timer<K> timer) {
        ByteString windowString;
        ByteString keyString = this.encodedCurrentKeySupplier.get();
        Modifications modifications = (Modifications)this.timerModifications.get((Object)keyString, (Object)(windowString = this.encodedCurrentWindowSupplier.get()));
        if (modifications == null) {
            modifications = Modifications.create();
            this.timerModifications.put((Object)keyString, (Object)windowString, modifications);
        }
        if (!timer.getClearBit()) {
            modifications.getModifiedTimersOrdered(timeDomain).add(TimerInfo.of(timer, timerFamilyOrId, timeDomain));
        }
        modifications.getModifiedTimerIds().put((Object)timerFamilyOrId, (Object)timer.getDynamicTimerTag(), timer);
    }

    public @UnknownKeyFor @NonNull @Initialized Modifications<K> getBundleModifications() {
        ByteString windowString;
        ByteString keyString = this.encodedCurrentKeySupplier.get();
        Modifications modifications = (Modifications)this.timerModifications.get((Object)keyString, (Object)(windowString = this.encodedCurrentWindowSupplier.get()));
        if (modifications == null) {
            modifications = Modifications.create();
            this.timerModifications.put((Object)keyString, (Object)windowString, modifications);
        }
        return modifications;
    }

    public void outputTimers(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized Timer<@UnknownKeyFor @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized @NonNull @Initialized ?>>> getTimersReceiverFromTimerIdFn) {
        for (Table.Cell cell : this.timerModifications.cellSet()) {
            Modifications modifications = (Modifications)cell.getValue();
            if (modifications == null) continue;
            for (Table.Cell timerCell : modifications.getModifiedTimerIds().cellSet()) {
                String timerFamilyOrId = (String)timerCell.getRowKey();
                Timer timer = (Timer)timerCell.getValue();
                try {
                    if (timerFamilyOrId == null || timer == null) continue;
                    getTimersReceiverFromTimerIdFn.apply(timerFamilyOrId).accept(timer);
                }
                catch (Throwable t2) {
                    throw UserCodeException.wrap((Throwable)t2);
                }
            }
        }
    }

    private static <ArgT, ResultT> @UnknownKeyFor @NonNull @Initialized Supplier<ResultT> memoizeFunction(final @UnknownKeyFor @NonNull @Initialized Supplier<ArgT> arg, final @UnknownKeyFor @NonNull @Initialized Function<ArgT, ResultT> f) {
        return new Supplier<ResultT>(){
            @Nullable
            private @org.checkerframework.checker.nullness.qual.Nullable ArgT memoizedArg = null;
            @Nullable
            private @org.checkerframework.checker.nullness.qual.Nullable ResultT memoizedResult = null;

            @Override
            public ResultT get() {
                Object currentArg = arg.get();
                if (this.memoizedArg == null || currentArg != this.memoizedArg) {
                    this.memoizedArg = currentArg;
                    this.memoizedResult = f.apply(currentArg);
                }
                if (this.memoizedResult != null) {
                    return this.memoizedResult;
                }
                throw new RuntimeException("Unexpected null result.");
            }
        };
    }

    @AutoValue
    public static abstract class Modifications<@UnknownKeyFor K> {
        public abstract @UnknownKeyFor @NonNull @Initialized NavigableSet<@UnknownKeyFor @NonNull @Initialized TimerInfo<K>> getModifiedEventTimersOrdered();

        public abstract @UnknownKeyFor @NonNull @Initialized NavigableSet<@UnknownKeyFor @NonNull @Initialized TimerInfo<K>> getModifiedProcessingTimersOrdered();

        public abstract @UnknownKeyFor @NonNull @Initialized NavigableSet<@UnknownKeyFor @NonNull @Initialized TimerInfo<K>> getModifiedSynchronizedProcessingTimersOrdered();

        public @UnknownKeyFor @NonNull @Initialized NavigableSet<@UnknownKeyFor @NonNull @Initialized TimerInfo<K>> getModifiedTimersOrdered(@UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            switch (timeDomain) {
                case EVENT_TIME: {
                    return this.getModifiedEventTimersOrdered();
                }
                case PROCESSING_TIME: {
                    return this.getModifiedProcessingTimersOrdered();
                }
                case SYNCHRONIZED_PROCESSING_TIME: {
                    return this.getModifiedSynchronizedProcessingTimersOrdered();
                }
            }
            throw new RuntimeException("Unexpected time domain " + timeDomain);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Timer<K>> getModifiedTimerIds();

        static <K> @UnknownKeyFor @NonNull @Initialized Modifications<K> create() {
            Comparator timeDomainComparator = (td1, td2) -> {
                if (td1 == TimeDomain.PROCESSING_TIME && td2 == TimeDomain.EVENT_TIME) {
                    return -1;
                }
                if (td1 == TimeDomain.EVENT_TIME && td2 == TimeDomain.PROCESSING_TIME) {
                    return 1;
                }
                return td1.compareTo((Enum)td2);
            };
            Comparator comparator = (o1, o2) -> {
                ComparisonChain chain = ComparisonChain.start().compare((Object)o1.getTimeDomain(), (Object)o2.getTimeDomain(), timeDomainComparator).compareTrueFirst(o1.getTimer().getClearBit(), o2.getTimer().getClearBit()).compare((Comparable)o1.getTimer().getFireTimestamp(), (Comparable)o2.getTimer().getFireTimestamp()).compare((Comparable)o1.getTimer().getHoldTimestamp(), (Comparable)o2.getTimer().getHoldTimestamp()).compare((Comparable)((Object)o1.getTimer().getDynamicTimerTag()), (Comparable)((Object)o2.getTimer().getDynamicTimerTag()));
                return chain.result();
            };
            return new AutoValue_FnApiTimerBundleTracker_Modifications(Sets.newTreeSet((Comparator)comparator), Sets.newTreeSet((Comparator)comparator), Sets.newTreeSet((Comparator)comparator), HashBasedTable.create());
        }
    }

    @AutoValue
    public static abstract class TimerInfo<@UnknownKeyFor K> {
        public abstract @UnknownKeyFor @NonNull @Initialized Timer<K> getTimer();

        public abstract @UnknownKeyFor @NonNull @Initialized String getTimerFamilyOrId();

        public abstract @UnknownKeyFor @NonNull @Initialized TimeDomain getTimeDomain();

        public static <K> @UnknownKeyFor @NonNull @Initialized TimerInfo<K> of(@UnknownKeyFor @NonNull @Initialized Timer<K> timer, @UnknownKeyFor @NonNull @Initialized String timerFamilyOrId, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            return new AutoValue_FnApiTimerBundleTracker_TimerInfo<K>(timer, timerFamilyOrId, timeDomain);
        }
    }
}

