/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.Caches;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.StateFetchingIterators;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MultimapSideInput<@UnknownKeyFor K, @UnknownKeyFor V>
implements Materializations.MultimapView<K, V> {
    private static final @UnknownKeyFor @NonNull @Initialized int BULK_READ_SIZE = 100;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cache;
    private final @UnknownKeyFor @NonNull @Initialized BeamFnStateClient beamFnStateClient;
    private final  @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateRequest keysRequest;
    private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;
    private volatile @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<V>> bulkReadResult;
    private final @UnknownKeyFor @NonNull @Initialized boolean useBulkRead;

    public MultimapSideInput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cache, @UnknownKeyFor @NonNull @Initialized BeamFnStateClient beamFnStateClient, @UnknownKeyFor @NonNull @Initialized String instructionId,  @UnknownKeyFor @NonNull @Initialized BeamFnApi.StateKey stateKey, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, @UnknownKeyFor @NonNull @Initialized boolean useBulkRead) {
        Preconditions.checkArgument((boolean)stateKey.hasMultimapKeysSideInput(), (String)"Expected MultimapKeysSideInput StateKey but received %s.", (Object)stateKey);
        this.cache = cache;
        this.beamFnStateClient = beamFnStateClient;
        this.keysRequest = BeamFnApi.StateRequest.newBuilder().setInstructionId(instructionId).setStateKey(stateKey).build();
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
        this.useBulkRead = useBulkRead;
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<K> get() {
        return StateFetchingIterators.readAllAndDecodeStartingFrom(this.cache, this.beamFnStateClient, this.keysRequest, this.keyCoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(K k) {
        ByteString encodedKey = this.encodeKey(k);
        if (this.useBulkRead) {
            Iterable<V> bulkReadValues;
            if (this.bulkReadResult == null) {
                MultimapSideInput multimapSideInput = this;
                synchronized (multimapSideInput) {
                    if (this.bulkReadResult == null) {
                        HashMap<ByteString, Iterable> bulkRead = new HashMap<ByteString, Iterable>();
                        BeamFnApi.StateKey bulkReadStateKey = BeamFnApi.StateKey.newBuilder().setMultimapKeysValuesSideInput(BeamFnApi.StateKey.MultimapKeysValuesSideInput.newBuilder().setTransformId(this.keysRequest.getStateKey().getMultimapKeysSideInput().getTransformId()).setSideInputId(this.keysRequest.getStateKey().getMultimapKeysSideInput().getSideInputId()).setWindow(this.keysRequest.getStateKey().getMultimapKeysSideInput().getWindow())).build();
                        BeamFnApi.StateRequest bulkReadRequest = this.keysRequest.toBuilder().setStateKey(bulkReadStateKey).build();
                        try {
                            Iterator entries = StateFetchingIterators.readAllAndDecodeStartingFrom(Caches.subCache(this.cache, "ValuesForKey", encodedKey), this.beamFnStateClient, bulkReadRequest, KvCoder.of(this.keyCoder, (Coder)IterableCoder.of(this.valueCoder))).iterator();
                            while (bulkRead.size() < 100 && entries.hasNext()) {
                                KV entry = (KV)entries.next();
                                bulkRead.put(this.encodeKey(entry.getKey()), (Iterable)entry.getValue());
                            }
                            this.bulkReadResult = entries.hasNext() ? bulkRead::get : key -> {
                                Iterable result = (Iterable)bulkRead.get(key);
                                if (result == null) {
                                    return Collections.emptyList();
                                }
                                return result;
                            };
                        }
                        catch (Exception exn) {
                            this.bulkReadResult = bulkRead::get;
                        }
                    }
                }
            }
            if ((bulkReadValues = this.bulkReadResult.apply(encodedKey)) != null) {
                return bulkReadValues;
            }
        }
        BeamFnApi.StateKey stateKey = BeamFnApi.StateKey.newBuilder().setMultimapSideInput(BeamFnApi.StateKey.MultimapSideInput.newBuilder().setTransformId(this.keysRequest.getStateKey().getMultimapKeysSideInput().getTransformId()).setSideInputId(this.keysRequest.getStateKey().getMultimapKeysSideInput().getSideInputId()).setWindow(this.keysRequest.getStateKey().getMultimapKeysSideInput().getWindow()).setKey(encodedKey)).build();
        BeamFnApi.StateRequest request = this.keysRequest.toBuilder().setStateKey(stateKey).build();
        return StateFetchingIterators.readAllAndDecodeStartingFrom(Caches.subCache(this.cache, "ValuesForKey", encodedKey), this.beamFnStateClient, request, this.valueCoder);
    }

    private @UnknownKeyFor @NonNull @Initialized ByteString encodeKey(K k) {
        ByteStringOutputStream output = new ByteStringOutputStream();
        try {
            this.keyCoder.encode(k, (OutputStream)output);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to encode key %s for side input id %s.", k, this.keysRequest.getStateKey().getMultimapKeysSideInput().getSideInputId()), e);
        }
        return output.toByteString();
    }
}

