/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.BiMap;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.google.ElementTypesAreNonnullByDefault;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class AbstractBiMapTester<K, V>
extends AbstractMapTester<K, V> {
    @Override
    protected BiMap<K, V> getMap() {
        return (BiMap)super.getMap();
    }

    static <K, V> Map.Entry<V, K> reverseEntry(Map.Entry<K, V> entry) {
        return Helpers.mapEntry(entry.getValue(), entry.getKey());
    }

    @Override
    protected void expectContents(Collection<Map.Entry<K, V>> expected) {
        super.expectContents(expected);
        ArrayList<Map.Entry<V, K>> reversedEntries = new ArrayList<Map.Entry<V, K>>();
        for (Map.Entry<K, V> entry : expected) {
            reversedEntries.add(AbstractBiMapTester.reverseEntry(entry));
        }
        Helpers.assertEqualIgnoringOrder(this.getMap().inverse().entrySet(), reversedEntries);
        for (Map.Entry<K, V> entry : expected) {
            AbstractBiMapTester.assertEquals("Wrong key for value " + entry.getValue(), entry.getKey(), this.getMap().inverse().get(entry.getValue()));
        }
    }

    @Override
    protected void expectMissing(Map.Entry<K, V> ... entries) {
        super.expectMissing(entries);
        for (Map.Entry<K, V> entry : entries) {
            Map.Entry<V, K> reversed = AbstractBiMapTester.reverseEntry(entry);
            BiMap inv = this.getMap().inverse();
            AbstractBiMapTester.assertFalse("Inverse should not contain entry " + reversed, inv.entrySet().contains(reversed));
            AbstractBiMapTester.assertFalse("Inverse should not contain key " + reversed.getKey(), inv.containsKey(reversed.getKey()));
            AbstractBiMapTester.assertFalse("Inverse should not contain value " + reversed.getValue(), inv.containsValue(reversed.getValue()));
            AbstractBiMapTester.assertNull("Inverse should not return a mapping for key " + reversed.getKey(), inv.get(reversed.getKey()));
        }
    }
}

