/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractBiMapTester;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class BiMapEntrySetTester<K, V>
extends AbstractBiMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSetValue_valueAbsent() {
        for (Map.Entry entry : this.getMap().entrySet()) {
            if (!entry.getKey().equals(this.k0())) continue;
            BiMapEntrySetTester.assertEquals("entry.setValue() should return the old value", this.v0(), entry.setValue(this.v3()));
        }
        this.expectReplacement(this.entry(this.k0(), this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testSetValue_valuePresent() {
        for (Map.Entry entry : this.getMap().entrySet()) {
            if (!entry.getKey().equals(this.k0())) continue;
            try {
                entry.setValue(this.v1());
                BiMapEntrySetTester.fail("Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSetValueNullUnsupported() {
        for (Map.Entry entry : this.getMap().entrySet()) {
            try {
                entry.setValue(null);
                BiMapEntrySetTester.fail("Expected NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.expectUnchanged();
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSetValueNullSupported() {
        for (Map.Entry entry : this.getMap().entrySet()) {
            if (!entry.getKey().equals(this.k0())) continue;
            entry.setValue(null);
        }
        this.expectReplacement(this.entry(this.k0(), null));
    }
}

