/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.google.ElementTypesAreNonnullByDefault;
import com.google.common.collect.testing.google.TestStringBiMapGenerator;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public class BiMapGenerators {

    public static class ImmutableBiMapCopyOfEntriesGenerator
    extends TestStringBiMapGenerator {
        @Override
        protected BiMap<String, String> create(Map.Entry<String, String>[] entries) {
            return ImmutableBiMap.copyOf(Arrays.asList(entries));
        }
    }

    public static class ImmutableBiMapCopyOfGenerator
    extends TestStringBiMapGenerator {
        @Override
        protected BiMap<String, String> create(Map.Entry<String, String>[] entries) {
            LinkedHashMap<String, String> builder = Maps.newLinkedHashMap();
            for (Map.Entry<String, String> entry : entries) {
                builder.put(entry.getKey(), entry.getValue());
            }
            return ImmutableBiMap.copyOf(builder);
        }
    }

    public static class ImmutableBiMapGenerator
    extends TestStringBiMapGenerator {
        @Override
        protected BiMap<String, String> create(Map.Entry<String, String>[] entries) {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            for (Map.Entry<String, String> entry : entries) {
                builder.put(entry.getKey(), entry.getValue());
            }
            return builder.build();
        }
    }
}

