/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import com.google.common.collect.testing.google.GoogleHelpers;
import java.util.Collection;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultimapClearTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    public void testClearUnsupported() {
        try {
            this.multimap().clear();
            MultimapClearTester.fail("Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void assertCleared() {
        MultimapClearTester.assertEquals(0, this.multimap().size());
        GoogleHelpers.assertEmpty(this.multimap());
        MultimapClearTester.assertEquals(this.multimap(), ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(new Object[0]));
        Helpers.assertEmpty(this.multimap().entries());
        Helpers.assertEmpty(this.multimap().asMap());
        Helpers.assertEmpty(this.multimap().keySet());
        Helpers.assertEmpty(this.multimap().keys());
        Helpers.assertEmpty(this.multimap().values());
        for (Object key : this.sampleKeys()) {
            this.assertGet(key, new Object[0]);
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClear() {
        this.multimap().clear();
        this.assertCleared();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearThroughEntries() {
        this.multimap().entries().clear();
        this.assertCleared();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearThroughAsMap() {
        this.multimap().asMap().clear();
        this.assertCleared();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearThroughKeySet() {
        this.multimap().keySet().clear();
        this.assertCleared();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearThroughKeys() {
        this.multimap().keys().clear();
        this.assertCleared();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearThroughValues() {
        this.multimap().values().clear();
        this.assertCleared();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testClearPropagatesToGet() {
        for (Object key : this.sampleKeys()) {
            this.resetContainer();
            Collection collection = this.multimap().get(key);
            this.multimap().clear();
            Helpers.assertEmpty(collection);
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testClearPropagatesToAsMapGet() {
        for (Object key : this.sampleKeys()) {
            this.resetContainer();
            Collection collection = this.multimap().asMap().get(key);
            if (collection == null) continue;
            this.multimap().clear();
            Helpers.assertEmpty(collection);
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearPropagatesToAsMap() {
        Map asMap = this.multimap().asMap();
        this.multimap().clear();
        Helpers.assertEmpty(asMap);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearPropagatesToEntries() {
        Collection entries = this.multimap().entries();
        this.multimap().clear();
        Helpers.assertEmpty(entries);
    }
}

