/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultimapEntriesTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    public void testEntries() {
        Helpers.assertEqualIgnoringOrder(this.getSampleElements(), this.multimap().entries());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testContainsEntryWithNullKeyPresent() {
        this.initMultimapWithNullKey();
        Helpers.assertContains(this.multimap().entries(), Helpers.mapEntry(null, this.getValueForNullKey()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testContainsEntryWithNullKeyAbsent() {
        MultimapEntriesTester.assertFalse(this.multimap().entries().contains(Helpers.mapEntry(null, this.v0())));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    public void testContainsEntryWithNullValuePresent() {
        this.initMultimapWithNullValue();
        Helpers.assertContains(this.multimap().entries(), Helpers.mapEntry(this.getKeyForNullValue(), null));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContainsEntryWithNullValueAbsent() {
        MultimapEntriesTester.assertFalse(this.multimap().entries().contains(Helpers.mapEntry(this.k0(), null)));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemovePropagatesToMultimap() {
        MultimapEntriesTester.assertTrue(this.multimap().entries().remove(Helpers.mapEntry(this.k0(), this.v0())));
        this.expectMissing(Helpers.mapEntry(this.k0(), this.v0()));
        MultimapEntriesTester.assertEquals(this.getNumElements() - 1, this.multimap().size());
        MultimapEntriesTester.assertFalse(this.multimap().containsEntry(this.k0(), this.v0()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemoveAllPropagatesToMultimap() {
        MultimapEntriesTester.assertTrue(this.multimap().entries().removeAll(Collections.singleton(Helpers.mapEntry(this.k0(), this.v0()))));
        this.expectMissing(Helpers.mapEntry(this.k0(), this.v0()));
        MultimapEntriesTester.assertEquals(this.getNumElements() - 1, this.multimap().size());
        MultimapEntriesTester.assertFalse(this.multimap().containsEntry(this.k0(), this.v0()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRetainAllPropagatesToMultimap() {
        this.multimap().entries().retainAll(Collections.singleton(Helpers.mapEntry(this.k0(), this.v0())));
        MultimapEntriesTester.assertEquals(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(Helpers.mapEntry(this.k0(), this.v0())), this.multimap());
        MultimapEntriesTester.assertEquals(1, this.multimap().size());
        MultimapEntriesTester.assertTrue(this.multimap().containsEntry(this.k0(), this.v0()));
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testIteratorRemovePropagatesToMultimap() {
        Iterator iterator = this.multimap().entries().iterator();
        MultimapEntriesTester.assertEquals(Helpers.mapEntry(this.k0(), this.v0()), iterator.next());
        iterator.remove();
        MultimapEntriesTester.assertTrue(this.multimap().isEmpty());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testEntriesRemainValidAfterRemove() {
        Iterator iterator = this.multimap().entries().iterator();
        Map.Entry entry = iterator.next();
        Object key = entry.getKey();
        Object value = entry.getValue();
        this.multimap().removeAll(key);
        MultimapEntriesTester.assertEquals(key, entry.getKey());
        MultimapEntriesTester.assertEquals(value, entry.getValue());
    }
}

