/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import com.google.common.collect.testing.google.ElementTypesAreNonnullByDefault;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@ElementTypesAreNonnullByDefault
@GwtCompatible
public class MultimapPutTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testPutUnsupported() {
        try {
            this.multimap().put(this.k3(), this.v3());
            MultimapPutTester.fail("Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutEmpty() {
        int size = this.getNumElements();
        this.assertGet(this.k3(), ImmutableList.of());
        MultimapPutTester.assertTrue(this.multimap().put(this.k3(), this.v3()));
        this.assertGet(this.k3(), this.v3());
        MultimapPutTester.assertEquals(size + 1, this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutPresent() {
        int size = this.getNumElements();
        this.assertGet(this.k0(), this.v0());
        MultimapPutTester.assertTrue(this.multimap().put(this.k0(), this.v3()));
        this.assertGet(this.k0(), this.v0(), this.v3());
        MultimapPutTester.assertEquals(size + 1, this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutTwoElements() {
        int size = this.getNumElements();
        List values = Helpers.copyToList(this.multimap().get(this.k0()));
        MultimapPutTester.assertTrue(this.multimap().put(this.k0(), this.v1()));
        MultimapPutTester.assertTrue(this.multimap().put(this.k0(), this.v2()));
        values.add(this.v1());
        values.add(this.v2());
        this.assertGet(this.k0(), values);
        MultimapPutTester.assertEquals(size + 2, this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPutNullValue_supported() {
        int size = this.getNumElements();
        this.multimap().put(this.k3(), null);
        this.assertGet(this.k3(), Lists.newArrayList(new Object[]{null}));
        MultimapPutTester.assertEquals(size + 1, this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testPutNullValue_unsupported() {
        try {
            this.multimap().put(this.k1(), null);
            MultimapPutTester.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testPutNullKey() {
        int size = this.getNumElements();
        this.multimap().put(null, this.v3());
        this.assertGet(null, this.v3());
        MultimapPutTester.assertEquals(size + 1, this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutNotPresentKeyPropagatesToGet() {
        int size = this.getNumElements();
        Collection collection = this.multimap().get(this.k3());
        Helpers.assertEmpty(collection);
        this.multimap().put(this.k3(), this.v3());
        Helpers.assertContains(collection, this.v3());
        MultimapPutTester.assertEquals(size + 1, this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutNotPresentKeyPropagatesToEntries() {
        Collection entries = this.multimap().entries();
        MultimapPutTester.assertFalse(entries.contains(Helpers.mapEntry(this.k3(), this.v3())));
        this.multimap().put(this.k3(), this.v3());
        Helpers.assertContains(entries, Helpers.mapEntry(this.k3(), this.v3()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutPresentKeyPropagatesToEntries() {
        Collection entries = this.multimap().entries();
        MultimapPutTester.assertFalse(entries.contains(Helpers.mapEntry(this.k0(), this.v3())));
        this.multimap().put(this.k0(), this.v3());
        Helpers.assertContains(entries, Helpers.mapEntry(this.k0(), this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutPresentKeyPropagatesToGet() {
        List keys = Helpers.copyToList(this.multimap().keySet());
        for (Object key : keys) {
            this.resetContainer();
            int size = this.getNumElements();
            Collection collection = this.multimap().get(key);
            List expectedCollection = Helpers.copyToList(collection);
            this.multimap().put(key, this.v3());
            expectedCollection.add(this.v3());
            Helpers.assertEqualIgnoringOrder(expectedCollection, collection);
            MultimapPutTester.assertEquals(size + 1, this.multimap().size());
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutPresentKeyPropagatesToAsMapGet() {
        List keys = Helpers.copyToList(this.multimap().keySet());
        for (Object key : keys) {
            this.resetContainer();
            int size = this.getNumElements();
            Collection collection = this.multimap().asMap().get(key);
            MultimapPutTester.assertNotNull(collection);
            List expectedCollection = Helpers.copyToList(collection);
            this.multimap().put(key, this.v3());
            expectedCollection.add(this.v3());
            Helpers.assertEqualIgnoringOrder(expectedCollection, collection);
            MultimapPutTester.assertEquals(size + 1, this.multimap().size());
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutPresentKeyPropagatesToAsMapEntrySet() {
        List keys = Helpers.copyToList(this.multimap().keySet());
        for (Object key : keys) {
            this.resetContainer();
            int size = this.getNumElements();
            Iterator asMapItr = this.multimap().asMap().entrySet().iterator();
            Collection collection = null;
            while (asMapItr.hasNext()) {
                Map.Entry asMapEntry = asMapItr.next();
                if (!key.equals(asMapEntry.getKey())) continue;
                collection = asMapEntry.getValue();
                break;
            }
            MultimapPutTester.assertNotNull(collection);
            List expectedCollection = Helpers.copyToList(collection);
            this.multimap().put(key, this.v3());
            expectedCollection.add(this.v3());
            Helpers.assertEqualIgnoringOrder(expectedCollection, collection);
            MultimapPutTester.assertEquals(size + 1, this.multimap().size());
        }
    }
}

