/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import com.google.common.collect.testing.google.MultisetFeature;
import java.util.Collections;
import java.util.Iterator;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultisetEntrySetTester<E>
extends AbstractMultisetTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_clear() {
        this.getMultiset().entrySet().clear();
        MultisetEntrySetTester.assertTrue("multiset not empty after entrySet().clear()", this.getMultiset().isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testEntrySet_iteratorRemovePropagates() {
        Iterator iterator = this.getMultiset().entrySet().iterator();
        MultisetEntrySetTester.assertTrue("non-empty multiset.entrySet() iterator.hasNext() returned false", iterator.hasNext());
        MultisetEntrySetTester.assertEquals("multiset.entrySet() iterator.next() returned incorrect entry", Multisets.immutableEntry(this.e0(), 1), iterator.next());
        MultisetEntrySetTester.assertFalse("size 1 multiset.entrySet() iterator.hasNext() returned true after next()", iterator.hasNext());
        iterator.remove();
        MultisetEntrySetTester.assertTrue("multiset isn't empty after multiset.entrySet() iterator.remove()", this.getMultiset().isEmpty());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_removePresent() {
        MultisetEntrySetTester.assertTrue("multiset.entrySet.remove(presentEntry) returned false", this.getMultiset().entrySet().remove(Multisets.immutableEntry(this.e0(), 1)));
        MultisetEntrySetTester.assertFalse("multiset contains element after removing its entry", this.getMultiset().contains(this.e0()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_removeAbsent() {
        MultisetEntrySetTester.assertFalse("multiset.entrySet.remove(missingEntry) returned true", this.getMultiset().entrySet().remove(Multisets.immutableEntry(this.e0(), 2)));
        MultisetEntrySetTester.assertTrue("multiset didn't contain element after removing a missing entry", this.getMultiset().contains(this.e0()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_removeAllPresent() {
        MultisetEntrySetTester.assertTrue("multiset.entrySet.removeAll(presentEntry) returned false", this.getMultiset().entrySet().removeAll(Collections.singleton(Multisets.immutableEntry(this.e0(), 1))));
        MultisetEntrySetTester.assertFalse("multiset contains element after removing its entry", this.getMultiset().contains(this.e0()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_removeAllAbsent() {
        MultisetEntrySetTester.assertFalse("multiset.entrySet.remove(missingEntry) returned true", this.getMultiset().entrySet().removeAll(Collections.singleton(Multisets.immutableEntry(this.e0(), 2))));
        MultisetEntrySetTester.assertTrue("multiset didn't contain element after removing a missing entry", this.getMultiset().contains(this.e0()));
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_retainAllPresent() {
        MultisetEntrySetTester.assertFalse("multiset.entrySet.retainAll(presentEntry) returned false", this.getMultiset().entrySet().retainAll(Collections.singleton(Multisets.immutableEntry(this.e0(), 1))));
        MultisetEntrySetTester.assertTrue("multiset doesn't contains element after retaining its entry", this.getMultiset().contains(this.e0()));
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_retainAllAbsent() {
        MultisetEntrySetTester.assertTrue("multiset.entrySet.retainAll(missingEntry) returned true", this.getMultiset().entrySet().retainAll(Collections.singleton(Multisets.immutableEntry(this.e0(), 2))));
        MultisetEntrySetTester.assertFalse("multiset contains element after retaining a different entry", this.getMultiset().contains(this.e0()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryViewReflectsRemove() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals(3, this.getMultiset().count(this.e0()));
        Multiset.Entry entry = Iterables.getOnlyElement(this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals(3, entry.getCount());
        MultisetEntrySetTester.assertTrue(this.getMultiset().remove(this.e0()));
        MultisetEntrySetTester.assertEquals(2, entry.getCount());
        MultisetEntrySetTester.assertTrue(this.getMultiset().elementSet().remove(this.e0()));
        MultisetEntrySetTester.assertEquals(0, entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsIteratorRemove() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals(3, this.getMultiset().count(this.e0()));
        Multiset.Entry entry = Iterables.getOnlyElement(this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals(3, entry.getCount());
        Iterator itr = this.getMultiset().iterator();
        itr.next();
        itr.remove();
        MultisetEntrySetTester.assertEquals(2, entry.getCount());
        itr.next();
        itr.remove();
        itr.next();
        itr.remove();
        MultisetEntrySetTester.assertEquals(0, entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsClear() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals(3, this.getMultiset().count(this.e0()));
        Multiset.Entry entry = Iterables.getOnlyElement(this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals(3, entry.getCount());
        this.getMultiset().clear();
        MultisetEntrySetTester.assertEquals(0, entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsEntrySetClear() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals(3, this.getMultiset().count(this.e0()));
        Multiset.Entry entry = Iterables.getOnlyElement(this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals(3, entry.getCount());
        this.getMultiset().entrySet().clear();
        MultisetEntrySetTester.assertEquals(0, entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsEntrySetIteratorRemove() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals(3, this.getMultiset().count(this.e0()));
        Iterator entryItr = this.getMultiset().entrySet().iterator();
        Multiset.Entry entry = entryItr.next();
        entryItr.remove();
        MultisetEntrySetTester.assertEquals(0, entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsElementSetClear() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals(3, this.getMultiset().count(this.e0()));
        Multiset.Entry entry = Iterables.getOnlyElement(this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals(3, entry.getCount());
        this.getMultiset().elementSet().clear();
        MultisetEntrySetTester.assertEquals(0, entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsElementSetIteratorRemove() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals(3, this.getMultiset().count(this.e0()));
        Multiset.Entry entry = Iterables.getOnlyElement(this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals(3, entry.getCount());
        Iterator elementItr = this.getMultiset().elementSet().iterator();
        elementItr.next();
        elementItr.remove();
        MultisetEntrySetTester.assertEquals(0, entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ADD})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsRemoveThenAdd() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals(3, this.getMultiset().count(this.e0()));
        Multiset.Entry entry = Iterables.getOnlyElement(this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals(3, entry.getCount());
        MultisetEntrySetTester.assertTrue(this.getMultiset().remove(this.e0()));
        MultisetEntrySetTester.assertEquals(2, entry.getCount());
        MultisetEntrySetTester.assertTrue(this.getMultiset().elementSet().remove(this.e0()));
        MultisetEntrySetTester.assertEquals(0, entry.getCount());
        this.getMultiset().add(this.e0(), 2);
        MultisetEntrySetTester.assertEquals(2, entry.getCount());
    }

    public void testToString() {
        MultisetEntrySetTester.assertEquals(this.getMultiset().entrySet().toString(), this.getMultiset().toString());
    }
}

