/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.Multisets;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Ignore;

@Ignore
@GwtCompatible(emulated=true)
public class MultisetForEachEntryTester<E>
extends AbstractMultisetTester<E> {
    public void testForEachEntry() {
        ArrayList expected = new ArrayList(this.getMultiset().entrySet());
        ArrayList actual = new ArrayList();
        this.getMultiset().forEachEntry((element, count) -> actual.add(Multisets.immutableEntry(element, count)));
        Helpers.assertEqualIgnoringOrder(expected, actual);
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testForEachEntryOrdered() {
        ArrayList expected = new ArrayList(this.getMultiset().entrySet());
        ArrayList actual = new ArrayList();
        this.getMultiset().forEachEntry((element, count) -> actual.add(Multisets.immutableEntry(element, count)));
        MultisetForEachEntryTester.assertEquals(expected, actual);
    }

    public void testForEachEntryDuplicates() {
        this.initThreeCopies();
        List expected = Collections.singletonList(Multisets.immutableEntry(this.e0(), 3));
        ArrayList actual = new ArrayList();
        this.getMultiset().forEachEntry((element, count) -> actual.add(Multisets.immutableEntry(element, count)));
        MultisetForEachEntryTester.assertEquals(expected, actual);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static List<Method> getForEachEntryDuplicateInitializingMethods() {
        return Arrays.asList(Helpers.getMethod(MultisetForEachEntryTester.class, "testForEachEntryDuplicates"));
    }
}

