/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultisetReadsTester<E>
extends AbstractMultisetTester<E> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testElementSet_contains() {
        MultisetReadsTester.assertTrue("multiset.elementSet().contains(present) returned false", this.getMultiset().elementSet().contains(this.e0()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEntrySet_contains() {
        MultisetReadsTester.assertTrue("multiset.entrySet() didn't contain [present, 1]", this.getMultiset().entrySet().contains(Multisets.immutableEntry(this.e0(), 1)));
    }

    public void testEntrySet_contains_count0() {
        MultisetReadsTester.assertFalse("multiset.entrySet() contains [missing, 0]", this.getMultiset().entrySet().contains(Multisets.immutableEntry(this.e3(), 0)));
    }

    public void testEntrySet_contains_nonentry() {
        MultisetReadsTester.assertFalse("multiset.entrySet() contains a non-entry", this.getMultiset().entrySet().contains(this.e0()));
    }

    public void testEntrySet_twice() {
        MultisetReadsTester.assertEquals("calling multiset.entrySet() twice returned unequal sets", this.getMultiset().entrySet(), this.getMultiset().entrySet());
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEntrySet_hashCode_size0() {
        MultisetReadsTester.assertEquals("multiset.entrySet() has incorrect hash code", 0, this.getMultiset().entrySet().hashCode());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testEntrySet_hashCode_size1() {
        MultisetReadsTester.assertEquals("multiset.entrySet() has incorrect hash code", 1 ^ this.e0().hashCode(), this.getMultiset().entrySet().hashCode());
    }

    public void testEquals_yes() {
        MultisetReadsTester.assertTrue("multiset doesn't equal a multiset with the same elements", this.getMultiset().equals(HashMultiset.create(this.getSampleElements())));
    }

    public void testEquals_differentSize() {
        HashMultiset other = HashMultiset.create(this.getSampleElements());
        other.add(this.e0());
        MultisetReadsTester.assertFalse("multiset equals a multiset with a different size", this.getMultiset().equals(other));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEquals_differentElements() {
        HashMultiset other = HashMultiset.create(this.getSampleElements());
        other.remove(this.e0());
        other.add(this.e3());
        MultisetReadsTester.assertFalse("multiset equals a multiset with different elements", this.getMultiset().equals(other));
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testHashCode_size0() {
        MultisetReadsTester.assertEquals("multiset has incorrect hash code", 0, this.getMultiset().hashCode());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testHashCode_size1() {
        MultisetReadsTester.assertEquals("multiset has incorrect hash code", 1 ^ this.e0().hashCode(), this.getMultiset().hashCode());
    }
}

