/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.testing.AbstractCollectionTestSuiteBuilder;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetAddTester;
import com.google.common.collect.testing.google.MultisetContainsTester;
import com.google.common.collect.testing.google.MultisetCountTester;
import com.google.common.collect.testing.google.MultisetElementSetTester;
import com.google.common.collect.testing.google.MultisetEntrySetTester;
import com.google.common.collect.testing.google.MultisetEqualsTester;
import com.google.common.collect.testing.google.MultisetForEachEntryTester;
import com.google.common.collect.testing.google.MultisetIteratorTester;
import com.google.common.collect.testing.google.MultisetReadsTester;
import com.google.common.collect.testing.google.MultisetRemoveTester;
import com.google.common.collect.testing.google.MultisetSerializationTester;
import com.google.common.collect.testing.google.MultisetSetCountConditionallyTester;
import com.google.common.collect.testing.google.MultisetSetCountUnconditionallyTester;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.testers.CollectionSerializationEqualTester;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestSuite;

@GwtIncompatible
public class MultisetTestSuiteBuilder<E>
extends AbstractCollectionTestSuiteBuilder<MultisetTestSuiteBuilder<E>, E> {
    public static <E> MultisetTestSuiteBuilder<E> using(TestMultisetGenerator<E> generator) {
        return (MultisetTestSuiteBuilder)new MultisetTestSuiteBuilder<E>().usingGenerator(generator);
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        List<Class<? extends AbstractTester>> testers = Helpers.copyToList(super.getTesters());
        testers.add(CollectionSerializationEqualTester.class);
        testers.add(MultisetAddTester.class);
        testers.add(MultisetContainsTester.class);
        testers.add(MultisetCountTester.class);
        testers.add(MultisetElementSetTester.class);
        testers.add(MultisetEqualsTester.class);
        testers.add(MultisetForEachEntryTester.class);
        testers.add(MultisetReadsTester.class);
        testers.add(MultisetSetCountConditionallyTester.class);
        testers.add(MultisetSetCountUnconditionallyTester.class);
        testers.add(MultisetRemoveTester.class);
        testers.add(MultisetEntrySetTester.class);
        testers.add(MultisetIteratorTester.class);
        testers.add(MultisetSerializationTester.class);
        return testers;
    }

    private static Set<Feature<?>> computeEntrySetFeatures(Set<Feature<?>> features) {
        HashSet derivedFeatures = new HashSet(features);
        derivedFeatures.remove(CollectionFeature.GENERAL_PURPOSE);
        derivedFeatures.remove(CollectionFeature.SUPPORTS_ADD);
        derivedFeatures.remove(CollectionFeature.ALLOWS_NULL_VALUES);
        derivedFeatures.add(CollectionFeature.REJECTS_DUPLICATES_AT_CREATION);
        if (!derivedFeatures.remove(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS)) {
            derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        }
        return derivedFeatures;
    }

    static Set<Feature<?>> computeElementSetFeatures(Set<Feature<?>> features) {
        HashSet derivedFeatures = new HashSet(features);
        derivedFeatures.remove(CollectionFeature.GENERAL_PURPOSE);
        derivedFeatures.remove(CollectionFeature.SUPPORTS_ADD);
        if (!derivedFeatures.remove(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS)) {
            derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        }
        return derivedFeatures;
    }

    private static Set<Feature<?>> computeReserializedMultisetFeatures(Set<Feature<?>> features) {
        HashSet derivedFeatures = new HashSet(features);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS);
        return derivedFeatures;
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Collection<E>, E>> parentBuilder) {
        ArrayList<TestSuite> derivedSuites = new ArrayList<TestSuite>(super.createDerivedSuites(parentBuilder));
        derivedSuites.add(this.createElementSetTestSuite(parentBuilder));
        if (!parentBuilder.getFeatures().contains(NoRecurse.NO_ENTRY_SET)) {
            derivedSuites.add(((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new EntrySetGenerator(parentBuilder.getSubjectGenerator())).named(this.getName() + ".entrySet")).withFeatures(MultisetTestSuiteBuilder.computeEntrySetFeatures(parentBuilder.getFeatures()))).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite());
        }
        if (parentBuilder.getFeatures().contains(CollectionFeature.SERIALIZABLE)) {
            derivedSuites.add(((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using(new ReserializedMultisetGenerator(parentBuilder.getSubjectGenerator())).named(this.getName() + " reserialized")).withFeatures(MultisetTestSuiteBuilder.computeReserializedMultisetFeatures(parentBuilder.getFeatures()))).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite());
        }
        return derivedSuites;
    }

    TestSuite createElementSetTestSuite(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Collection<E>, E>> parentBuilder) {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new ElementSetGenerator<E>(parentBuilder.getSubjectGenerator())).named(this.getName() + ".elementSet")).withFeatures(MultisetTestSuiteBuilder.computeElementSetFeatures(parentBuilder.getFeatures()))).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite();
    }

    static class ReserializedMultisetGenerator<E>
    implements TestMultisetGenerator<E> {
        final OneSizeTestContainerGenerator<Collection<E>, E> gen;

        private ReserializedMultisetGenerator(OneSizeTestContainerGenerator<Collection<E>, E> gen) {
            this.gen = gen;
        }

        @Override
        public SampleElements<E> samples() {
            return this.gen.samples();
        }

        @Override
        public Multiset<E> create(Object ... elements) {
            return (Multiset)SerializableTester.reserialize((Collection)this.gen.create(elements));
        }

        @Override
        public E[] createArray(int length) {
            return this.gen.createArray(length);
        }

        @Override
        public Iterable<E> order(List<E> insertionOrder) {
            return this.gen.order(insertionOrder);
        }
    }

    static class EntrySetGenerator<E>
    implements TestSetGenerator<Multiset.Entry<E>> {
        final OneSizeTestContainerGenerator<Collection<E>, E> gen;

        private EntrySetGenerator(OneSizeTestContainerGenerator<Collection<E>, E> gen) {
            this.gen = gen;
        }

        @Override
        public SampleElements<Multiset.Entry<E>> samples() {
            SampleElements samples = this.gen.samples();
            return new SampleElements(Multisets.immutableEntry(samples.e0(), 3), Multisets.immutableEntry(samples.e1(), 4), Multisets.immutableEntry(samples.e2(), 1), Multisets.immutableEntry(samples.e3(), 5), Multisets.immutableEntry(samples.e4(), 2));
        }

        @Override
        public Set<Multiset.Entry<E>> create(Object ... entries) {
            ArrayList contents = new ArrayList();
            HashSet elements = new HashSet();
            for (Object o : entries) {
                Multiset.Entry entry = (Multiset.Entry)o;
                Preconditions.checkArgument(elements.add(entry.getElement()), "Duplicate keys not allowed in EntrySetGenerator");
                for (int i = 0; i < entry.getCount(); ++i) {
                    contents.add(entry.getElement());
                }
            }
            return ((Multiset)this.gen.create(contents.toArray())).entrySet();
        }

        public Multiset.Entry<E>[] createArray(int length) {
            return new Multiset.Entry[length];
        }

        @Override
        public Iterable<Multiset.Entry<E>> order(List<Multiset.Entry<E>> insertionOrder) {
            LinkedHashMap<E, Multiset.Entry<E>> map = new LinkedHashMap<E, Multiset.Entry<E>>();
            for (Multiset.Entry<E> entry : insertionOrder) {
                map.put(entry.getElement(), entry);
            }
            HashSet seen = new HashSet();
            ArrayList<Multiset.Entry<Multiset.Entry>> order = new ArrayList<Multiset.Entry<Multiset.Entry>>();
            for (Object e : this.gen.order(new ArrayList(map.keySet()))) {
                if (!seen.add(e)) continue;
                order.add((Multiset.Entry)map.get(e));
            }
            return order;
        }
    }

    static class ElementSetGenerator<E>
    implements TestSetGenerator<E> {
        final OneSizeTestContainerGenerator<Collection<E>, E> gen;

        ElementSetGenerator(OneSizeTestContainerGenerator<Collection<E>, E> gen) {
            this.gen = gen;
        }

        @Override
        public SampleElements<E> samples() {
            return this.gen.samples();
        }

        @Override
        public Set<E> create(Object ... elements) {
            Object[] duplicated = new Object[elements.length * 2];
            for (int i = 0; i < elements.length; ++i) {
                duplicated[i] = elements[i];
                duplicated[i + elements.length] = elements[i];
            }
            return ((Multiset)this.gen.create(duplicated)).elementSet();
        }

        @Override
        public E[] createArray(int length) {
            return this.gen.createArray(length);
        }

        @Override
        public Iterable<E> order(List<E> insertionOrder) {
            return this.gen.order(new ArrayList<E>(new LinkedHashSet<E>(insertionOrder)));
        }
    }

    public static enum NoRecurse implements Feature<Void>
    {
        NO_ENTRY_SET;


        @Override
        public Set<Feature<? super Void>> getImpliedFeatures() {
            return Collections.emptySet();
        }
    }
}

