/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class SetMultimapPutTester<K, V>
extends AbstractMultimapTester<K, V, SetMultimap<K, V>> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutDuplicateValuePreservesSize() {
        SetMultimapPutTester.assertFalse(((SetMultimap)this.multimap()).put(this.k0(), this.v0()));
        SetMultimapPutTester.assertEquals(this.getNumElements(), ((SetMultimap)this.multimap()).size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutDuplicateValue() {
        List<Map.Entry> entries = Helpers.copyToList(((SetMultimap)this.multimap()).entries());
        for (Map.Entry entry : entries) {
            this.resetContainer();
            Object k = entry.getKey();
            Object v = entry.getValue();
            Collection values = ((SetMultimap)this.multimap()).get(k);
            Set expectedValues = Helpers.copyToSet(values);
            SetMultimapPutTester.assertFalse(((SetMultimap)this.multimap()).put(k, v));
            SetMultimapPutTester.assertEquals(expectedValues, values);
            this.assertGet(k, expectedValues);
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutDuplicateValue_null() {
        this.initMultimapWithNullValue();
        SetMultimapPutTester.assertFalse(((SetMultimap)this.multimap()).put(this.getKeyForNullValue(), null));
        this.expectContents(this.createArrayWithNullValue());
    }
}

