/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.testing.google.ElementTypesAreNonnullByDefault;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public class UnmodifiableCollectionTests {
    public static void assertMapEntryIsUnmodifiable(Map.Entry<?, ?> entry) {
        try {
            Map.Entry<?, @Nullable ?> nullableValueEntry = entry;
            nullableValueEntry.setValue(null);
            TestCase.fail("setValue on unmodifiable Map.Entry succeeded");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static void assertIteratorIsUnmodifiable(Iterator<?> iterator) {
        while (iterator.hasNext()) {
            iterator.next();
            try {
                iterator.remove();
                TestCase.fail("Remove on unmodifiable iterator succeeded");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public static void assertIteratorsInOrder(Iterator<?> expectedIterator, Iterator<?> actualIterator) {
        int i = 0;
        while (expectedIterator.hasNext()) {
            Object expected = expectedIterator.next();
            TestCase.assertTrue("index " + i + " expected <" + expected + "., actual is exhausted", actualIterator.hasNext());
            Object actual = actualIterator.next();
            TestCase.assertEquals("index " + i, expected, actual);
            ++i;
        }
        if (actualIterator.hasNext()) {
            TestCase.fail("index " + i + ", expected is exhausted, actual <" + actualIterator.next() + ">");
        }
    }

    public static <E> void assertCollectionIsUnmodifiable(Collection<E> collection, E sampleElement) {
        ArrayList<E> siblingCollection = new ArrayList<E>();
        siblingCollection.add(sampleElement);
        ArrayList copy = new ArrayList();
        Iterators.addAll(copy, collection.iterator());
        try {
            collection.add(sampleElement);
            TestCase.fail("add succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
        try {
            collection.addAll(siblingCollection);
            TestCase.fail("addAll succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
        try {
            collection.clear();
            TestCase.fail("clear succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
        UnmodifiableCollectionTests.assertIteratorIsUnmodifiable(collection.iterator());
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
        try {
            collection.remove(sampleElement);
            TestCase.fail("remove succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
        try {
            collection.removeAll(siblingCollection);
            TestCase.fail("removeAll succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
        try {
            collection.retainAll(siblingCollection);
            TestCase.fail("retainAll succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(copy, collection);
    }

    public static <E> void assertSetIsUnmodifiable(Set<E> set, E sampleElement) {
        UnmodifiableCollectionTests.assertCollectionIsUnmodifiable(set, sampleElement);
    }

    public static <E> void assertMultisetIsUnmodifiable(Multiset<E> multiset, final E sampleElement) {
        LinkedHashMultiset<E> copy = LinkedHashMultiset.create(multiset);
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
        UnmodifiableCollectionTests.assertCollectionIsUnmodifiable(multiset, sampleElement);
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
        try {
            multiset.add(sampleElement, 2);
            TestCase.fail("add(Object, int) succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
        try {
            multiset.remove(sampleElement, 2);
            TestCase.fail("remove(Object, int) succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
        try {
            multiset.removeIf(x -> false);
            TestCase.fail("removeIf(Predicate) succeeded on unmodifiable collection");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
        UnmodifiableCollectionTests.assertSetIsUnmodifiable(multiset.elementSet(), sampleElement);
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
        UnmodifiableCollectionTests.assertSetIsUnmodifiable(multiset.entrySet(), new Multiset.Entry<E>(){

            @Override
            public int getCount() {
                return 1;
            }

            @Override
            public E getElement() {
                return sampleElement;
            }
        });
        UnmodifiableCollectionTests.assertCollectionsAreEquivalent(multiset, copy);
    }

    public static <K, V> void assertMultimapIsUnmodifiable(Multimap<K, V> multimap, K sampleKey, V sampleValue) {
        List<Map.Entry<K, V>> originalEntries = Collections.unmodifiableList(Lists.newArrayList(multimap.entries()));
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        Set<V> sampleValueAsCollection = Collections.singleton(sampleValue);
        try {
            multimap.clear();
            TestCase.fail("clear succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        UnmodifiableCollectionTests.assertSetIsUnmodifiable(multimap.asMap().entrySet(), Maps.immutableEntry(sampleKey, sampleValueAsCollection));
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        if (!multimap.isEmpty()) {
            Collection<V> values = multimap.asMap().entrySet().iterator().next().getValue();
            UnmodifiableCollectionTests.assertCollectionIsUnmodifiable(values, sampleValue);
        }
        UnmodifiableCollectionTests.assertCollectionIsUnmodifiable(multimap.entries(), Maps.immutableEntry(sampleKey, sampleValue));
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        for (Map.Entry entry : multimap.entries()) {
            UnmodifiableCollectionTests.assertMapEntryIsUnmodifiable(entry);
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        UnmodifiableCollectionTests.assertMultisetIsUnmodifiable(multimap.keys(), sampleKey);
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        UnmodifiableCollectionTests.assertSetIsUnmodifiable(multimap.keySet(), sampleKey);
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        if (!multimap.isEmpty()) {
            K key = multimap.keySet().iterator().next();
            UnmodifiableCollectionTests.assertCollectionIsUnmodifiable(multimap.get(key), sampleValue);
            UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        }
        try {
            multimap.put(sampleKey, sampleValue);
            TestCase.fail("put succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException key) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        try {
            multimap.putAll(sampleKey, sampleValueAsCollection);
            TestCase.fail("putAll(K, Iterable) succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException key) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        ArrayListMultimap<K, V> multimap2 = ArrayListMultimap.create();
        multimap2.put(sampleKey, sampleValue);
        try {
            multimap.putAll(multimap2);
            TestCase.fail("putAll(Multimap<K, V>) succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        try {
            multimap.remove(sampleKey, sampleValue);
            TestCase.fail("remove succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        try {
            multimap.removeAll(sampleKey);
            TestCase.fail("removeAll succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        try {
            multimap.replaceValues(sampleKey, sampleValueAsCollection);
            TestCase.fail("replaceValues succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        try {
            multimap.asMap().remove(sampleKey);
            TestCase.fail("asMap().remove() succeeded on unmodifiable multimap");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
        if (!multimap.isEmpty()) {
            K k = multimap.keySet().iterator().next();
            try {
                multimap.asMap().get(k).remove(sampleValue);
                TestCase.fail("asMap().get().remove() succeeded on unmodifiable multimap");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
            try {
                multimap.asMap().values().iterator().next().remove(sampleValue);
                TestCase.fail("asMap().values().iterator().next().remove() succeeded on unmodifiable multimap");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                ((Collection)multimap.asMap().values().toArray()[0]).clear();
                TestCase.fail("asMap().values().toArray()[0].clear() succeeded on unmodifiable multimap");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        UnmodifiableCollectionTests.assertCollectionIsUnmodifiable(multimap.values(), sampleValue);
        UnmodifiableCollectionTests.assertMultimapRemainsUnmodified(multimap, originalEntries);
    }

    private static <E> void assertCollectionsAreEquivalent(Collection<E> expected, Collection<E> actual) {
        UnmodifiableCollectionTests.assertIteratorsInOrder(expected.iterator(), actual.iterator());
    }

    private static <K, V> void assertMultimapRemainsUnmodified(Multimap<K, V> expected, List<Map.Entry<K, V>> actual) {
        UnmodifiableCollectionTests.assertIteratorsInOrder(expected.entries().iterator(), actual.iterator());
    }
}

