/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import java.lang.reflect.Method;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.junit.Ignore;

@Ignore
@GwtCompatible(emulated=true)
public class CollectionAddTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAdd_supportedNotPresent() {
        CollectionAddTester.assertTrue("add(notPresent) should return true", this.collection.add(this.e3()));
        this.expectAdded(this.e3());
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    public void testAdd_unsupportedNotPresent() {
        try {
            this.collection.add(this.e3());
            CollectionAddTester.fail("add(notPresent) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing(this.e3());
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAdd_unsupportedPresent() {
        try {
            CollectionAddTester.assertFalse("add(present) should return false or throw", this.collection.add(this.e0()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.ALLOWS_NULL_VALUES}, absent={CollectionFeature.RESTRICTS_ELEMENTS})
    public void testAdd_nullSupported() {
        CollectionAddTester.assertTrue("add(null) should return true", this.collection.add(null));
        this.expectAdded(new Object[]{null});
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD}, absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testAdd_nullUnsupported() {
        try {
            this.collection.add(null);
            CollectionAddTester.fail("add(null) should throw");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectNullMissingWhenNullUnsupported("Should not contain null after unsupported add(null)");
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddConcurrentWithIteration() {
        try {
            Iterator iterator = this.collection.iterator();
            CollectionAddTester.assertTrue(this.collection.add(this.e3()));
            iterator.next();
            CollectionAddTester.fail("Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getAddNullSupportedMethod() {
        return Helpers.getMethod(CollectionAddTester.class, "testAdd_nullSupported");
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getAddNullUnsupportedMethod() {
        return Helpers.getMethod(CollectionAddTester.class, "testAdd_nullUnsupported");
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getAddUnsupportedNotPresentMethod() {
        return Helpers.getMethod(CollectionAddTester.class, "testAdd_unsupportedNotPresent");
    }
}

