/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.ElementTypesAreNonnullByDefault;
import com.google.common.collect.testing.testers.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.junit.Ignore;

@Ignore
@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public class CollectionIteratorTester<E>
extends AbstractCollectionTester<E> {
    public void testIterator() {
        ArrayList iteratorElements = new ArrayList();
        for (Object element : this.collection) {
            iteratorElements.add(element);
        }
        Helpers.assertEqualIgnoringOrder(Arrays.asList(this.createSamplesArray()), iteratorElements);
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testIterationOrdering() {
        ArrayList iteratorElements = new ArrayList();
        for (Object element : this.collection) {
            iteratorElements.add(element);
        }
        List expected = Helpers.copyToList(this.getOrderedElements());
        CollectionIteratorTester.assertEquals("Different ordered iteration", expected, iteratorElements);
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testIterator_nullElement() {
        this.initCollectionWithNullElement();
        ArrayList iteratorElements = new ArrayList();
        for (Object element : this.collection) {
            iteratorElements.add(element);
        }
        Helpers.assertEqualIgnoringOrder(Arrays.asList(this.createArrayWithNullElement()), iteratorElements);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testIterator_removeAffectsBackingCollection() {
        int originalSize = this.collection.size();
        Iterator iterator = this.collection.iterator();
        Object element = iterator.next();
        if (element instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)element;
            element = Helpers.mapEntry(entry.getKey(), entry.getValue());
        }
        CollectionIteratorTester.assertTrue(this.collection.contains(element));
        iterator.remove();
        CollectionIteratorTester.assertFalse(this.collection.contains(element));
        CollectionIteratorTester.assertEquals(originalSize - 1, this.collection.size());
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testIterator_knownOrderRemoveSupported() {
        this.runIteratorTest(IteratorFeature.MODIFIABLE, AbstractIteratorTester.KnownOrder.KNOWN_ORDER, this.getOrderedElements());
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER}, absent={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testIterator_knownOrderRemoveUnsupported() {
        this.runIteratorTest(IteratorFeature.UNMODIFIABLE, AbstractIteratorTester.KnownOrder.KNOWN_ORDER, this.getOrderedElements());
    }

    @CollectionFeature.Require(absent={CollectionFeature.KNOWN_ORDER}, value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testIterator_unknownOrderRemoveSupported() {
        this.runIteratorTest(IteratorFeature.MODIFIABLE, AbstractIteratorTester.KnownOrder.UNKNOWN_ORDER, this.getSampleElements());
    }

    @CollectionFeature.Require(absent={CollectionFeature.KNOWN_ORDER, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testIterator_unknownOrderRemoveUnsupported() {
        this.runIteratorTest(IteratorFeature.UNMODIFIABLE, AbstractIteratorTester.KnownOrder.UNKNOWN_ORDER, this.getSampleElements());
    }

    private void runIteratorTest(Set<IteratorFeature> features, AbstractIteratorTester.KnownOrder knownOrder, Iterable<E> elements) {
        new IteratorTester<E>(Platform.collectionIteratorTesterNumIterations(), features, elements, knownOrder){

            @Override
            protected Iterator<E> newTargetIterator() {
                CollectionIteratorTester.this.resetCollection();
                return CollectionIteratorTester.this.collection.iterator();
            }

            @Override
            protected void verify(List<E> elements) {
                CollectionIteratorTester.this.expectContents(elements);
            }
        }.test();
    }

    public void testIteratorNoSuchElementException() {
        Iterator iterator = this.collection.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
        try {
            iterator.next();
            CollectionIteratorTester.fail("iterator.next() should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

