/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.function.Predicate;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class CollectionRemoveIfTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testRemoveIf_alwaysFalse() {
        CollectionRemoveIfTester.assertFalse("removeIf(x -> false) should return false", this.collection.removeIf(x -> false));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveIf_sometimesTrue() {
        CollectionRemoveIfTester.assertTrue("removeIf(isEqual(present)) should return true", this.collection.removeIf(Predicate.isEqual(this.samples.e0())));
        this.expectMissing(this.samples.e0());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveIf_allPresent() {
        CollectionRemoveIfTester.assertTrue("removeIf(x -> true) should return true", this.collection.removeIf(x -> true));
        this.expectContents(new Object[0]);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemoveIfSomeMatchesConcurrentWithIteration() {
        try {
            Iterator iterator = this.collection.iterator();
            CollectionRemoveIfTester.assertTrue(this.collection.removeIf(Predicate.isEqual(this.samples.e0())));
            iterator.next();
            CollectionRemoveIfTester.fail("Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testRemoveIf_unsupportedEmptyCollection() {
        try {
            CollectionRemoveIfTester.assertFalse("removeIf(Predicate) should return false or throw UnsupportedOperationException", this.collection.removeIf(x -> {
                throw new AssertionError((Object)"predicate should never be called");
            }));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveIf_alwaysTrueUnsupported() {
        try {
            this.collection.removeIf(x -> true);
            CollectionRemoveIfTester.fail("removeIf(x -> true) should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        CollectionRemoveIfTester.assertTrue(this.collection.contains(this.samples.e0()));
    }
}

