/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.Platform;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class CollectionRetainAllTester<E>
extends AbstractCollectionTester<E> {
    private Target empty;
    private Target disjoint;
    private Target superset;
    private Target nonEmptyProperSubset;
    private Target sameElements;
    private Target partialOverlap;
    private Target containsDuplicates;
    private Target nullSingleton;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.empty = new Target(this, this.emptyCollection(), "empty");
        List<Object> disjointList = Arrays.asList(this.e3(), this.e4());
        this.disjoint = new Target(this, disjointList, "disjoint");
        this.superset = new Target(this, MinimalCollection.of(this.e0(), this.e1(), this.e2(), this.e3(), this.e4()), "superset");
        this.nonEmptyProperSubset = new Target(this, MinimalCollection.of(this.e1()), "subset");
        this.sameElements = new Target(this, Arrays.asList(this.createSamplesArray()), "sameElements");
        this.containsDuplicates = new Target(this, MinimalCollection.of(this.e0(), this.e0(), this.e3(), this.e3()), "containsDuplicates");
        this.partialOverlap = new Target(this, MinimalCollection.of(this.e2(), this.e3()), "partialOverlap");
        this.nullSingleton = new Target(this, Collections.singleton(null), "nullSingleton");
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testRetainAll_emptyPreviouslyEmpty() {
        this.expectReturnsFalse(this.empty);
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testRetainAll_emptyPreviouslyEmptyUnsupported() {
        this.expectReturnsFalseOrThrows(this.empty);
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRetainAll_emptyPreviouslyNonEmpty() {
        this.expectReturnsTrue(this.empty);
        this.expectContents(new Object[0]);
        this.expectMissing(this.e0(), this.e1(), this.e2());
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRetainAll_emptyPreviouslyNonEmptyUnsupported() {
        this.expectThrows(this.empty);
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testRetainAll_disjointPreviouslyEmpty() {
        this.expectReturnsFalse(this.disjoint);
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testRetainAll_disjointPreviouslyEmptyUnsupported() {
        this.expectReturnsFalseOrThrows(this.disjoint);
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRetainAll_disjointPreviouslyNonEmpty() {
        this.expectReturnsTrue(this.disjoint);
        this.expectContents(new Object[0]);
        this.expectMissing(this.e0(), this.e1(), this.e2());
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRetainAll_disjointPreviouslyNonEmptyUnsupported() {
        this.expectThrows(this.disjoint);
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRetainAll_superset() {
        this.expectReturnsFalse(this.superset);
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testRetainAll_supersetUnsupported() {
        this.expectReturnsFalseOrThrows(this.superset);
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testRetainAll_subset() {
        this.expectReturnsTrue(this.nonEmptyProperSubset);
        this.expectContents(this.nonEmptyProperSubset.toRetain);
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testRetainAll_subsetUnsupported() {
        this.expectThrows(this.nonEmptyProperSubset);
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRetainAll_sameElements() {
        this.expectReturnsFalse(this.sameElements);
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testRetainAll_sameElementsUnsupported() {
        this.expectReturnsFalseOrThrows(this.sameElements);
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testRetainAll_partialOverlap() {
        this.expectReturnsTrue(this.partialOverlap);
        this.expectContents(this.e2());
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testRetainAll_partialOverlapUnsupported() {
        this.expectThrows(this.partialOverlap);
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testRetainAll_containsDuplicatesSizeOne() {
        this.expectReturnsFalse(this.containsDuplicates);
        this.expectContents(this.e0());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testRetainAll_containsDuplicatesSizeSeveral() {
        this.expectReturnsTrue(this.containsDuplicates);
        this.expectContents(this.e0());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testRetainAll_nullSingletonPreviouslyEmpty() {
        this.expectReturnsFalse(this.nullSingleton);
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRetainAll_nullSingletonPreviouslyNonEmpty() {
        this.expectReturnsTrue(this.nullSingleton);
        this.expectContents(new Object[0]);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testRetainAll_nullSingletonPreviouslySingletonWithNull() {
        this.initCollectionWithNullElement();
        this.expectReturnsFalse(this.nullSingleton);
        this.expectContents(this.createArrayWithNullElement());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testRetainAll_nullSingletonPreviouslySeveralWithNull() {
        this.initCollectionWithNullElement();
        this.expectReturnsTrue(this.nullSingleton);
        this.expectContents(this.nullSingleton.toRetain);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRetainAll_containsNonNullWithNull() {
        this.initCollectionWithNullElement();
        this.expectReturnsTrue(this.disjoint);
        this.expectContents(new Object[0]);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testRetainAll_nullCollectionReferenceEmptySubject() {
        try {
            this.collection.retainAll(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRetainAll_nullCollectionReferenceNonEmptySubject() {
        try {
            this.collection.retainAll(null);
            CollectionRetainAllTester.fail("retainAll(null) should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void expectReturnsTrue(Target target) {
        String message = Platform.format("retainAll(%s) should return true", target);
        CollectionRetainAllTester.assertTrue(message, this.collection.retainAll(target.toRetain));
    }

    private void expectReturnsFalse(Target target) {
        String message = Platform.format("retainAll(%s) should return false", target);
        CollectionRetainAllTester.assertFalse(message, this.collection.retainAll(target.toRetain));
    }

    private void expectThrows(Target target) {
        try {
            this.collection.retainAll(target.toRetain);
            String message = Platform.format("retainAll(%s) should throw", target);
            CollectionRetainAllTester.fail(message);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void expectReturnsFalseOrThrows(Target target) {
        String message = Platform.format("retainAll(%s) should return false or throw", target);
        try {
            CollectionRetainAllTester.assertFalse(message, this.collection.retainAll(target.toRetain));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private class Target {
        private final Collection<E> toRetain;
        private final String description;

        private Target(CollectionRetainAllTester collectionRetainAllTester, Collection<E> toRetain, String description) {
            this.toRetain = toRetain;
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

