/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.testers.AbstractListTester;
import java.lang.reflect.Method;
import java.util.Collection;
import org.junit.Ignore;

@Ignore
@GwtCompatible(emulated=true)
public class ListSetTester<E>
extends AbstractListTester<E> {
    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSet() {
        this.doTestSet(this.e3());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    public void testSet_null() {
        this.doTestSet(null);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    public void testSet_replacingNull() {
        Object[] elements = this.createSamplesArray();
        int i = this.aValidIndex();
        elements[i] = null;
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(elements);
        this.doTestSet(this.e3());
    }

    private void doTestSet(E newValue) {
        int index = this.aValidIndex();
        Object initialValue = this.getList().get(index);
        ListSetTester.assertEquals("set(i, x) should return the old element at position i.", initialValue, this.getList().set(index, newValue));
        ListSetTester.assertEquals("After set(i, x), get(i) should return x", newValue, this.getList().get(index));
        ListSetTester.assertEquals("set() should not change the size of a list.", this.getNumElements(), this.getList().size());
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    public void testSet_indexTooLow() {
        try {
            this.getList().set(-1, this.e3());
            ListSetTester.fail("set(-1) should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    public void testSet_indexTooHigh() {
        int index = this.getNumElements();
        try {
            this.getList().set(index, this.e3());
            ListSetTester.fail("set(size) should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @ListFeature.Require(absent={ListFeature.SUPPORTS_SET})
    public void testSet_unsupported() {
        try {
            this.getList().set(this.aValidIndex(), this.e3());
            ListSetTester.fail("set() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    @ListFeature.Require(absent={ListFeature.SUPPORTS_SET})
    public void testSet_unsupportedByEmptyList() {
        try {
            this.getList().set(0, this.e3());
            ListSetTester.fail("set() should throw UnsupportedOperationException or IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testSet_nullUnsupported() {
        try {
            this.getList().set(this.aValidIndex(), null);
            ListSetTester.fail("set(null) should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    private int aValidIndex() {
        return this.getList().size() / 2;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getSetNullSupportedMethod() {
        return Helpers.getMethod(ListSetTester.class, "testSet_null");
    }
}

