/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MapComputeIfAbsentTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testComputeIfAbsent_supportedAbsent() {
        MapComputeIfAbsentTester.assertEquals("computeIfAbsent(notPresent, function) should return new value", this.v3(), this.getMap().computeIfAbsent(this.k3(), k -> {
            MapComputeIfAbsentTester.assertEquals(this.k3(), k);
            return this.v3();
        }));
        this.expectAdded((Map.Entry)this.e3());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfAbsent_supportedPresent() {
        MapComputeIfAbsentTester.assertEquals("computeIfAbsent(present, function) should return existing value", this.v0(), this.getMap().computeIfAbsent(this.k0(), k -> {
            throw new AssertionFailedError();
        }));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testComputeIfAbsent_functionReturnsNullNotInserted() {
        MapComputeIfAbsentTester.assertNull("computeIfAbsent(absent, returnsNull) should return null", this.getMap().computeIfAbsent(this.k3(), k -> {
            MapComputeIfAbsentTester.assertEquals(this.k3(), k);
            return null;
        }));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfAbsent_nullTreatedAsAbsent() {
        this.initMapWithNullValue();
        MapComputeIfAbsentTester.assertEquals("computeIfAbsent(presentAssignedToNull, function) should return newValue", this.getValueForNullKey(), this.getMap().computeIfAbsent(this.getKeyForNullValue(), k -> {
            MapComputeIfAbsentTester.assertEquals(this.getKeyForNullValue(), k);
            return this.getValueForNullKey();
        }));
        this.expectReplacement(this.entry(this.getKeyForNullValue(), this.getValueForNullKey()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testComputeIfAbsent_nullKeySupported() {
        this.getMap().computeIfAbsent(null, k -> {
            MapComputeIfAbsentTester.assertNull(k);
            return this.v3();
        });
        this.expectAdded(this.entry(null, this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testComputeIfAbsent_functionThrows() {
        try {
            this.getMap().computeIfAbsent(this.k3(), k -> {
                MapComputeIfAbsentTester.assertEquals(this.k3(), k);
                throw new ExpectedException();
            });
            MapComputeIfAbsentTester.fail("Expected ExpectedException");
        }
        catch (ExpectedException expectedException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testComputeIfAbsent_unsupportedAbsent() {
        try {
            this.getMap().computeIfAbsent(this.k3(), k -> {
                MapComputeIfAbsentTester.assertEquals(this.k3(), k);
                return this.v3();
            });
            MapComputeIfAbsentTester.fail("computeIfAbsent(notPresent, function) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfAbsent_unsupportedPresentExistingValue() {
        try {
            MapComputeIfAbsentTester.assertEquals("computeIfAbsent(present, returnsCurrentValue) should return present or throw", this.v0(), this.getMap().computeIfAbsent(this.k0(), k -> {
                MapComputeIfAbsentTester.assertEquals(this.k0(), k);
                return this.v0();
            }));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfAbsent_unsupportedPresentDifferentValue() {
        try {
            MapComputeIfAbsentTester.assertEquals("computeIfAbsent(present, returnsDifferentValue) should return present or throw", this.v0(), this.getMap().computeIfAbsent(this.k0(), k -> {
                MapComputeIfAbsentTester.assertEquals(this.k0(), k);
                return this.v3();
            }));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_KEYS})
    public void testComputeIfAbsent_nullKeyUnsupported() {
        try {
            this.getMap().computeIfAbsent(null, k -> {
                MapComputeIfAbsentTester.assertNull(k);
                return this.v3();
            });
            MapComputeIfAbsentTester.fail("computeIfAbsent(null, function) should throw");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectNullKeyMissingWhenNullKeysUnsupported("Should not contain null key after unsupported computeIfAbsent(null, function)");
    }

    static class ExpectedException
    extends RuntimeException {
        ExpectedException() {
        }
    }
}

