/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MapEntrySetTester<K, V>
extends AbstractMapTester<K, V> {
    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testEntrySetIteratorRemove() {
        Set entrySet = this.getMap().entrySet();
        Iterator entryItr = entrySet.iterator();
        MapEntrySetTester.assertEquals(this.e0(), entryItr.next());
        entryItr.remove();
        MapEntrySetTester.assertTrue(this.getMap().isEmpty());
        MapEntrySetTester.assertFalse(entrySet.contains(this.e0()));
    }

    public void testContainsEntryWithIncomparableKey() {
        try {
            MapEntrySetTester.assertFalse(this.getMap().entrySet().contains(Helpers.mapEntry(IncomparableType.INSTANCE, this.v0())));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testContainsEntryWithIncomparableValue() {
        try {
            MapEntrySetTester.assertFalse(this.getMap().entrySet().contains(Helpers.mapEntry(this.k0(), IncomparableType.INSTANCE)));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testContainsEntryWithNullKeyAbsent() {
        MapEntrySetTester.assertFalse(this.getMap().entrySet().contains(Helpers.mapEntry(null, this.v0())));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testContainsEntryWithNullKeyPresent() {
        this.initMapWithNullKey();
        MapEntrySetTester.assertTrue(this.getMap().entrySet().contains(Helpers.mapEntry(null, this.getValueForNullKey())));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContainsEntryWithNullValueAbsent() {
        MapEntrySetTester.assertFalse(this.getMap().entrySet().contains(Helpers.mapEntry(this.k0(), null)));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    public void testContainsEntryWithNullValuePresent() {
        this.initMapWithNullValue();
        MapEntrySetTester.assertTrue(this.getMap().entrySet().contains(Helpers.mapEntry(this.getKeyForNullValue(), null)));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSetValue() {
        for (Map.Entry entry : this.getMap().entrySet()) {
            if (!entry.getKey().equals(this.k0())) continue;
            MapEntrySetTester.assertEquals("entry.setValue() should return the old value", this.v0(), entry.setValue(this.v3()));
            break;
        }
        this.expectReplacement(this.entry(this.k0(), this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSetValueWithNullValuesPresent() {
        for (Map.Entry entry : this.getMap().entrySet()) {
            if (!entry.getKey().equals(this.k0())) continue;
            MapEntrySetTester.assertEquals("entry.setValue() should return the old value", this.v0(), entry.setValue(null));
            break;
        }
        this.expectReplacement(this.entry(this.k0(), null));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSetValueWithNullValuesAbsent() {
        for (Map.Entry entry : this.getMap().entrySet()) {
            try {
                entry.setValue(null);
                MapEntrySetTester.fail("Expected NullPointerException");
            }
            catch (NullPointerException exception) {
                break;
            }
        }
        this.expectUnchanged();
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getContainsEntryWithIncomparableKeyMethod() {
        return Helpers.getMethod(MapEntrySetTester.class, "testContainsEntryWithIncomparableKey");
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getContainsEntryWithIncomparableValueMethod() {
        return Helpers.getMethod(MapEntrySetTester.class, "testContainsEntryWithIncomparableValue");
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getSetValueMethod() {
        return Helpers.getMethod(MapEntrySetTester.class, "testSetValue");
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getSetValueWithNullValuesPresentMethod() {
        return Helpers.getMethod(MapEntrySetTester.class, "testSetValueWithNullValuesPresent");
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getSetValueWithNullValuesAbsentMethod() {
        return Helpers.getMethod(MapEntrySetTester.class, "testSetValueWithNullValuesAbsent");
    }

    private static enum IncomparableType {
        INSTANCE;

    }
}

