/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.Collection;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MapHashCodeTester<K, V>
extends AbstractMapTester<K, V> {
    public void testHashCode() {
        int expectedHashCode = 0;
        for (Map.Entry entry : this.getSampleEntries()) {
            expectedHashCode += MapHashCodeTester.hash(entry);
        }
        MapHashCodeTester.assertEquals("A Map's hashCode() should be the sum of those of its entries.", expectedHashCode, this.getMap().hashCode());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testHashCode_containingNullKey() {
        Map.Entry entryWithNull = this.entry(null, this.v3());
        this.runEntryWithNullTest(entryWithNull);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    public void testHashCode_containingNullValue() {
        Map.Entry entryWithNull = this.entry(this.k3(), null);
        this.runEntryWithNullTest(entryWithNull);
    }

    private void runEntryWithNullTest(Map.Entry<K, V> entryWithNull) {
        Collection entries = this.getSampleEntries(this.getNumEntries() - 1);
        entries.add(entryWithNull);
        int expectedHashCode = 0;
        for (Map.Entry entry : entries) {
            expectedHashCode += MapHashCodeTester.hash(entry);
        }
        this.resetContainer((Map)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(entries.toArray()));
        MapHashCodeTester.assertEquals("A Map's hashCode() should be the sum of those of its entries (where a null element in an entry counts as having a hash of zero).", expectedHashCode, this.getMap().hashCode());
    }

    private static int hash(Map.Entry<?, ?> e) {
        return (e.getKey() == null ? 0 : e.getKey().hashCode()) ^ (e.getValue() == null ? 0 : e.getValue().hashCode());
    }
}

