/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Method;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@GwtCompatible(emulated=true)
public class MapPutTester<K, V>
extends AbstractMapTester<K, V> {
    private Map.Entry<K, V> nullKeyEntry;
    private Map.Entry<K, V> nullValueEntry;
    private Map.Entry<K, V> nullKeyValueEntry;
    private Map.Entry<K, V> presentKeyNullValueEntry;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.nullKeyEntry = this.entry(null, this.v3());
        this.nullValueEntry = this.entry(this.k3(), null);
        this.nullKeyValueEntry = this.entry(null, null);
        this.presentKeyNullValueEntry = this.entry(this.k0(), null);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPut_supportedPresent() {
        MapPutTester.assertEquals("put(present, value) should return the old value", this.v0(), this.getMap().put(this.k0(), this.v3()));
        this.expectReplacement(this.entry(this.k0(), this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPut_supportedNotPresent() {
        MapPutTester.assertNull("put(notPresent, value) should return null", this.put((Map.Entry)this.e3()));
        this.expectAdded((Map.Entry)this.e3());
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutAbsentConcurrentWithEntrySetIteration() {
        try {
            Iterator iterator = this.getMap().entrySet().iterator();
            this.put((Map.Entry)this.e3());
            iterator.next();
            MapPutTester.fail("Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutAbsentConcurrentWithKeySetIteration() {
        try {
            Iterator iterator = this.getMap().keySet().iterator();
            this.put((Map.Entry)this.e3());
            iterator.next();
            MapPutTester.fail("Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutAbsentConcurrentWithValueIteration() {
        try {
            Iterator iterator = this.getMap().values().iterator();
            this.put((Map.Entry)this.e3());
            iterator.next();
            MapPutTester.fail("Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testPut_unsupportedNotPresent() {
        try {
            this.put((Map.Entry)this.e3());
            MapPutTester.fail("put(notPresent, value) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing((Map.Entry)this.e3());
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPut_unsupportedPresentExistingValue() {
        try {
            MapPutTester.assertEquals("put(present, existingValue) should return present or throw", this.v0(), this.put((Map.Entry)this.e0()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPut_unsupportedPresentDifferentValue() {
        try {
            this.getMap().put(this.k0(), this.v3());
            MapPutTester.fail("put(present, differentValue) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testPut_nullKeySupportedNotPresent() {
        MapPutTester.assertNull("put(null, value) should return null", this.put(this.nullKeyEntry));
        this.expectAdded(this.nullKeyEntry);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPut_nullKeySupportedPresent() {
        Map.Entry newEntry = this.entry(null, this.v3());
        this.initMapWithNullKey();
        MapPutTester.assertEquals("put(present, value) should return the associated value", this.getValueForNullKey(), this.put(newEntry));
        Map.Entry<K, V>[] expected = this.createArrayWithNullKey();
        expected[this.getNullLocation()] = newEntry;
        this.expectContents(expected);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_KEYS})
    public void testPut_nullKeyUnsupported() {
        try {
            this.put(this.nullKeyEntry);
            MapPutTester.fail("put(null, value) should throw");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectNullKeyMissingWhenNullKeysUnsupported("Should not contain null key after unsupported put(null, value)");
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPut_nullValueSupported() {
        MapPutTester.assertNull("put(key, null) should return null", this.put(this.nullValueEntry));
        this.expectAdded(this.nullValueEntry);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testPut_nullValueUnsupported() {
        try {
            this.put(this.nullValueEntry);
            MapPutTester.fail("put(key, null) should throw");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectNullValueMissingWhenNullValuesUnsupported("Should not contain null value after unsupported put(key, null)");
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPut_replaceWithNullValueSupported() {
        MapPutTester.assertEquals("put(present, null) should return the associated value", this.v0(), this.put(this.presentKeyNullValueEntry));
        this.expectReplacement(this.presentKeyNullValueEntry);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPut_replaceWithNullValueUnsupported() {
        try {
            this.put(this.presentKeyNullValueEntry);
            MapPutTester.fail("put(present, null) should throw");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectNullValueMissingWhenNullValuesUnsupported("Should not contain null after unsupported put(present, null)");
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPut_replaceNullValueWithNullSupported() {
        this.initMapWithNullValue();
        MapPutTester.assertNull("put(present, null) should return the associated value (null)", this.getMap().put(this.getKeyForNullValue(), null));
        this.expectContents(this.createArrayWithNullValue());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPut_replaceNullValueWithNonNullSupported() {
        Map.Entry newEntry = this.entry(this.getKeyForNullValue(), this.v3());
        this.initMapWithNullValue();
        MapPutTester.assertNull("put(present, value) should return the associated value (null)", this.put(newEntry));
        Map.Entry<K, V>[] expected = this.createArrayWithNullValue();
        expected[this.getNullLocation()] = newEntry;
        this.expectContents(expected);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES})
    public void testPut_nullKeyAndValueSupported() {
        MapPutTester.assertNull("put(null, null) should return null", this.put(this.nullKeyValueEntry));
        this.expectAdded(this.nullKeyValueEntry);
    }

    @CanIgnoreReturnValue
    private V put(Map.Entry<K, V> entry) {
        return this.getMap().put(entry.getKey(), entry.getValue());
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getPutNullKeyUnsupportedMethod() {
        return Helpers.getMethod(MapPutTester.class, "testPut_nullKeyUnsupported");
    }
}

