/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractSetTester;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Ignore;

@Ignore
@GwtIncompatible
public class NavigableSetNavigationTester<E>
extends AbstractSetTester<E> {
    private NavigableSet<E> navigableSet;
    private List<E> values;
    private E a;
    private E b;
    private E c;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.navigableSet = (NavigableSet)this.getSet();
        this.values = Helpers.copyToList(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getSampleElements(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getCollectionSize().getNumElements()));
        Collections.sort(this.values, this.navigableSet.comparator());
        if (this.values.size() >= 1) {
            this.a = this.values.get(0);
            if (this.values.size() >= 3) {
                this.b = this.values.get(1);
                this.c = this.values.get(2);
            }
        }
    }

    protected void resetWithHole() {
        super.resetContainer((Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.a, this.c));
        this.navigableSet = (NavigableSet)this.getSet();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptySetPollFirst() {
        NavigableSetNavigationTester.assertNull(this.navigableSet.pollFirst());
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptySetNearby() {
        NavigableSetNavigationTester.assertNull(this.navigableSet.lower(this.e0()));
        NavigableSetNavigationTester.assertNull(this.navigableSet.floor(this.e0()));
        NavigableSetNavigationTester.assertNull(this.navigableSet.ceiling(this.e0()));
        NavigableSetNavigationTester.assertNull(this.navigableSet.higher(this.e0()));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptySetPollLast() {
        NavigableSetNavigationTester.assertNull(this.navigableSet.pollLast());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonSetPollFirst() {
        NavigableSetNavigationTester.assertEquals(this.a, this.navigableSet.pollFirst());
        NavigableSetNavigationTester.assertTrue(this.navigableSet.isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonSetNearby() {
        NavigableSetNavigationTester.assertNull(this.navigableSet.lower(this.e0()));
        NavigableSetNavigationTester.assertEquals(this.a, this.navigableSet.floor(this.e0()));
        NavigableSetNavigationTester.assertEquals(this.a, this.navigableSet.ceiling(this.e0()));
        NavigableSetNavigationTester.assertNull(this.navigableSet.higher(this.e0()));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonSetPollLast() {
        NavigableSetNavigationTester.assertEquals(this.a, this.navigableSet.pollLast());
        NavigableSetNavigationTester.assertTrue(this.navigableSet.isEmpty());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPollFirst() {
        NavigableSetNavigationTester.assertEquals(this.a, this.navigableSet.pollFirst());
        NavigableSetNavigationTester.assertEquals(this.values.subList(1, this.values.size()), Helpers.copyToList(this.navigableSet));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testPollFirstUnsupported() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.navigableSet.pollFirst());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testLowerHole() {
        this.resetWithHole();
        NavigableSetNavigationTester.assertEquals(null, this.navigableSet.lower(this.a));
        NavigableSetNavigationTester.assertEquals(this.a, this.navigableSet.lower(this.b));
        NavigableSetNavigationTester.assertEquals(this.a, this.navigableSet.lower(this.c));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testFloorHole() {
        this.resetWithHole();
        NavigableSetNavigationTester.assertEquals(this.a, this.navigableSet.floor(this.a));
        NavigableSetNavigationTester.assertEquals(this.a, this.navigableSet.floor(this.b));
        NavigableSetNavigationTester.assertEquals(this.c, this.navigableSet.floor(this.c));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testCeilingHole() {
        this.resetWithHole();
        NavigableSetNavigationTester.assertEquals(this.a, this.navigableSet.ceiling(this.a));
        NavigableSetNavigationTester.assertEquals(this.c, this.navigableSet.ceiling(this.b));
        NavigableSetNavigationTester.assertEquals(this.c, this.navigableSet.ceiling(this.c));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testHigherHole() {
        this.resetWithHole();
        NavigableSetNavigationTester.assertEquals(this.c, this.navigableSet.higher(this.a));
        NavigableSetNavigationTester.assertEquals(this.c, this.navigableSet.higher(this.b));
        NavigableSetNavigationTester.assertEquals(null, this.navigableSet.higher(this.c));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testLower() {
        NavigableSetNavigationTester.assertEquals(null, this.navigableSet.lower(this.a));
        NavigableSetNavigationTester.assertEquals(this.a, this.navigableSet.lower(this.b));
        NavigableSetNavigationTester.assertEquals(this.b, this.navigableSet.lower(this.c));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testFloor() {
        NavigableSetNavigationTester.assertEquals(this.a, this.navigableSet.floor(this.a));
        NavigableSetNavigationTester.assertEquals(this.b, this.navigableSet.floor(this.b));
        NavigableSetNavigationTester.assertEquals(this.c, this.navigableSet.floor(this.c));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testCeiling() {
        NavigableSetNavigationTester.assertEquals(this.a, this.navigableSet.ceiling(this.a));
        NavigableSetNavigationTester.assertEquals(this.b, this.navigableSet.ceiling(this.b));
        NavigableSetNavigationTester.assertEquals(this.c, this.navigableSet.ceiling(this.c));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testHigher() {
        NavigableSetNavigationTester.assertEquals(this.b, this.navigableSet.higher(this.a));
        NavigableSetNavigationTester.assertEquals(this.c, this.navigableSet.higher(this.b));
        NavigableSetNavigationTester.assertEquals(null, this.navigableSet.higher(this.c));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPollLast() {
        NavigableSetNavigationTester.assertEquals(this.c, this.navigableSet.pollLast());
        NavigableSetNavigationTester.assertEquals(this.values.subList(0, this.values.size() - 1), Helpers.copyToList(this.navigableSet));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testPollLastUnsupported() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.navigableSet.pollLast());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testDescendingNavigation() {
        ArrayList<E> descending = new ArrayList<E>();
        Iterator<E> i = this.navigableSet.descendingIterator();
        while (i.hasNext()) {
            descending.add(i.next());
        }
        Collections.reverse(descending);
        NavigableSetNavigationTester.assertEquals(this.values, descending);
    }

    public void testEmptySubSet() {
        NavigableSet<E> empty = this.navigableSet.subSet(this.e0(), false, this.e0(), false);
        NavigableSetNavigationTester.assertEquals(new TreeSet(), empty);
    }

    public static Method[] getHoleMethods() {
        return new Method[]{Helpers.getMethod(NavigableSetNavigationTester.class, "testLowerHole"), Helpers.getMethod(NavigableSetNavigationTester.class, "testFloorHole"), Helpers.getMethod(NavigableSetNavigationTester.class, "testCeilingHole"), Helpers.getMethod(NavigableSetNavigationTester.class, "testHigherHole")};
    }
}

