/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractSetTester;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class SetAddAllTester<E>
extends AbstractSetTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAll_supportedSomePresent() {
        SetAddAllTester.assertTrue("add(somePresent) should return true", this.getSet().addAll(MinimalCollection.of(this.e3(), this.e0())));
        this.expectAdded(this.e3());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_withDuplicates() {
        MinimalCollection<Object> elementsToAdd = MinimalCollection.of(this.e3(), this.e4(), this.e3(), this.e4());
        SetAddAllTester.assertTrue("add(hasDuplicates) should return true", this.getSet().addAll(elementsToAdd));
        this.expectAdded(this.e3(), this.e4());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAll_supportedAllPresent() {
        SetAddAllTester.assertFalse("add(allPresent) should return false", this.getSet().addAll(MinimalCollection.of(this.e0())));
        this.expectUnchanged();
    }
}

