/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MinimalSet;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractSetTester;
import java.util.Collection;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class SetEqualsTester<E>
extends AbstractSetTester<E> {
    public void testEquals_otherSetWithSameElements() {
        SetEqualsTester.assertTrue("A Set should equal any other Set containing the same elements.", this.getSet().equals(MinimalSet.from(this.getSampleElements())));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEquals_otherSetWithDifferentElements() {
        Collection elements = this.getSampleElements(this.getNumElements() - 1);
        elements.add(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).samples().e3());
        SetEqualsTester.assertFalse("A Set should not equal another Set containing different elements.", this.getSet().equals(MinimalSet.from(elements)));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testEquals_containingNull() {
        Collection elements = this.getSampleElements(this.getNumElements() - 1);
        elements.add(null);
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(elements.toArray());
        SetEqualsTester.assertTrue("A Set should equal any other Set containing the same elements, even if some elements are null.", this.getSet().equals(MinimalSet.from(elements)));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEquals_otherContainsNull() {
        Collection<Object> elements = this.getSampleElements(this.getNumElements() - 1);
        elements.add(null);
        MinimalSet other = MinimalSet.from(elements);
        SetEqualsTester.assertFalse("Two Sets should not be equal if exactly one of them contains null.", this.getSet().equals(other));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEquals_smallerSet() {
        Collection fewerElements = this.getSampleElements(this.getNumElements() - 1);
        SetEqualsTester.assertFalse("Sets of different sizes should not be equal.", this.getSet().equals(MinimalSet.from(fewerElements)));
    }

    public void testEquals_largerSet() {
        Collection moreElements = this.getSampleElements(this.getNumElements() + 1);
        SetEqualsTester.assertFalse("Sets of different sizes should not be equal.", this.getSet().equals(MinimalSet.from(moreElements)));
    }

    public void testEquals_list() {
        SetEqualsTester.assertFalse("A List should never equal a Set.", this.getSet().equals(Helpers.copyToList(this.getSet())));
    }
}

