/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.google.common.escape.UnicodeEscaper;
import java.io.IOException;
import junit.framework.Assert;

@GwtCompatible
public final class EscaperAsserts {
    private EscaperAsserts() {
    }

    public static void assertBasic(Escaper escaper) throws IOException {
        Assert.assertEquals("", escaper.escape(""));
        try {
            escaper.escape(null);
            Assert.fail("exception not thrown when escaping a null string");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void assertEscaping(CharEscaper escaper, String expected, char c) {
        String escaped = Escapers.computeReplacement(escaper, c);
        Assert.assertNotNull(escaped);
        Assert.assertEquals(expected, escaped);
    }

    public static void assertEscaping(UnicodeEscaper escaper, String expected, int cp) {
        String escaped = Escapers.computeReplacement(escaper, cp);
        Assert.assertNotNull(escaped);
        Assert.assertEquals(expected, escaped);
    }

    public static void assertUnescaped(CharEscaper escaper, char c) {
        Assert.assertNull(Escapers.computeReplacement(escaper, c));
    }

    public static void assertUnescaped(UnicodeEscaper escaper, int cp) {
        Assert.assertNull(Escapers.computeReplacement(escaper, cp));
    }

    public static void assertUnicodeEscaping(UnicodeEscaper escaper, String expected, char hi, char lo) {
        int cp = Character.toCodePoint(hi, lo);
        String escaped = Escapers.computeReplacement(escaper, cp);
        Assert.assertNotNull(escaped);
        Assert.assertEquals(expected, escaped);
    }
}

