/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Assert;

@GwtIncompatible
public abstract class AbstractListenableFutureTest
extends TestCase {
    protected CountDownLatch latch;
    protected ListenableFuture<Boolean> future;

    @Override
    protected void setUp() throws Exception {
        this.latch = new CountDownLatch(1);
        this.future = this.createListenableFuture(Boolean.TRUE, null, this.latch);
    }

    @Override
    protected void tearDown() throws Exception {
        this.latch.countDown();
    }

    protected abstract <V> ListenableFuture<V> createListenableFuture(V var1, @Nullable Exception var2, CountDownLatch var3);

    public void testGetBlocksUntilValueAvailable() throws Throwable {
        AbstractListenableFutureTest.assertFalse(this.future.isDone());
        AbstractListenableFutureTest.assertFalse(this.future.isCancelled());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<Boolean> getResult = executor.submit(() -> (Boolean)this.future.get());
            this.latch.countDown();
            AbstractListenableFutureTest.assertTrue(getResult.get(10L, TimeUnit.SECONDS));
        }
        finally {
            executor.shutdownNow();
        }
        AbstractListenableFutureTest.assertTrue(this.future.isDone());
        AbstractListenableFutureTest.assertFalse(this.future.isCancelled());
    }

    public void testTimeoutOnGetWorksCorrectly() throws InterruptedException, ExecutionException {
        try {
            this.future.get(20L, TimeUnit.MILLISECONDS);
            AbstractListenableFutureTest.fail("Should have timed out trying to get the value.");
        }
        catch (TimeoutException timeoutException) {
        }
        finally {
            this.latch.countDown();
        }
    }

    public void testCanceledFutureThrowsCancellation() throws Exception {
        AbstractListenableFutureTest.assertFalse(this.future.isDone());
        AbstractListenableFutureTest.assertFalse(this.future.isCancelled());
        CountDownLatch successLatch = new CountDownLatch(1);
        new Thread(() -> {
            Assert.assertThrows(CancellationException.class, this.future::get);
            successLatch.countDown();
        }).start();
        AbstractListenableFutureTest.assertFalse(this.future.isDone());
        AbstractListenableFutureTest.assertFalse(this.future.isCancelled());
        this.future.cancel(true);
        AbstractListenableFutureTest.assertTrue(this.future.isDone());
        AbstractListenableFutureTest.assertTrue(this.future.isCancelled());
        AbstractListenableFutureTest.assertTrue(successLatch.await(200L, TimeUnit.MILLISECONDS));
        this.latch.countDown();
    }

    public void testListenersNotifiedOnError() throws Exception {
        CountDownLatch successLatch = new CountDownLatch(1);
        CountDownLatch listenerLatch = new CountDownLatch(1);
        ExecutorService exec = Executors.newCachedThreadPool();
        this.future.addListener(listenerLatch::countDown, exec);
        new Thread(() -> {
            Assert.assertThrows(CancellationException.class, this.future::get);
            successLatch.countDown();
        }).start();
        this.future.cancel(true);
        AbstractListenableFutureTest.assertTrue(this.future.isCancelled());
        AbstractListenableFutureTest.assertTrue(this.future.isDone());
        AbstractListenableFutureTest.assertTrue(successLatch.await(200L, TimeUnit.MILLISECONDS));
        AbstractListenableFutureTest.assertTrue(listenerLatch.await(200L, TimeUnit.MILLISECONDS));
        this.latch.countDown();
        exec.shutdown();
        exec.awaitTermination(100L, TimeUnit.MILLISECONDS);
    }

    public void testAllListenersCompleteSuccessfully() throws InterruptedException, ExecutionException {
        ExecutorService exec = Executors.newCachedThreadPool();
        int listenerCount = 20;
        CountDownLatch listenerLatch = new CountDownLatch(listenerCount);
        for (int i = 0; i < 20; ++i) {
            if (i == 10) {
                new Thread(() -> this.latch.countDown()).start();
            }
            this.future.addListener(listenerLatch::countDown, exec);
        }
        AbstractListenableFutureTest.assertSame(Boolean.TRUE, this.future.get());
        listenerLatch.await(500L, TimeUnit.MILLISECONDS);
        exec.shutdown();
        exec.awaitTermination(500L, TimeUnit.MILLISECONDS);
    }
}

