/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BooleanGenerator
extends Generator<Boolean> {
    public BooleanGenerator() {
        super(Arrays.asList(Boolean.class, Boolean.TYPE));
    }

    @Override
    public Boolean generate(SourceOfRandomness random, GenerationStatus status) {
        return random.nextBoolean();
    }

    @Override
    public List<Boolean> doShrink(SourceOfRandomness random, Boolean larger) {
        return larger != false ? Collections.singletonList(false) : Collections.emptyList();
    }

    @Override
    public BigDecimal magnitude(Object value) {
        return (Boolean)this.narrow(value) != false ? BigDecimal.ONE : BigDecimal.ZERO;
    }
}

